/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.commands;

import java.util.List;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.txn.TxnHandler;
import org.apache.hadoop.hive.metastore.txn.jdbc.ConditionalCommand;
import org.apache.hadoop.hive.metastore.txn.jdbc.InClauseBatchCommand;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class RemoveWriteIdsFromMinHistoryCommand
extends InClauseBatchCommand<Long>
implements ConditionalCommand {
    public RemoveWriteIdsFromMinHistoryCommand(List<Long> txnids) {
        super("DELETE FROM \"MIN_HISTORY_WRITE_ID\" WHERE \"MH_TXNID\" IN (:txnIds)", (SqlParameterSource)new MapSqlParameterSource().addValue("txnIds", txnids), "txnIds", Long::compareTo);
    }

    @Override
    public boolean shouldBeUsed(DatabaseProduct databaseProduct) {
        return TxnHandler.ConfVars.useMinHistoryWriteId();
    }

    @Override
    public void onError(DatabaseProduct databaseProduct, Exception e) {
        if (databaseProduct.isTableNotExistsError(e)) {
            TxnHandler.ConfVars.setUseMinHistoryWriteId(false);
        }
    }
}

