/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools;

import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jdo.Query;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.Batchable;
import org.apache.hadoop.hive.metastore.Deadline;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.QueryWrapper;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.metasummary.MetadataTableSummary;
import org.apache.hadoop.hive.metastore.model.MDatabase;
import org.apache.hadoop.hive.metastore.model.MSerDeInfo;
import org.apache.hadoop.hive.metastore.model.MStorageDescriptor;
import org.apache.hadoop.hive.metastore.model.MTable;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaToolObjectStore
extends ObjectStore {
    private static final Logger LOG = LoggerFactory.getLogger(MetaToolObjectStore.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<?> executeJDOQLSelect(String queryStr) throws Exception {
        boolean committed = false;
        Collection result = null;
        try {
            this.openTransaction();
            try (Query query = this.pm.newQuery(queryStr);){
                result = Collections.unmodifiableCollection(new ArrayList((Collection)query.execute()));
            }
            committed = this.commitTransaction();
        }
        finally {
            if (!committed) {
                result = null;
                this.rollbackTransaction();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long executeJDOQLUpdate(String queryStr) throws Exception {
        boolean committed = false;
        long numUpdated = 0L;
        try {
            this.openTransaction();
            try (Query query = this.pm.newQuery(queryStr);){
                numUpdated = (Long)query.execute();
            }
            committed = this.commitTransaction();
            if (committed) {
                long l = numUpdated;
                return l;
            }
        }
        finally {
            this.rollbackAndCleanup(committed, null);
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> listFSRoots() {
        Object object;
        Query query;
        boolean committed;
        block4: {
            committed = false;
            query = null;
            HashSet<String> fsRoots = new HashSet<String>();
            try {
                this.openTransaction();
                query = this.pm.newQuery(MDatabase.class);
                List mDBs = (List)query.execute();
                this.pm.retrieveAll((Collection)mDBs);
                for (MDatabase mDB : mDBs) {
                    fsRoots.add(mDB.getLocationUri());
                }
                committed = this.commitTransaction();
                if (!committed) break block4;
                object = fsRoots;
            }
            catch (Throwable throwable) {
                this.rollbackAndCleanup(committed, query);
                throw throwable;
            }
            this.rollbackAndCleanup(committed, query);
            return object;
        }
        object = null;
        this.rollbackAndCleanup(committed, query);
        return object;
    }

    private boolean shouldUpdateURI(URI onDiskUri, URI inputUri) {
        String onDiskHost = onDiskUri.getHost();
        String inputHost = inputUri.getHost();
        int onDiskPort = onDiskUri.getPort();
        int inputPort = inputUri.getPort();
        String onDiskScheme = onDiskUri.getScheme();
        String inputScheme = inputUri.getScheme();
        if (inputPort != -1 && inputPort != onDiskPort) {
            return false;
        }
        if (inputScheme != null) {
            if (onDiskScheme == null) {
                return false;
            }
            if (!inputScheme.equalsIgnoreCase(onDiskScheme)) {
                return false;
            }
        }
        if (onDiskHost != null) {
            return inputHost.equalsIgnoreCase(onDiskHost);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateMDatabaseURIRetVal updateMDatabaseURI(URI oldLoc, URI newLoc, boolean dryRun) {
        Iterator iterator;
        boolean committed = false;
        Query query = null;
        HashMap<String, String> updateLocations = new HashMap<String, String>();
        ArrayList<String> badRecords = new ArrayList<String>();
        UpdateMDatabaseURIRetVal retVal = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MDatabase.class);
            List mDBs = (List)query.execute();
            this.pm.retrieveAll((Collection)mDBs);
            for (MDatabase mDB : mDBs) {
                URI locationURI = null;
                String location = mDB.getLocationUri();
                try {
                    locationURI = new Path(location).toUri();
                }
                catch (IllegalArgumentException e) {
                    badRecords.add(location);
                }
                if (locationURI == null) {
                    badRecords.add(location);
                } else if (this.shouldUpdateURI(locationURI, oldLoc)) {
                    String dbLoc = mDB.getLocationUri().replaceAll(oldLoc.toString(), newLoc.toString());
                    updateLocations.put(locationURI.toString(), dbLoc);
                    if (!dryRun) {
                        mDB.setLocationUri(dbLoc);
                    }
                }
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)mDB.getManagedLocationUri())) continue;
                URI managedLocationURI = null;
                String managedLocation = mDB.getManagedLocationUri();
                try {
                    managedLocationURI = new Path(managedLocation).toUri();
                }
                catch (IllegalArgumentException e) {
                    badRecords.add(managedLocation);
                }
                if (managedLocationURI == null) {
                    badRecords.add(managedLocation);
                    continue;
                }
                if (!this.shouldUpdateURI(managedLocationURI, oldLoc)) continue;
                String dbLoc = mDB.getManagedLocationUri().replaceAll(oldLoc.toString(), newLoc.toString());
                updateLocations.put(managedLocationURI.toString(), dbLoc);
                if (dryRun) continue;
                mDB.setManagedLocationUri(dbLoc);
            }
            committed = this.commitTransaction();
            if (committed) {
                retVal = new UpdateMDatabaseURIRetVal(this, badRecords, updateLocations);
            }
            iterator = retVal;
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(committed, query);
            throw throwable;
        }
        this.rollbackAndCleanup(committed, query);
        return iterator;
    }

    private void updatePropURIHelper(URI oldLoc, URI newLoc, String tblPropKey, boolean isDryRun, List<String> badRecords, Map<String, String> updateLocations, Map<String, String> parameters) {
        URI tablePropLocationURI = null;
        if (parameters.containsKey(tblPropKey)) {
            String tablePropLocation = parameters.get(tblPropKey);
            try {
                tablePropLocationURI = new Path(tablePropLocation).toUri();
            }
            catch (IllegalArgumentException e) {
                badRecords.add(tablePropLocation);
            }
            if (tablePropLocationURI == null) {
                badRecords.add(tablePropLocation);
            } else if (this.shouldUpdateURI(tablePropLocationURI, oldLoc)) {
                String tblPropLoc = parameters.get(tblPropKey).replaceAll(oldLoc.toString(), newLoc.toString());
                updateLocations.put(tablePropLocationURI.toString(), tblPropLoc);
                if (!isDryRun) {
                    parameters.put(tblPropKey, tblPropLoc);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdatePropURIRetVal updateTblPropURI(URI oldLoc, URI newLoc, String tblPropKey, boolean isDryRun) {
        Iterator iterator;
        boolean committed = false;
        Query query = null;
        HashMap<String, String> updateLocations = new HashMap<String, String>();
        ArrayList<String> badRecords = new ArrayList<String>();
        UpdatePropURIRetVal retVal = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MTable.class);
            List mTbls = (List)query.execute();
            this.pm.retrieveAll((Collection)mTbls);
            for (MTable mTbl : mTbls) {
                this.updatePropURIHelper(oldLoc, newLoc, tblPropKey, isDryRun, badRecords, updateLocations, mTbl.getParameters());
            }
            committed = this.commitTransaction();
            if (committed) {
                retVal = new UpdatePropURIRetVal(this, badRecords, updateLocations);
            }
            iterator = retVal;
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(committed, query);
            throw throwable;
        }
        this.rollbackAndCleanup(committed, query);
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public UpdatePropURIRetVal updateMStorageDescriptorTblPropURI(URI oldLoc, URI newLoc, String tblPropKey, boolean isDryRun) {
        Iterator iterator;
        boolean committed = false;
        Query query = null;
        HashMap<String, String> updateLocations = new HashMap<String, String>();
        ArrayList<String> badRecords = new ArrayList<String>();
        UpdatePropURIRetVal retVal = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MStorageDescriptor.class);
            List mSDSs = (List)query.execute();
            this.pm.retrieveAll((Collection)mSDSs);
            for (MStorageDescriptor mSDS : mSDSs) {
                this.updatePropURIHelper(oldLoc, newLoc, tblPropKey, isDryRun, badRecords, updateLocations, mSDS.getParameters());
            }
            committed = this.commitTransaction();
            if (committed) {
                retVal = new UpdatePropURIRetVal(this, badRecords, updateLocations);
            }
            iterator = retVal;
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(committed, query);
            throw throwable;
        }
        this.rollbackAndCleanup(committed, query);
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateMStorageDescriptorTblURIRetVal updateMStorageDescriptorTblURI(URI oldLoc, URI newLoc, boolean isDryRun) {
        Iterator iterator;
        boolean committed = false;
        Query query = null;
        HashMap<String, String> updateLocations = new HashMap<String, String>();
        ArrayList<String> badRecords = new ArrayList<String>();
        int numNullRecords = 0;
        UpdateMStorageDescriptorTblURIRetVal retVal = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MStorageDescriptor.class);
            List mSDSs = (List)query.execute();
            this.pm.retrieveAll((Collection)mSDSs);
            for (MStorageDescriptor mSDS : mSDSs) {
                URI locationURI = null;
                String location = mSDS.getLocation();
                if (location == null) {
                    ++numNullRecords;
                    continue;
                }
                try {
                    locationURI = new Path(location).toUri();
                }
                catch (IllegalArgumentException e) {
                    badRecords.add(location);
                }
                if (locationURI == null) {
                    badRecords.add(location);
                    continue;
                }
                if (!this.shouldUpdateURI(locationURI, oldLoc)) continue;
                String tblLoc = mSDS.getLocation().replaceAll(oldLoc.toString(), newLoc.toString());
                updateLocations.put(locationURI.toString(), tblLoc);
                if (isDryRun) continue;
                mSDS.setLocation(tblLoc);
            }
            committed = this.commitTransaction();
            if (committed) {
                retVal = new UpdateMStorageDescriptorTblURIRetVal(this, badRecords, updateLocations, numNullRecords);
            }
            iterator = retVal;
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(committed, query);
            throw throwable;
        }
        this.rollbackAndCleanup(committed, query);
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateSerdeURIRetVal updateSerdeURI(URI oldLoc, URI newLoc, String serdeProp, boolean isDryRun) {
        Iterator iterator;
        boolean committed = false;
        Query query = null;
        HashMap<String, String> updateLocations = new HashMap<String, String>();
        ArrayList<String> badRecords = new ArrayList<String>();
        UpdateSerdeURIRetVal retVal = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MSerDeInfo.class);
            List mSerdes = (List)query.execute();
            this.pm.retrieveAll((Collection)mSerdes);
            for (MSerDeInfo mSerde : mSerdes) {
                if (!mSerde.getParameters().containsKey(serdeProp)) continue;
                String schemaLoc = mSerde.getParameters().get(serdeProp);
                URI schemaLocURI = null;
                try {
                    schemaLocURI = new Path(schemaLoc).toUri();
                }
                catch (IllegalArgumentException e) {
                    badRecords.add(schemaLoc);
                }
                if (schemaLocURI == null) {
                    badRecords.add(schemaLoc);
                    continue;
                }
                if (!this.shouldUpdateURI(schemaLocURI, oldLoc)) continue;
                String newSchemaLoc = schemaLoc.replaceAll(oldLoc.toString(), newLoc.toString());
                updateLocations.put(schemaLocURI.toString(), newSchemaLoc);
                if (isDryRun) continue;
                mSerde.getParameters().put(serdeProp, newSchemaLoc);
            }
            committed = this.commitTransaction();
            if (committed) {
                retVal = new UpdateSerdeURIRetVal(this, badRecords, updateLocations);
            }
            iterator = retVal;
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(committed, query);
            throw throwable;
        }
        this.rollbackAndCleanup(committed, query);
        return iterator;
    }

    public List<MetadataTableSummary> getMetadataSummary(String catalogFilter, String dbFilter, String tableFilter) throws MetaException {
        HashSet<Long> partedTabs = new HashSet<Long>();
        HashSet<Long> nonPartedTabs = new HashSet<Long>();
        HashMap<Long, MetadataTableSummary> summaries = new HashMap<Long, MetadataTableSummary>();
        ArrayList<MetadataTableSummary> metadataTableSummaryList = new ArrayList<MetadataTableSummary>();
        StringBuilder filter = new StringBuilder();
        ArrayList<String> parameterVals = new ArrayList<String>();
        if (!StringUtils.isEmpty((CharSequence)dbFilter)) {
            this.appendPatternCondition(filter, "database.name", dbFilter, parameterVals);
        }
        if (!StringUtils.isEmpty((CharSequence)tableFilter)) {
            this.appendPatternCondition(filter, "tableName", tableFilter, parameterVals);
        }
        try (QueryWrapper query = new QueryWrapper(filter.length() > 0 ? this.pm.newQuery(MTable.class, filter.toString()) : this.pm.newQuery(MTable.class));){
            query.setResult("id, database.catalogName, database.name, tableName, owner, tableType");
            List tables = (List)query.executeWithArray(parameterVals.toArray(new String[0]));
            for (Object[] table : tables) {
                Deadline.checkTimeout();
                long tableId = Long.parseLong(table[0].toString());
                MetadataTableSummary summary = new MetadataTableSummary(String.valueOf(table[1]), String.valueOf(table[2]), String.valueOf(table[3]), String.valueOf(table[4]));
                summary.setTableType(String.valueOf(table[5]));
                summary.setTableId(tableId);
                summaries.put(tableId, summary);
                metadataTableSummaryList.add(summary);
            }
        }
        this.collectColumnSummary(summaries);
        this.collectTabFormatSummary(summaries);
        this.collectPartitionSummary(summaries, partedTabs, nonPartedTabs);
        this.collectBasicStats(summaries, nonPartedTabs, partedTabs);
        return metadataTableSummaryList;
    }

    private void collectPartitionSummary(final Map<Long, MetadataTableSummary> summaries, final Set<Long> partedTabs, final Set<Long> nonPartedTabs) throws MetaException {
        final String queryText0 = "select \"TBL_ID\", count(1) from \"PARTITION_KEYS\" where \"TBL_ID\" in (";
        Batchable.runBatched(this.batchSize, new ArrayList<Long>(summaries.keySet()), new Batchable<Long, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Void> run(List<Long> input) throws Exception {
                Pair<Query<?>, List<Object[]>> qResult = MetaToolObjectStore.this.getResultFromInput(input, queryText0, " group by \"TBL_ID\"");
                try {
                    List result = (List)qResult.getRight();
                    if (result != null) {
                        for (Object[] fields : result) {
                            Deadline.checkTimeout();
                            Long tabId = Long.parseLong(String.valueOf(fields[0]));
                            MetadataTableSummary summary = (MetadataTableSummary)summaries.get(tabId);
                            summary.setPartitionColumnCount(Integer.parseInt(fields[1].toString()));
                            partedTabs.add(tabId);
                        }
                    }
                    summaries.keySet().stream().filter(k -> !partedTabs.contains(k)).forEach(nonPartedTabs::add);
                }
                finally {
                    ((Query)qResult.getLeft()).closeAll();
                }
                return Collections.emptyList();
            }
        });
        final String queryText1 = "select \"TBL_ID\", count(1) from \"PARTITIONS\" where \"TBL_ID\" in (";
        Batchable.runBatched(this.batchSize, new ArrayList<Long>(partedTabs), new Batchable<Long, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Void> run(List<Long> input) throws Exception {
                Pair<Query<?>, List<Object[]>> qResult = MetaToolObjectStore.this.getResultFromInput(input, queryText1, " group by \"TBL_ID\"");
                try {
                    List result = (List)qResult.getRight();
                    if (result != null) {
                        for (Object[] fields : result) {
                            Deadline.checkTimeout();
                            Long tabId = Long.parseLong(String.valueOf(fields[0]));
                            MetadataTableSummary summary = (MetadataTableSummary)summaries.get(tabId);
                            summary.setPartitionCount(Integer.parseInt(fields[1].toString()));
                        }
                    }
                }
                finally {
                    ((Query)qResult.getLeft()).closeAll();
                }
                return Collections.emptyList();
            }
        });
    }

    private void collectColumnSummary(final Map<Long, MetadataTableSummary> summaries) throws MetaException {
        final String queryText0 = "select \"TBL_ID\", count(*), sum(CASE WHEN \"TYPE_NAME\" like 'array%' THEN 1 ELSE 0 END), sum(CASE WHEN \"TYPE_NAME\" like 'struct%' THEN 1 ELSE 0 END), sum(CASE WHEN \"TYPE_NAME\" like 'map%' THEN 1 ELSE 0 END) from \"TBLS\" t join \"SDS\" s on t.\"SD_ID\" = s.\"SD_ID\" join \"CDS\" c on s.\"CD_ID\" = c.\"CD_ID\" join \"COLUMNS_V2\" v on c.\"CD_ID\" = v.\"CD_ID\" where \"TBL_ID\" in (";
        Batchable.runBatched(this.batchSize, new ArrayList<Long>(summaries.keySet()), new Batchable<Long, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Void> run(List<Long> input) throws Exception {
                Pair<Query<?>, List<Object[]>> qResult = MetaToolObjectStore.this.getResultFromInput(input, queryText0, " group by \"TBL_ID\"");
                try {
                    List result = (List)qResult.getRight();
                    if (result != null) {
                        for (Object[] fields : result) {
                            Deadline.checkTimeout();
                            Long tabId = Long.parseLong(String.valueOf(fields[0]));
                            MetadataTableSummary summary = (MetadataTableSummary)summaries.get(tabId);
                            summary.columnSummary(Integer.parseInt(fields[1].toString()), Integer.parseInt(fields[2].toString()), Integer.parseInt(fields[3].toString()), Integer.parseInt(fields[4].toString()));
                        }
                    }
                }
                finally {
                    ((Query)qResult.getLeft()).closeAll();
                }
                return Collections.emptyList();
            }
        });
    }

    private void collectTabFormatSummary(final Map<Long, MetadataTableSummary> summaries) throws MetaException {
        final String queryText0 = "select t.\"TBL_ID\", d.\"SLIB\", s.\"IS_COMPRESSED\" from \"TBLS\" t left join \"SDS\" s on t.\"SD_ID\" = s.\"SD_ID\" left join \"SERDES\" d on d.\"SERDE_ID\" = s.\"SERDE_ID\" where t.\"TBL_ID\" in (";
        final String queryText1 = "select p.\"TBL_ID\", " + this.dbType.toVarChar("p.\"PARAM_VALUE\"") + " from \"TABLE_PARAMS\" p  where p.\"PARAM_KEY\" = 'transactional_properties' and p.\"TBL_ID\" in (";
        final ArrayList transactionTables = new ArrayList();
        Batchable.runBatched(this.batchSize, new ArrayList<Long>(summaries.keySet()), new Batchable<Long, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Void> run(List<Long> input) throws Exception {
                Pair<Query<?>, List<Object[]>> qResult = MetaToolObjectStore.this.getResultFromInput(input, queryText0, "");
                try {
                    List result = (List)qResult.getRight();
                    if (result != null) {
                        for (Object[] fields : result) {
                            Deadline.checkTimeout();
                            Long tabId = Long.parseLong(String.valueOf(fields[0]));
                            MetadataTableSummary summary = (MetadataTableSummary)summaries.get(tabId);
                            String lib = String.valueOf(fields[1]);
                            String compressionType = String.valueOf(fields[2]);
                            MetaToolObjectStore.this.collectTabFormatSummary(transactionTables, tabId, summary, lib, compressionType);
                        }
                    }
                }
                finally {
                    ((Query)qResult.getLeft()).closeAll();
                }
                return Collections.emptyList();
            }
        });
        Batchable.runBatched(this.batchSize, transactionTables, new Batchable<Long, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Void> run(List<Long> input) throws Exception {
                Pair<Query<?>, List<Object[]>> qResult = MetaToolObjectStore.this.getResultFromInput(input, queryText1, "");
                try {
                    List result = (List)qResult.getRight();
                    if (result != null) {
                        for (Object[] fields : result) {
                            Deadline.checkTimeout();
                            Long tabId = Long.parseLong(String.valueOf(fields[0]));
                            MetadataTableSummary summary = (MetadataTableSummary)summaries.get(tabId);
                            String transactionalProperties = String.valueOf(fields[1]);
                            if (!"insert_only".equalsIgnoreCase(transactionalProperties.trim())) continue;
                            summary.setTableType("HIVE_ACID_INSERT_ONLY");
                        }
                    }
                }
                finally {
                    ((Query)qResult.getLeft()).closeAll();
                }
                return Collections.emptyList();
            }
        });
    }

    private Pair<Query<?>, List<Object[]>> getResultFromInput(List<Long> input, String queryText0, String subQ) throws MetaException {
        int size = input.size();
        Object queryText = queryText0 + (size == 0 ? "" : org.apache.commons.lang3.StringUtils.repeat((String)",?", (int)size).substring(1)) + ") " + subQ;
        if (this.dbType.isMYSQL()) {
            queryText = ((String)queryText).replace("\"", "");
        }
        Object[] params = new Object[size];
        for (int i = 0; i < input.size(); ++i) {
            params[i] = input.get(i);
        }
        Deadline.checkTimeout();
        Query query = this.pm.newQuery("javax.jdo.query.SQL", queryText);
        List result = (List)query.executeWithArray(params);
        return Pair.of((Object)query, (Object)result);
    }

    private void collectTabFormatSummary(List<Long> transactionalTables, Long tableId, MetadataTableSummary summary, String slib, String compressionType) {
        String tblType = summary.getTableType();
        String fileType = TableFormat.extractFileFormat(slib);
        Set<String> nonNativeTabTypes = TableFormat.getNonNativeFormats();
        if (nonNativeTabTypes.contains(fileType)) {
            tblType = fileType.toUpperCase();
        } else if (TableType.MANAGED_TABLE.name().equalsIgnoreCase(tblType)) {
            tblType = "HIVE_ACID_FULL";
            transactionalTables.add(tableId);
        } else if (TableType.EXTERNAL_TABLE.name().equalsIgnoreCase(tblType)) {
            tblType = "HIVE_EXTERNAL";
        } else {
            String string = tblType = tblType != null ? tblType.toUpperCase() : "NULL";
        }
        if (compressionType.equals("0") || compressionType.equals("f")) {
            compressionType = "None";
        }
        summary.tableFormatSummary(tblType, compressionType, fileType);
    }

    private void collectBasicStats(final Map<Long, MetadataTableSummary> summaries, Set<Long> nonPartedTabs, Set<Long> partedTabs) throws MetaException {
        final String queryText0 = "select \"TBL_ID\", \"PARAM_KEY\", CAST(" + this.dbType.toVarChar("\"PARAM_VALUE\"") + " AS decimal(21,0)) from \"TABLE_PARAMS\" where \"PARAM_KEY\" in ('totalSize', 'numFiles', 'numRows') and \"TBL_ID\" in (";
        Batchable.runBatched(this.batchSize, new ArrayList<Long>(nonPartedTabs), new Batchable<Long, Void>(){

            @Override
            public List<Void> run(List<Long> input) throws Exception {
                MetaToolObjectStore.this.collectBasicStats(queryText0, input, summaries, "");
                return Collections.emptyList();
            }
        });
        final String queryText1 = "select \"TBL_ID\", \"PARAM_KEY\", sum(CAST(" + this.dbType.toVarChar("\"PARAM_VALUE\"") + " AS decimal(21,0))) from \"PARTITIONS\" t join \"PARTITION_PARAMS\" p on p.\"PART_ID\" = t.\"PART_ID\" where \"PARAM_KEY\" in ('totalSize', 'numFiles', 'numRows') and t.\"TBL_ID\" in (";
        Batchable.runBatched(this.batchSize, new ArrayList<Long>(partedTabs), new Batchable<Long, Void>(){

            @Override
            public List<Void> run(List<Long> input) throws Exception {
                MetaToolObjectStore.this.collectBasicStats(queryText1, input, summaries, " group by \"TBL_ID\", \"PARAM_KEY\"");
                return Collections.emptyList();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectBasicStats(String queryText0, List<Long> input, Map<Long, MetadataTableSummary> summaries, String subQ) throws MetaException {
        Pair<Query<?>, List<Object[]>> qResult = this.getResultFromInput(input, queryText0, subQ);
        try {
            List result = (List)qResult.getRight();
            if (result != null) {
                for (Object[] fields : result) {
                    Deadline.checkTimeout();
                    Long tabId = Long.parseLong(String.valueOf(fields[0]));
                    MetadataTableSummary summary = summaries.get(tabId);
                    this.feedBasicStats(summary, String.valueOf(fields[1]), fields[2]);
                }
            }
        }
        finally {
            ((Query)qResult.getLeft()).closeAll();
        }
    }

    private void feedBasicStats(MetadataTableSummary summary, String key, Object value) {
        if (summary == null || value == null || !org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)value.toString())) {
            return;
        }
        long val = Long.parseLong(value.toString());
        switch (key) {
            case "totalSize": {
                summary.setTotalSize(val);
                break;
            }
            case "numRows": {
                summary.setNumRows(val);
                break;
            }
            case "numFiles": {
                summary.setNumFiles(val);
                break;
            }
            default: {
                throw new AssertionError((Object)"This should never happen!");
            }
        }
    }

    public Set<Long> filterTablesForSummary(List<MetadataTableSummary> tableSummaries, final Integer lastUpdatedDays, final Integer tablesLimit) throws MetaException {
        if (tableSummaries == null || tableSummaries.isEmpty() || tablesLimit != null && tablesLimit == 0) {
            return Collections.emptySet();
        }
        Set<Long> tableIds = tableSummaries.stream().map(MetadataTableSummary::getTableId).collect(Collectors.toSet());
        if (lastUpdatedDays == null && (tablesLimit == null || tableIds.size() < tablesLimit)) {
            return tableIds;
        }
        String tableType = tableSummaries.get(0).getTableType();
        if (!TableFormat.isIcebergFormat(tableType)) {
            LOG.warn("This table type: {} hasn't been supported selecting the summary yet, ignore...", (Object)tableType);
            return tableIds;
        }
        Deadline.checkTimeout();
        List<Long> tables = Batchable.runBatched(this.batchSize, new ArrayList<Long>(tableIds), new Batchable<Long, Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Long> run(List<Long> input) throws Exception {
                int size = input.size();
                Object queryText = "\"TBL_ID\" from \"TABLE_PARAMS\" where \"PARAM_KEY\" = 'current-snapshot-timestamp-ms' " + (String)(lastUpdatedDays != null ? " and CAST(" + MetaToolObjectStore.this.dbType.toVarChar("\"PARAM_VALUE\"") + " AS decimal(21,0)) > " + (System.currentTimeMillis() - (long)(lastUpdatedDays * 24) * 3600000L) : "") + " and \"TBL_ID\" in (" + (size == 0 ? "" : org.apache.commons.lang3.StringUtils.repeat((String)",?", (int)size).substring(1)) + ")  order by CAST(" + MetaToolObjectStore.this.dbType.toVarChar("\"PARAM_VALUE\"") + " AS decimal(21,0)) DESC";
                queryText = tablesLimit != null && tablesLimit >= 0 ? MetaToolObjectStore.this.sqlGenerator.addLimitClause(tablesLimit, (String)queryText) : "select " + (String)queryText;
                if (MetaToolObjectStore.this.dbType.isMYSQL()) {
                    queryText = ((String)queryText).replace("\"", "");
                }
                Object[] params = new Object[size];
                for (int i = 0; i < input.size(); ++i) {
                    params[i] = input.get(i);
                }
                Deadline.checkTimeout();
                Query query = MetaToolObjectStore.this.pm.newQuery("javax.jdo.query.SQL", queryText);
                ArrayList<Long> ids = new ArrayList<Long>();
                try {
                    List result = (List)query.executeWithArray(params);
                    if (result != null) {
                        for (Object fields : result) {
                            ids.add(Long.parseLong(fields.toString()));
                        }
                    }
                }
                finally {
                    query.closeAll();
                }
                return ids;
            }
        });
        return new HashSet<Long>(tables);
    }

    public class UpdateMDatabaseURIRetVal {
        private List<String> badRecords;
        private Map<String, String> updateLocations;

        UpdateMDatabaseURIRetVal(MetaToolObjectStore this$0, List<String> badRecords, Map<String, String> updateLocations) {
            this.badRecords = badRecords;
            this.updateLocations = updateLocations;
        }

        public List<String> getBadRecords() {
            return this.badRecords;
        }

        public void setBadRecords(List<String> badRecords) {
            this.badRecords = badRecords;
        }

        public Map<String, String> getUpdateLocations() {
            return this.updateLocations;
        }

        public void setUpdateLocations(Map<String, String> updateLocations) {
            this.updateLocations = updateLocations;
        }
    }

    public class UpdatePropURIRetVal {
        private List<String> badRecords;
        private Map<String, String> updateLocations;

        UpdatePropURIRetVal(MetaToolObjectStore this$0, List<String> badRecords, Map<String, String> updateLocations) {
            this.badRecords = badRecords;
            this.updateLocations = updateLocations;
        }

        public List<String> getBadRecords() {
            return this.badRecords;
        }

        public void setBadRecords(List<String> badRecords) {
            this.badRecords = badRecords;
        }

        public Map<String, String> getUpdateLocations() {
            return this.updateLocations;
        }

        public void setUpdateLocations(Map<String, String> updateLocations) {
            this.updateLocations = updateLocations;
        }
    }

    public class UpdateMStorageDescriptorTblURIRetVal {
        private List<String> badRecords;
        private Map<String, String> updateLocations;
        private int numNullRecords;

        UpdateMStorageDescriptorTblURIRetVal(MetaToolObjectStore this$0, List<String> badRecords, Map<String, String> updateLocations, int numNullRecords) {
            this.badRecords = badRecords;
            this.updateLocations = updateLocations;
            this.numNullRecords = numNullRecords;
        }

        public List<String> getBadRecords() {
            return this.badRecords;
        }

        public void setBadRecords(List<String> badRecords) {
            this.badRecords = badRecords;
        }

        public Map<String, String> getUpdateLocations() {
            return this.updateLocations;
        }

        public void setUpdateLocations(Map<String, String> updateLocations) {
            this.updateLocations = updateLocations;
        }

        public int getNumNullRecords() {
            return this.numNullRecords;
        }

        public void setNumNullRecords(int numNullRecords) {
            this.numNullRecords = numNullRecords;
        }
    }

    public class UpdateSerdeURIRetVal {
        private List<String> badRecords;
        private Map<String, String> updateLocations;

        UpdateSerdeURIRetVal(MetaToolObjectStore this$0, List<String> badRecords, Map<String, String> updateLocations) {
            this.badRecords = badRecords;
            this.updateLocations = updateLocations;
        }

        public List<String> getBadRecords() {
            return this.badRecords;
        }

        public void setBadRecords(List<String> badRecords) {
            this.badRecords = badRecords;
        }

        public Map<String, String> getUpdateLocations() {
            return this.updateLocations;
        }

        public void setUpdateLocations(Map<String, String> updateLocations) {
            this.updateLocations = updateLocations;
        }
    }

    public static class TableFormat {
        public static final String PARQUET = "parquet";
        public static final String ORC = "orc";
        public static final String AVRO = "avro";
        public static final String JSON = "json";
        public static final String HBASE = "hbase";
        public static final String JDBC = "jdbc";
        public static final String KUDU = "kudu";
        public static final String ICEBERG = "iceberg";
        public static final String TEXT = "text";
        public static final String SEQUENCE = "sequence";
        public static final String OPENCSV = "opencsv";
        public static final String LAZY_SIMPLE = "lazysimple";
        public static final String PASS_THROUGH = "passthrough";
        private static final Set<String> AVAILABLE_FORMATS = new HashSet<String>();

        private TableFormat() {
        }

        public static Set<String> getNonNativeFormats() {
            return new HashSet<String>(Arrays.asList(HBASE, JDBC, KUDU, ICEBERG));
        }

        public static String extractFileFormat(String fileFormat) {
            if (fileFormat == null) {
                return "NULL";
            }
            String lowerCaseFileFormat = fileFormat.toLowerCase();
            Optional<String> result = AVAILABLE_FORMATS.stream().filter(lowerCaseFileFormat::contains).findFirst();
            if (result.isPresent()) {
                String file = result.get();
                if (OPENCSV.equals(file)) {
                    return "openCSV";
                }
                if (LAZY_SIMPLE.equals(file)) {
                    return TEXT;
                }
                return file;
            }
            return fileFormat;
        }

        public static boolean isIcebergFormat(String tableFormat) {
            return ICEBERG.equalsIgnoreCase(tableFormat);
        }

        static {
            Arrays.stream(TableFormat.class.getDeclaredFields()).filter(field -> Modifier.isStatic(field.getModifiers()) && Modifier.isPublic(field.getModifiers())).map(field -> {
                try {
                    return field.get(null);
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError((Object)"This should not happen");
                }
            }).filter(String.class::isInstance).forEach(res -> AVAILABLE_FORMATS.add((String)res));
        }
    }
}

