/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.parser;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.ColumnType;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;

public class ExpressionTree {
    public static final ExpressionTree EMPTY_TREE = new ExpressionTree();
    private TreeNode root = null;
    private final Stack<TreeNode> nodeStack = new Stack();

    public void accept(TreeVisitor treeVisitor) throws MetaException {
        if (this.root != null) {
            this.root.accept(treeVisitor);
        }
    }

    private static void makeFilterForEquals(String keyName, String value, String paramName, Map<String, Object> params, int keyPos, int keyCount, boolean isEq, FilterBuilder fltr) throws MetaException {
        HashMap<String, String> partKeyToVal = new HashMap<String, String>();
        partKeyToVal.put(keyName, value);
        String escapedNameFragment = Warehouse.makePartName(partKeyToVal, (boolean)false);
        if (keyCount == 1) {
            params.put(paramName, escapedNameFragment);
            fltr.append("partitionName ").append(isEq ? "== " : "!= ").append(paramName);
        } else if (keyPos + 1 == keyCount) {
            params.put(paramName, "/" + escapedNameFragment);
            fltr.append(isEq ? "" : "!").append("partitionName.endsWith(").append(paramName).append(")");
        } else if (keyPos == 0) {
            params.put(paramName, escapedNameFragment + "/");
            fltr.append(isEq ? "" : "!").append("partitionName.startsWith(").append(paramName).append(")");
        } else {
            params.put(paramName, "/" + escapedNameFragment + "/");
            fltr.append("partitionName.indexOf(").append(paramName).append(")").append(isEq ? ">= 0" : "< 0");
        }
    }

    public TreeNode getRoot() {
        return this.root;
    }

    public void setRoot(TreeNode tn) {
        this.root = tn;
    }

    public void addIntermediateNode(LogicalOperator andOr) {
        TreeNode rhs = this.nodeStack.pop();
        TreeNode lhs = this.nodeStack.pop();
        TreeNode newNode = new TreeNode(lhs, andOr, rhs);
        this.nodeStack.push(newNode);
        this.root = newNode;
    }

    public void addLeafNode(LeafNode newNode) {
        if (this.root == null) {
            this.root = newNode;
        }
        this.nodeStack.push(newNode);
    }

    public static class TreeNode {
        private TreeNode lhs;
        private LogicalOperator andOr;
        private TreeNode rhs;

        public TreeNode() {
        }

        public TreeNode(TreeNode lhs, LogicalOperator andOr, TreeNode rhs) {
            this.lhs = lhs;
            this.andOr = andOr;
            this.rhs = rhs;
        }

        public TreeNode getLhs() {
            return this.lhs;
        }

        public LogicalOperator getAndOr() {
            return this.andOr;
        }

        public TreeNode getRhs() {
            return this.rhs;
        }

        protected void accept(TreeVisitor visitor) throws MetaException {
            visitor.visit(this);
        }

        public String toString() {
            return "TreeNode{lhs=" + String.valueOf(this.lhs) + ", andOr='" + String.valueOf((Object)this.andOr) + "', rhs=" + String.valueOf(this.rhs) + "}";
        }
    }

    public static class TreeVisitor {
        private void visit(TreeNode node) throws MetaException {
            if (this.shouldStop()) {
                return;
            }
            assert (node != null && node.getLhs() != null && node.getRhs() != null);
            this.beginTreeNode(node);
            node.lhs.accept(this);
            this.midTreeNode(node);
            node.rhs.accept(this);
            this.endTreeNode(node);
        }

        protected void beginTreeNode(TreeNode node) throws MetaException {
        }

        protected void midTreeNode(TreeNode node) throws MetaException {
        }

        protected void endTreeNode(TreeNode node) throws MetaException {
        }

        protected void visit(LeafNode node) throws MetaException {
        }

        protected boolean shouldStop() {
            return false;
        }
    }

    public static class FilterBuilder {
        private final StringBuilder result = new StringBuilder();
        private String errorMessage = null;
        private boolean expectNoErrors = false;

        public FilterBuilder(boolean expectNoErrors) {
            this.expectNoErrors = expectNoErrors;
        }

        public String getFilter() throws MetaException {
            assert (this.errorMessage == null);
            if (this.errorMessage != null) {
                throw new MetaException("Trying to get result after error: " + this.errorMessage);
            }
            return this.result.toString();
        }

        public String toString() {
            try {
                return this.getFilter();
            }
            catch (MetaException ex) {
                throw new RuntimeException(ex);
            }
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public boolean hasError() {
            return this.errorMessage != null;
        }

        public FilterBuilder append(String filterPart) {
            this.result.append(filterPart);
            return this;
        }

        public void setError(String errorMessage) throws MetaException {
            this.errorMessage = errorMessage;
            if (this.expectNoErrors) {
                throw new MetaException(errorMessage);
            }
        }
    }

    public static enum LogicalOperator {
        AND,
        OR;

    }

    public static class JDOFilterGenerator
    extends TreeVisitor {
        private static final String PARAM_PREFIX = "hive_filter_param_";
        private Configuration conf;
        private List<FieldSchema> partitionKeys;
        private FilterBuilder filterBuilder;
        private Map<String, Object> params;
        private boolean onParsing = false;
        private String keyName;
        private Object value;
        private Operator operator;
        private boolean isReverseOrder;
        private static final Set<Operator> TABLE_FILTER_OPS = Sets.newHashSet((Object[])new Operator[]{Operator.EQUALS, Operator.NOTEQUALS, Operator.NOTEQUALS2, Operator.LIKE});

        public JDOFilterGenerator(Configuration conf, List<FieldSchema> partitionKeys, FilterBuilder filterBuilder, Map<String, Object> params) {
            this.conf = conf;
            this.partitionKeys = partitionKeys;
            this.filterBuilder = filterBuilder;
            this.params = params;
        }

        private void beforeParsing() throws MetaException {
            if (!this.onParsing && !this.filterBuilder.getFilter().isEmpty()) {
                this.filterBuilder.append(" && ");
            }
            this.onParsing = true;
        }

        @Override
        protected void beginTreeNode(TreeNode node) throws MetaException {
            this.beforeParsing();
            this.filterBuilder.append("( ");
        }

        @Override
        protected void midTreeNode(TreeNode node) throws MetaException {
            this.filterBuilder.append(node.getAndOr() == LogicalOperator.AND ? " && " : " || ");
        }

        @Override
        protected void endTreeNode(TreeNode node) throws MetaException {
            this.filterBuilder.append(") ");
        }

        @Override
        protected void visit(LeafNode node) throws MetaException {
            this.beforeParsing();
            this.keyName = node.keyName;
            this.operator = node.operator;
            this.value = node.value;
            this.isReverseOrder = node.isReverseOrder;
            if (node.keyName.startsWith("hive_filter_field_params__") && DatabaseProduct.isDerbyOracle() && node.operator == Operator.EQUALS) {
                this.operator = Operator.LIKE;
            }
            if (this.partitionKeys != null) {
                this.generateJDOFilterOverPartitions(this.conf, this.params, this.filterBuilder, this.partitionKeys);
            } else {
                this.generateJDOFilterOverTables(this.params, this.filterBuilder);
            }
        }

        @Override
        protected boolean shouldStop() {
            return this.filterBuilder.hasError();
        }

        private void generateJDOFilterOverTables(Map<String, Object> params, FilterBuilder filterBuilder) throws MetaException {
            if (this.keyName.equals("hive_filter_field_tableName__")) {
                this.keyName = "this.tableName";
            } else if (this.keyName.equals("hive_filter_field_tableType__")) {
                this.keyName = "this.tableType";
            } else if (this.keyName.equals("hive_filter_field_owner__")) {
                this.keyName = "this.owner";
            } else if (this.keyName.equals("hive_filter_field_last_access__")) {
                if (this.operator == Operator.LIKE) {
                    filterBuilder.setError("Like is not supported for HIVE_FILTER_FIELD_LAST_ACCESS");
                    return;
                }
                this.keyName = "this.lastAccessTime";
            } else if (this.keyName.startsWith("hive_filter_field_params__")) {
                if (!TABLE_FILTER_OPS.contains((Object)this.operator)) {
                    filterBuilder.setError("Only " + String.valueOf(TABLE_FILTER_OPS) + " are supported operators for HIVE_FILTER_FIELD_PARAMS");
                    return;
                }
                String paramKeyName = this.keyName.substring("hive_filter_field_params__".length());
                this.keyName = "this.parameters.get(\"" + paramKeyName + "\")";
                this.value = this.value.toString();
                if ("discover__partitions".equals(paramKeyName)) {
                    paramKeyName = "discover.partitions";
                    this.keyName = "this.parameters.get(\"" + paramKeyName + "\").toUpperCase()";
                    this.value = this.value.toString().toUpperCase();
                }
            } else {
                filterBuilder.setError("Invalid key name in filter.  Use constants from org.apache.hadoop.hive.metastore.api");
                return;
            }
            this.generateJDOFilterGeneral(params, filterBuilder);
        }

        private void generateJDOFilterGeneral(Map<String, Object> params, FilterBuilder filterBuilder) throws MetaException {
            String paramName = PARAM_PREFIX + params.size();
            params.put(paramName, this.value);
            if (this.isReverseOrder) {
                if (this.operator == Operator.LIKE) {
                    filterBuilder.setError("Value should be on the RHS for LIKE operator : Key <" + this.keyName + ">");
                } else {
                    filterBuilder.append(paramName + " " + this.operator.getJdoOp() + " " + this.keyName);
                }
            } else if (this.operator == Operator.LIKE) {
                filterBuilder.append(" " + this.keyName + "." + this.operator.getJdoOp() + "(" + paramName + ") ");
            } else {
                filterBuilder.append(" " + this.keyName + " " + this.operator.getJdoOp() + " " + paramName);
            }
        }

        private void generateJDOFilterOverPartitions(Configuration conf, Map<String, Object> params, FilterBuilder filterBuilder, List<FieldSchema> partitionKeys) throws MetaException {
            int partitionColumnCount = partitionKeys.size();
            int partitionColumnIndex = LeafNode.getPartColIndexForFilter(this.keyName, partitionKeys, filterBuilder);
            if (filterBuilder.hasError()) {
                return;
            }
            boolean canPushDownIntegral = MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.INTEGER_JDO_PUSHDOWN);
            String valueAsString = this.getJdoFilterPushdownParam(partitionColumnIndex, filterBuilder, canPushDownIntegral, partitionKeys);
            if (filterBuilder.hasError()) {
                return;
            }
            String paramName = PARAM_PREFIX + params.size();
            if (this.operator == Operator.LIKE) {
                params.put(paramName, JDOFilterGenerator.makeJdoFilterForLike(valueAsString));
            } else {
                params.put(paramName, valueAsString);
            }
            boolean isOpEquals = Operator.isEqualOperator(this.operator);
            if (isOpEquals || Operator.isNotEqualOperator(this.operator)) {
                String partitionKey = partitionKeys.get(partitionColumnIndex).getName();
                ExpressionTree.makeFilterForEquals(partitionKey, valueAsString, paramName, params, partitionColumnIndex, partitionColumnCount, isOpEquals, filterBuilder);
                return;
            }
            String valString = "values.get(" + partitionColumnIndex + ")";
            if (this.operator == Operator.LIKE) {
                if (this.isReverseOrder) {
                    filterBuilder.setError("Value should be on the RHS for LIKE operator : Key <" + this.keyName + ">");
                }
                filterBuilder.append(" " + valString + "." + this.operator.getJdoOp() + "(" + paramName + ") ");
            } else {
                filterBuilder.append(this.isReverseOrder ? paramName + " " + this.operator.getJdoOp() + " " + valString : " " + valString + " " + this.operator.getJdoOp() + " " + paramName);
            }
        }

        private static String makeJdoFilterForLike(String likePattern) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < likePattern.length(); ++i) {
                char n = likePattern.charAt(i);
                if (n == '\\' && i + 1 < likePattern.length() && (likePattern.charAt(i + 1) == '_' || likePattern.charAt(i + 1) == '%')) {
                    sb.append(likePattern.charAt(i + 1));
                    ++i;
                    continue;
                }
                if (n == '_') {
                    sb.append(".");
                    continue;
                }
                if (n == '%') {
                    sb.append(".*");
                    continue;
                }
                sb.append(likePattern.charAt(i));
            }
            return sb.toString();
        }

        public boolean canJdoUseStringsWithIntegral() {
            return this.operator == Operator.EQUALS || this.operator == Operator.NOTEQUALS || this.operator == Operator.NOTEQUALS2;
        }

        private String getJdoFilterPushdownParam(int partColIndex, FilterBuilder filterBuilder, boolean canPushDownIntegral, List<FieldSchema> partitionKeys) throws MetaException {
            boolean isIntegralSupported = canPushDownIntegral && this.canJdoUseStringsWithIntegral();
            String colType = ColumnType.getTypeName((String)partitionKeys.get(partColIndex).getType());
            if (!(ColumnType.StringTypes.contains(colType) || "date".equalsIgnoreCase(colType) || "timestamp".equalsIgnoreCase(colType) || isIntegralSupported && ColumnType.IntegralTypes.contains(colType))) {
                filterBuilder.setError("Filtering is supported only on partition keys of type string" + (isIntegralSupported ? ", or integral types" : ""));
                return null;
            }
            Object val = this.value;
            if (colType.equals("date") && this.value instanceof Date) {
                val = MetaStoreUtils.convertDateToString((Date)((Date)this.value));
            } else if (colType.equals("timestamp") && this.value instanceof Timestamp) {
                val = MetaStoreUtils.convertTimestampToString((Timestamp)((Timestamp)this.value));
            }
            boolean isStringValue = val instanceof String;
            if (!(isStringValue || isIntegralSupported && val instanceof Long)) {
                filterBuilder.setError("Filtering is supported only on partition keys of type string" + (isIntegralSupported ? ", or integral types" : ""));
                return null;
            }
            return isStringValue ? (String)val : Long.toString((Long)val);
        }
    }

    public static class LeafNode
    extends TreeNode {
        public String keyName;
        public Operator operator;
        public Object value;
        public boolean isReverseOrder = false;

        @Override
        protected void accept(TreeVisitor visitor) throws MetaException {
            visitor.visit(this);
        }

        @Override
        public String toString() {
            return "LeafNode{keyName='" + this.keyName + "', operator='" + String.valueOf((Object)this.operator) + "', value=" + String.valueOf(this.value) + (this.isReverseOrder ? ", isReverseOrder=true" : "") + "}";
        }

        public static int getPartColIndexForFilter(String partitionKeyName, List<FieldSchema> partitionKeys, FilterBuilder filterBuilder) throws MetaException {
            int partitionColumnIndex = Iterables.indexOf(partitionKeys, key -> partitionKeyName.equalsIgnoreCase(key.getName()));
            if (partitionColumnIndex < 0) {
                filterBuilder.setError("Specified key <" + partitionKeyName + "> is not a partitioning key for the table");
                return -1;
            }
            return partitionColumnIndex;
        }
    }

    public static enum Operator {
        EQUALS("=", "==", "="),
        GREATERTHAN(">"),
        LESSTHAN("<"),
        LESSTHANOREQUALTO("<="),
        GREATERTHANOREQUALTO(">="),
        LIKE("LIKE", "matches", "like"),
        NOTEQUALS2("!=", "!=", "<>"),
        NOTEQUALS("<>", "!=", "<>");

        private final String op;
        private final String jdoOp;
        private final String sqlOp;

        private Operator(String op) {
            this.op = op;
            this.jdoOp = op;
            this.sqlOp = op;
        }

        private Operator(String op, String jdoOp, String sqlOp) {
            this.op = op;
            this.jdoOp = jdoOp;
            this.sqlOp = sqlOp;
        }

        public String getOp() {
            return this.op;
        }

        public String getJdoOp() {
            return this.jdoOp;
        }

        public String getSqlOp() {
            return this.sqlOp;
        }

        public static Operator fromString(String inputOperator) {
            for (Operator op : Operator.values()) {
                if (!op.getOp().equals(inputOperator)) continue;
                return op;
            }
            throw new Error("Invalid value " + inputOperator + " for " + Operator.class.getSimpleName());
        }

        public static boolean isEqualOperator(Operator op) {
            return op == EQUALS;
        }

        public static boolean isNotEqualOperator(Operator op) {
            return op == NOTEQUALS || op == NOTEQUALS2;
        }

        public String toString() {
            return this.op;
        }
    }
}

