/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.metrics;

import com.codahale.metrics.Timer;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.metastore.metrics.Metrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfLogger {
    protected final Map<String, Long> startTimes = new HashMap<String, Long>();
    protected final Map<String, Long> endTimes = new HashMap<String, Long>();
    private static final Logger LOG = LoggerFactory.getLogger((String)PerfLogger.class.getName());
    protected static final ThreadLocal<PerfLogger> perfLogger = new ThreadLocal();
    public static final String GET_DATABASE = "getDatabase";
    public static final String GET_TABLE = "getTable";
    public static final String GET_TABLE_COL_STATS = "getTableColumnStatistics";
    public static final String GET_TABLE_COL_STATS_2 = "getTableColumnStatistics_2";
    private transient Map<String, Timer.Context> timerContexts = new HashMap<String, Timer.Context>();
    private transient Timer.Context totalApiCallsTimerContext = null;

    private PerfLogger() {
    }

    public static PerfLogger getPerfLogger(boolean resetPerfLogger) {
        PerfLogger result = perfLogger.get();
        if (resetPerfLogger || result == null) {
            result = new PerfLogger();
            perfLogger.set(result);
        }
        return result;
    }

    public void perfLogBegin(String callerName, String method) {
        long startTime = System.currentTimeMillis();
        this.startTimes.put(method, startTime);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<PERFLOG method=" + method + " from=" + callerName + ">");
        }
        this.beginMetrics(method);
    }

    public long perfLogEnd(String callerName, String method) {
        return this.perfLogEnd(callerName, method, null);
    }

    public long perfLogEnd(String callerName, String method, String additionalInfo) {
        long duration;
        Long startTime = this.startTimes.get(method);
        long endTime = System.currentTimeMillis();
        this.endTimes.put(method, endTime);
        long l = duration = startTime == null ? -1L : endTime - startTime;
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("</PERFLOG method=").append(method);
            if (startTime != null) {
                sb.append(" start=").append(startTime);
            }
            sb.append(" end=").append(endTime);
            if (startTime != null) {
                sb.append(" duration=").append(duration);
            }
            sb.append(" from=").append(callerName);
            if (additionalInfo != null) {
                sb.append(" ").append(additionalInfo);
            }
            sb.append(">");
            LOG.debug(sb.toString());
        }
        this.endMetrics(method);
        return duration;
    }

    private void beginMetrics(String method) {
        Timer timer = Metrics.getOrCreateTimer("api_" + method);
        if (timer != null) {
            this.timerContexts.put(method, timer.time());
        }
        if ((timer = Metrics.getOrCreateTimer("total_api_calls")) != null) {
            this.totalApiCallsTimerContext = timer.time();
        }
    }

    private void endMetrics(String method) {
        Timer.Context context = this.timerContexts.remove(method);
        if (context != null) {
            context.close();
        }
        if (this.totalApiCallsTimerContext != null) {
            this.totalApiCallsTimerContext.close();
        }
    }

    public void cleanupPerfLogMetrics() {
        for (Timer.Context context : this.timerContexts.values()) {
            context.close();
        }
        this.timerContexts.clear();
        if (this.totalApiCallsTimerContext != null) {
            this.totalApiCallsTimerContext.close();
            this.totalApiCallsTimerContext = null;
        }
    }
}

