/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client.builder;

import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;

public class HiveObjectRefBuilder {
    private HiveObjectType objectType;
    private String dbName;
    private String objectName;
    private String columnName;
    private List<String> partValues;

    public HiveObjectRef buildGlobalReference() {
        return new HiveObjectRef(HiveObjectType.GLOBAL, null, null, Collections.emptyList(), null);
    }

    public HiveObjectRef buildDatabaseReference(Database db) {
        return new HiveObjectRef(HiveObjectType.DATABASE, db.getName(), null, Collections.emptyList(), null);
    }

    public HiveObjectRef buildTableReference(Table table) {
        return new HiveObjectRef(HiveObjectType.TABLE, table.getDbName(), table.getTableName(), Collections.emptyList(), null);
    }

    public HiveObjectRef buildPartitionReference(Partition part) {
        return new HiveObjectRef(HiveObjectType.PARTITION, part.getDbName(), part.getTableName(), part.getValues(), null);
    }

    public HiveObjectRef buildColumnReference(Table table, String columnName) {
        return new HiveObjectRef(HiveObjectType.COLUMN, table.getDbName(), table.getTableName(), Collections.emptyList(), columnName);
    }

    public HiveObjectRef buildPartitionColumnReference(Table table, String columnName, List<String> partValues) {
        return new HiveObjectRef(HiveObjectType.COLUMN, table.getDbName(), table.getTableName(), partValues, columnName);
    }
}

