/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client.builder;

import java.util.List;
import org.apache.hadoop.hive.metastore.api.GetPartitionsFilterSpec;
import org.apache.hadoop.hive.metastore.api.GetPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.GetProjectionsSpec;

public class GetPartitionsRequestBuilder {
    private String catName = null;
    private String dbName = null;
    private String tblName = null;
    private boolean withAuth = true;
    private String user = null;
    private List<String> groupNames = null;
    private GetProjectionsSpec projectionSpec = null;
    private GetPartitionsFilterSpec filterSpec = null;
    private List<String> processorCapabilities = null;
    private String processorIdentifier = null;
    private String validWriteIdList = null;

    public GetPartitionsRequestBuilder(String catName, String dbName, String tblName, boolean withAuth, String user, List<String> groupNames, GetProjectionsSpec projectionSpec, GetPartitionsFilterSpec filterSpec, List<String> processorCapabilities, String processorIdentifier, String validWriteIdList) {
        this.catName = catName;
        this.dbName = dbName;
        this.tblName = tblName;
        this.withAuth = withAuth;
        this.user = user;
        this.groupNames = groupNames;
        this.projectionSpec = projectionSpec;
        this.filterSpec = filterSpec;
        this.processorCapabilities = processorCapabilities;
        this.processorIdentifier = processorIdentifier;
        this.validWriteIdList = validWriteIdList;
    }

    public GetPartitionsRequestBuilder setCatName(String catName) {
        this.catName = catName;
        return this;
    }

    public GetPartitionsRequestBuilder setDbName(String dbName) {
        this.dbName = dbName;
        return this;
    }

    public GetPartitionsRequestBuilder setTblName(String tblName) {
        this.tblName = tblName;
        return this;
    }

    public GetPartitionsRequestBuilder setWithAuth(boolean withAuth) {
        this.withAuth = withAuth;
        return this;
    }

    public GetPartitionsRequestBuilder setUser(String user) {
        this.user = user;
        return this;
    }

    public GetPartitionsRequestBuilder setGroupNames(List<String> groupNames) {
        this.groupNames = groupNames;
        return this;
    }

    public GetPartitionsRequestBuilder setProjectionSpec(GetProjectionsSpec projectionSpec) {
        this.projectionSpec = projectionSpec;
        return this;
    }

    public GetPartitionsRequestBuilder setFilterSpec(GetPartitionsFilterSpec filterSpec) {
        this.filterSpec = filterSpec;
        return this;
    }

    public GetPartitionsRequestBuilder setProcessorCapabilities(List<String> processorCapabilities) {
        this.processorCapabilities = processorCapabilities;
        return this;
    }

    public GetPartitionsRequestBuilder setProcessorIdentifier(String processorIdentifier) {
        this.processorIdentifier = processorIdentifier;
        return this;
    }

    public GetPartitionsRequestBuilder setValidWriteIdList(String validWriteIdList) {
        this.validWriteIdList = validWriteIdList;
        return this;
    }

    public GetPartitionsRequest build() {
        GetPartitionsRequest partitionsRequest = new GetPartitionsRequest(this.dbName, this.tblName, this.projectionSpec, this.filterSpec);
        partitionsRequest.setCatName(this.catName);
        partitionsRequest.setWithAuth(this.withAuth);
        partitionsRequest.setUser(this.user);
        partitionsRequest.setGroupNames(this.groupNames);
        partitionsRequest.setProcessorCapabilities(this.processorCapabilities);
        partitionsRequest.setProcessorIdentifier(this.processorIdentifier);
        partitionsRequest.setValidWriteIdList(this.validWriteIdList);
        return partitionsRequest;
    }
}

