/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.AcidMetaDataFile;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.AlterHandler;
import org.apache.hadoop.hive.metastore.Batchable;
import org.apache.hadoop.hive.metastore.Deadline;
import org.apache.hadoop.hive.metastore.DefaultIncompatibleTableChangeHandler;
import org.apache.hadoop.hive.metastore.HMSHandler;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.MetaStoreEventListener;
import org.apache.hadoop.hive.metastore.MetaStoreListenerNotifier;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.TransactionalMetaStoreEventListener;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionsRequest;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.events.AlterPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AlterPartitionsEvent;
import org.apache.hadoop.hive.metastore.events.AlterTableEvent;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.hive.metastore.model.MTable;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreServerUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveAlterHandler
implements AlterHandler {
    protected Configuration conf;
    private static final Logger LOG = LoggerFactory.getLogger((String)HiveAlterHandler.class.getName());

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void alterTable(final RawStore msdb, Warehouse wh, String catName, String dbname, String name, final Table newt, EnvironmentContext environmentContext, IHMSHandler handler, final String writeIdList) throws InvalidOperationException, MetaException {
        boolean isReplicated;
        Map<String, String> txnAlterTableEventResponses;
        List<MetaStoreEventListener> listeners;
        Table oldt;
        boolean success;
        block64: {
            boolean dataWasMoved;
            FileSystem destFs;
            Path destPath;
            Path srcPath;
            boolean replDataLocationChanged;
            String databaseName;
            String tableName;
            String catalogName;
            block63: {
                boolean cascade;
                catalogName = StringUtils.normalizeIdentifier((String)catName);
                tableName = StringUtils.normalizeIdentifier((String)name);
                databaseName = StringUtils.normalizeIdentifier((String)dbname);
                if (environmentContext != null && environmentContext.isSetProperties()) {
                    cascade = "true".equals(environmentContext.getProperties().get("CASCADE"));
                    replDataLocationChanged = "true".equals(environmentContext.getProperties().get("REPL_DATA_LOCATION_CHANGED"));
                } else {
                    cascade = false;
                    replDataLocationChanged = false;
                }
                if (newt == null) {
                    throw new InvalidOperationException("New table is null");
                }
                final String newTblName = newt.getTableName().toLowerCase();
                final String newDbName = newt.getDbName().toLowerCase();
                if (!MetaStoreUtils.validateName((String)newTblName, (Configuration)handler.getConf())) {
                    throw new InvalidOperationException(newTblName + " is not a valid object name");
                }
                String validate = MetaStoreServerUtils.validateTblColumns(newt.getSd().getCols());
                if (validate != null) {
                    throw new InvalidOperationException("Invalid column " + validate);
                }
                List<String> bucketColumns = MetaStoreServerUtils.validateBucketColumns(newt.getSd());
                if (CollectionUtils.isNotEmpty(bucketColumns)) {
                    String errMsg = "Bucket columns - " + String.valueOf(bucketColumns) + " doesn't match with any table columns";
                    LOG.error(errMsg);
                    throw new InvalidOperationException(errMsg);
                }
                srcPath = null;
                destPath = null;
                destFs = null;
                success = false;
                dataWasMoved = false;
                boolean isPartitionedTable = false;
                Database olddb = null;
                oldt = null;
                List<TransactionalMetaStoreEventListener> transactionalListeners = handler.getTransactionalListeners();
                listeners = handler.getListeners();
                txnAlterTableEventResponses = Collections.emptyMap();
                try {
                    block62: {
                        block66: {
                            List parts;
                            Database db;
                            block65: {
                                Map properties;
                                boolean rename = false;
                                if (!catalogName.equalsIgnoreCase(newt.getCatName())) {
                                    throw new InvalidOperationException("Tables cannot be moved between catalogs, old catalog" + catalogName + ", new catalog " + newt.getCatName());
                                }
                                if (!newTblName.equals(tableName) || !newDbName.equals(databaseName)) {
                                    if (msdb.getTable(catalogName, newDbName, newTblName, null) != null) {
                                        throw new InvalidOperationException("new table " + newDbName + "." + newTblName + " already exists");
                                    }
                                    rename = true;
                                }
                                String expectedKey = environmentContext != null && environmentContext.getProperties() != null ? (String)environmentContext.getProperties().get("expected_parameter_key") : null;
                                String expectedValue = environmentContext != null && environmentContext.getProperties() != null ? (String)environmentContext.getProperties().get("expected_parameter_value") : null;
                                msdb.openTransaction();
                                olddb = msdb.getDatabase(catalogName, databaseName);
                                oldt = msdb.getTable(catalogName, databaseName, tableName, null);
                                if (oldt == null) {
                                    throw new InvalidOperationException("table " + TableName.getQualified((String)catalogName, (String)databaseName, (String)tableName) + " doesn't exist");
                                }
                                if (expectedKey != null && expectedValue != null) {
                                    String newValue = (String)newt.getParameters().get(expectedKey);
                                    if (newValue == null) {
                                        throw new MetaException(String.format("New value for expected key %s is not set", expectedKey));
                                    }
                                    if (!expectedValue.equals(oldt.getParameters().get(expectedKey))) {
                                        throw new MetaException("The table has been modified. The parameter value for key '" + expectedKey + "' is '" + (String)oldt.getParameters().get(expectedKey) + "'. The expected was value was '" + expectedValue + "'");
                                    }
                                    long affectedRows = msdb.updateParameterWithExpectedValue(oldt, expectedKey, expectedValue, newValue);
                                    if (affectedRows != 1L) {
                                        throw new MetaException("The table has been modified. The parameter value for key '" + expectedKey + "' is different");
                                    }
                                }
                                this.validateTableChangesOnReplSource(olddb, oldt, newt, environmentContext);
                                isReplicated = HMSHandler.isDbReplicationTarget(olddb);
                                if (oldt.getPartitionKeysSize() != 0) {
                                    isPartitionedTable = true;
                                }
                                DefaultIncompatibleTableChangeHandler.get().allowChange(handler.getConf(), oldt, newt);
                                boolean partKeysPartiallyEqual = this.checkPartialPartKeysEqual(oldt.getPartitionKeys(), newt.getPartitionKeys());
                                if (!(oldt.getTableType().equals(TableType.VIRTUAL_VIEW.toString()) || (properties = environmentContext.getProperties()) != null && Boolean.parseBoolean(properties.getOrDefault("allow_partition_key_change", "false")) || partKeysPartiallyEqual)) {
                                    throw new InvalidOperationException("partition keys can not be changed.");
                                }
                                boolean renamedManagedTable = rename && !oldt.getTableType().equals(TableType.VIRTUAL_VIEW.toString()) && (oldt.getSd().getLocation().compareTo(newt.getSd().getLocation()) == 0 || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)newt.getSd().getLocation())) && !MetaStoreUtils.isExternalTable((Table)oldt);
                                db = msdb.getDatabase(catalogName, newDbName);
                                boolean renamedTranslatedToExternalTable = rename && MetaStoreUtils.isTranslatedToExternalTable((Table)oldt) && MetaStoreUtils.isTranslatedToExternalTable((Table)newt);
                                boolean renamedExternalTable = rename && MetaStoreUtils.isExternalTable((Table)oldt) && !MetaStoreUtils.isPropertyTrue((Map)oldt.getParameters(), (String)"TRANSLATED_TO_EXTERNAL");
                                boolean isRenameIcebergTable = rename && MetaStoreUtils.isIcebergTable((Map)newt.getParameters());
                                this.deleteTableColumnStats(msdb, oldt, newt);
                                if (isRenameIcebergTable || !replDataLocationChanged && !renamedManagedTable && !renamedTranslatedToExternalTable && !renamedExternalTable) break block65;
                                srcPath = new Path(oldt.getSd().getLocation());
                                if (replDataLocationChanged) {
                                    destPath = new Path(newt.getSd().getLocation());
                                    dataWasMoved = true;
                                } else if (!renamedExternalTable) {
                                    boolean tableInSpecifiedLoc;
                                    String oldtRelativePath = wh.getDatabaseManagedPath(olddb).toUri().relativize(srcPath.toUri()).toString();
                                    boolean bl = tableInSpecifiedLoc = !oldtRelativePath.equalsIgnoreCase(tableName) && !oldtRelativePath.equalsIgnoreCase(tableName + "/");
                                    if (renamedTranslatedToExternalTable || !tableInSpecifiedLoc) {
                                        FileSystem srcFs = wh.getFs(srcPath);
                                        assert (isReplicated == HMSHandler.isDbReplicationTarget(db));
                                        if (renamedTranslatedToExternalTable) {
                                            if (!tableInSpecifiedLoc) {
                                                destPath = new Path(newt.getSd().getLocation());
                                            } else {
                                                databasePath = this.constructRenamedPath(wh.getDatabaseExternalPath(db), srcPath);
                                                destPath = new Path(databasePath, newTblName);
                                                newt.getSd().setLocation(destPath.toString());
                                            }
                                        } else {
                                            databasePath = this.constructRenamedPath(wh.getDatabaseManagedPath(db), srcPath);
                                            destPath = new Path(databasePath, newTblName);
                                            newt.getSd().setLocation(destPath.toString());
                                        }
                                        destFs = wh.getFs(destPath);
                                        if (!FileUtils.equalsFileSystem((FileSystem)srcFs, (FileSystem)destFs)) {
                                            throw new InvalidOperationException("table new location " + String.valueOf(destPath) + " is on a different file system than the old location " + String.valueOf(srcPath) + ". This operation is not supported");
                                        }
                                        try {
                                            if (destFs.exists(destPath)) {
                                                throw new InvalidOperationException("New location for this table " + TableName.getQualified((String)catalogName, (String)newDbName, (String)newTblName) + " already exists : " + String.valueOf(destPath));
                                            }
                                            if (srcFs.exists(srcPath) && wh.renameDir(srcPath, destPath, ReplChangeManager.shouldEnableCm((Database)olddb, (Table)oldt))) {
                                                dataWasMoved = true;
                                            }
                                        }
                                        catch (IOException | MetaException e) {
                                            LOG.error("Alter Table operation for " + databaseName + "." + tableName + " failed.", e);
                                            throw new InvalidOperationException("Alter Table operation for " + databaseName + "." + tableName + " failed to move data due to: '" + this.getSimpleMessage((Exception)e) + "' See hive log file for details.");
                                        }
                                        if (!HiveMetaStore.isRenameAllowed(olddb, db)) {
                                            LOG.error("Alter Table operation for " + TableName.getQualified((String)catalogName, (String)databaseName, (String)tableName) + "to new table = " + TableName.getQualified((String)catalogName, (String)newDbName, (String)newTblName) + " failed ");
                                            throw new MetaException("Alter table not allowed for table " + TableName.getQualified((String)catalogName, (String)databaseName, (String)tableName) + "to new table = " + TableName.getQualified((String)catalogName, (String)newDbName, (String)newTblName));
                                        }
                                    }
                                }
                                if (isPartitionedTable) {
                                    String oldTblLocPath = srcPath.toUri().getPath();
                                    String newTblLocPath = dataWasMoved ? destPath.toUri().getPath() : null;
                                    msdb.alterTable(catalogName, databaseName, tableName, newt, null);
                                    int partitionBatchSize = MetastoreConf.getIntVar((Configuration)handler.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX);
                                    if (dataWasMoved) {
                                        PartitionsRequest req = new PartitionsRequest(newDbName, newTblName);
                                        req.setCatName(catName);
                                        req.setMaxParts((short)-1);
                                        parts = handler.get_partitions_req(req).getPartitions();
                                        for (Partition part : parts) {
                                            String oldPartLoc = part.getSd().getLocation();
                                            if (oldPartLoc.contains(oldTblLocPath)) {
                                                URI oldUri = new Path(oldPartLoc).toUri();
                                                String newPath = oldUri.getPath().replace(oldTblLocPath, newTblLocPath);
                                                Path newPartLocPath = new Path(oldUri.getScheme(), oldUri.getAuthority(), newPath);
                                                part.getSd().setLocation(newPartLocPath.toString());
                                            }
                                            part.setDbName(newDbName);
                                            part.setTableName(newTblName);
                                        }
                                        Batchable.runBatched(partitionBatchSize, parts, new Batchable<Partition, Void>(this){

                                            @Override
                                            public List<Void> run(List<Partition> input) throws Exception {
                                                msdb.alterPartitions(catalogName, newDbName, newTblName, input.stream().map(Partition::getValues).collect(Collectors.toList()), input, newt.getWriteId(), writeIdList);
                                                return Collections.emptyList();
                                            }
                                        });
                                    }
                                    Deadline.checkTimeout();
                                    break block62;
                                } else {
                                    msdb.alterTable(catalogName, databaseName, tableName, newt, writeIdList);
                                }
                                break block62;
                            }
                            if (MetaStoreServerUtils.requireCalStats(null, null, newt, environmentContext) && !isPartitionedTable) {
                                assert (isReplicated == HMSHandler.isDbReplicationTarget(db));
                                MetaStoreServerUtils.updateTableStatsSlow(db, newt, wh, false, true, environmentContext);
                            }
                            if (!isPartitionedTable) break block66;
                            boolean runPartitionMetadataUpdate = cascade && !MetaStoreServerUtils.areSameColumns(oldt.getSd().getCols(), newt.getSd().getCols());
                            boolean bl = !cascade && !MetaStoreServerUtils.arePrefixColumns(oldt.getSd().getCols(), newt.getSd().getCols());
                            boolean retainOnColRemoval = MetastoreConf.getBoolVar((Configuration)handler.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COLSTATS_RETAIN_ON_COLUMN_REMOVAL);
                            if (runPartitionMetadataUpdate |= bl) {
                                msdb.alterTable(catalogName, databaseName, tableName, newt, null);
                                if (cascade || retainOnColRemoval) {
                                    PartitionsRequest req = new PartitionsRequest(dbname, name);
                                    req.setCatName(catName);
                                    req.setMaxParts((short)-1);
                                    parts = handler.get_partitions_req(req).getPartitions();
                                    final Table table = oldt;
                                    int partitionBatchSize = MetastoreConf.getIntVar((Configuration)handler.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX);
                                    final HashMap changedColsToPartNames = new HashMap();
                                    Batchable.runBatched(partitionBatchSize, parts, new Batchable<Partition, Void>(this){

                                        @Override
                                        public List<Void> run(List<Partition> input) throws Exception {
                                            ArrayList<Partition> oldParts = new ArrayList<Partition>(input.size());
                                            List<List<String>> partVals = input.stream().map(Partition::getValues).collect(Collectors.toList());
                                            for (Partition part : input) {
                                                Partition oldPart = new Partition(part);
                                                List oldCols = part.getSd().getCols();
                                                part.getSd().setCols(newt.getSd().getCols());
                                                ArrayList<String> deletedCols = new ArrayList<String>();
                                                HiveAlterHandler.updateOrGetPartitionColumnStats(msdb, catalogName, databaseName, tableName, part.getValues(), oldCols, table, part, deletedCols);
                                                if (!deletedCols.isEmpty()) {
                                                    changedColsToPartNames.compute(deletedCols, (k, v) -> {
                                                        if (v == null) {
                                                            v = new ArrayList<List>();
                                                        }
                                                        v.add(part.getValues());
                                                        return v;
                                                    });
                                                }
                                                if (cascade) continue;
                                                oldPart.setParameters(part.getParameters());
                                                oldParts.add(oldPart);
                                            }
                                            Deadline.checkTimeout();
                                            msdb.alterPartitions(catalogName, databaseName, tableName, partVals, cascade ? input : oldParts, newt.getWriteId(), writeIdList);
                                            return Collections.emptyList();
                                        }
                                    });
                                    for (Map.Entry entry : changedColsToPartNames.entrySet()) {
                                        ArrayList<String> partNames = new ArrayList<String>();
                                        for (List part_vals : (List)entry.getValue()) {
                                            partNames.add(Warehouse.makePartName((List)table.getPartitionKeys(), (List)part_vals));
                                        }
                                        msdb.deletePartitionColumnStatistics(catalogName, databaseName, tableName, partNames, (List)entry.getKey(), null);
                                    }
                                    break block62;
                                } else {
                                    msdb.deleteAllPartitionColumnStatistics(new TableName(catalogName, databaseName, tableName), writeIdList);
                                }
                                break block62;
                            } else {
                                LOG.warn("Alter table not cascaded to partitions.");
                                msdb.alterTable(catalogName, databaseName, tableName, newt, writeIdList);
                            }
                            break block62;
                        }
                        msdb.alterTable(catalogName, databaseName, tableName, newt, writeIdList);
                    }
                    if (transactionalListeners != null && !transactionalListeners.isEmpty()) {
                        txnAlterTableEventResponses = MetaStoreListenerNotifier.notifyEvent(transactionalListeners, EventMessage.EventType.ALTER_TABLE, new AlterTableEvent(oldt, newt, false, true, newt.getWriteId(), handler, isReplicated), environmentContext);
                    }
                    if (!(success = msdb.commitTransaction())) break block63;
                    if (!replDataLocationChanged) break block64;
                }
                catch (InvalidOperationException | MetaException e) {
                    try {
                        throw e;
                        catch (TException e2) {
                            LOG.debug("Failed to get object from Metastore ", (Throwable)e2);
                            throw new InvalidOperationException("Unable to change partition or table. Check metastore logs for detailed stack." + e2.getMessage());
                        }
                    }
                    catch (Throwable throwable) {
                        if (success) {
                            if (!replDataLocationChanged) throw throwable;
                            Path deleteOldDataLoc = new Path(oldt.getSd().getLocation());
                            boolean isSkipTrash = MetaStoreUtils.isSkipTrash((Map)oldt.getParameters());
                            try {
                                wh.deleteDir(deleteOldDataLoc, isSkipTrash, ReplChangeManager.shouldEnableCm(olddb, oldt));
                                LOG.info("Deleted the old data location: {} for the table: {}", (Object)deleteOldDataLoc, (Object)(databaseName + "." + tableName));
                                throw throwable;
                            }
                            catch (MetaException ex) {
                                LOG.warn("Unable to delete the old data location: {} for the table: {}", (Object)deleteOldDataLoc, (Object)(databaseName + "." + tableName));
                                throw throwable;
                            }
                        }
                        LOG.error("Failed to alter table " + TableName.getQualified((String)catalogName, (String)databaseName, (String)tableName));
                        msdb.rollbackTransaction();
                        if (replDataLocationChanged) throw throwable;
                        if (!dataWasMoved) throw throwable;
                        try {
                            if (!destFs.exists(destPath)) throw throwable;
                            if (destFs.rename(destPath, srcPath)) throw throwable;
                            LOG.error("Failed to restore data from " + String.valueOf(destPath) + " to " + String.valueOf(srcPath) + " in alter table failure. Manual restore is needed.");
                            throw throwable;
                        }
                        catch (IOException e3) {
                            LOG.error("Failed to restore data from " + String.valueOf(destPath) + " to " + String.valueOf(srcPath) + " in alter table failure. Manual restore is needed.");
                        }
                        throw throwable;
                    }
                }
                Path deleteOldDataLoc = new Path(oldt.getSd().getLocation());
                boolean isSkipTrash = MetaStoreUtils.isSkipTrash((Map)oldt.getParameters());
                try {
                    wh.deleteDir(deleteOldDataLoc, isSkipTrash, ReplChangeManager.shouldEnableCm((Database)olddb, (Table)oldt));
                    LOG.info("Deleted the old data location: {} for the table: {}", (Object)deleteOldDataLoc, (Object)(databaseName + "." + tableName));
                }
                catch (MetaException ex) {
                    LOG.warn("Unable to delete the old data location: {} for the table: {}", (Object)deleteOldDataLoc, (Object)(databaseName + "." + tableName));
                }
                break block64;
            }
            LOG.error("Failed to alter table " + TableName.getQualified((String)catalogName, (String)databaseName, (String)tableName));
            msdb.rollbackTransaction();
            if (!replDataLocationChanged && dataWasMoved) {
                try {
                    if (destFs.exists(destPath) && !destFs.rename(destPath, srcPath)) {
                        LOG.error("Failed to restore data from " + String.valueOf(destPath) + " to " + String.valueOf(srcPath) + " in alter table failure. Manual restore is needed.");
                    }
                }
                catch (IOException e) {
                    LOG.error("Failed to restore data from " + String.valueOf(destPath) + " to " + String.valueOf(srcPath) + " in alter table failure. Manual restore is needed.");
                }
            }
        }
        if (listeners.isEmpty()) return;
        MetaStoreListenerNotifier.notifyEvent(listeners, EventMessage.EventType.ALTER_TABLE, new AlterTableEvent(oldt, newt, false, success, newt.getWriteId(), handler, isReplicated), environmentContext, txnAlterTableEventResponses, msdb);
    }

    String getSimpleMessage(Exception ex) {
        if (ex instanceof MetaException) {
            String msg = ex.getMessage();
            if (msg == null || !msg.contains("\n")) {
                return msg;
            }
            return msg.substring(0, msg.indexOf(10));
        }
        return ex.getMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Partition alterPartition(RawStore msdb, Warehouse wh, String catName, String dbname, String name, List<String> part_vals, Partition new_part, EnvironmentContext environmentContext, IHMSHandler handler, String validWriteIds) throws InvalidOperationException, InvalidObjectException, AlreadyExistsException, MetaException, NoSuchObjectException {
        Partition oldPart;
        block50: {
            boolean success = false;
            List<TransactionalMetaStoreEventListener> transactionalListeners = null;
            if (handler != null) {
                transactionalListeners = handler.getTransactionalListeners();
            }
            if (new_part.getParameters() == null || new_part.getParameters().get("transient_lastDdlTime") == null || Integer.parseInt((String)new_part.getParameters().get("transient_lastDdlTime")) == 0) {
                new_part.putToParameters("transient_lastDdlTime", Long.toString(System.currentTimeMillis() / 1000L));
            }
            if (CollectionUtils.isEmpty(part_vals)) {
                Partition oldPart2;
                try {
                    msdb.openTransaction();
                    Table tbl = msdb.getTable(catName, dbname, name, null);
                    if (tbl == null) {
                        throw new InvalidObjectException("Unable to alter partition because table or database does not exist.");
                    }
                    oldPart2 = msdb.getPartition(catName, dbname, name, new_part.getValues());
                    if (MetaStoreServerUtils.requireCalStats(oldPart2, new_part, tbl, environmentContext)) {
                        if (MetaStoreServerUtils.isFastStatsSame(oldPart2, new_part)) {
                            MetaStoreServerUtils.updateBasicState(environmentContext, new_part.getParameters());
                        } else {
                            MetaStoreServerUtils.updatePartitionStatsFast(new_part, tbl, wh, false, true, environmentContext, false);
                        }
                    }
                    if (oldPart2.getSd() != null) {
                        HiveAlterHandler.updateOrGetPartitionColumnStats(msdb, catName, dbname, name, new_part.getValues(), oldPart2.getSd().getCols(), tbl, new_part, null);
                    }
                    Deadline.checkTimeout();
                    msdb.alterPartition(catName, dbname, name, new_part.getValues(), new_part, validWriteIds);
                    if (transactionalListeners != null && !transactionalListeners.isEmpty()) {
                        MetaStoreListenerNotifier.notifyEvent(transactionalListeners, EventMessage.EventType.ALTER_PARTITION, new AlterPartitionEvent(oldPart2, new_part, tbl, false, true, new_part.getWriteId(), handler), environmentContext);
                    }
                    success = msdb.commitTransaction();
                }
                catch (InvalidObjectException e) {
                    LOG.warn("Alter failed", (Throwable)e);
                    throw new InvalidOperationException("alter is not possible: " + e.getMessage());
                }
                catch (NoSuchObjectException e) {
                    throw new InvalidOperationException("alter is not possible: " + e.getMessage());
                }
                finally {
                    if (!success) {
                        msdb.rollbackTransaction();
                    }
                }
                return oldPart2;
            }
            Path srcPath = null;
            Path destPath = null;
            FileSystem destFs = null;
            boolean dataWasMoved = false;
            try {
                boolean shouldMoveData;
                Partition check_part;
                msdb.openTransaction();
                Table tbl = msdb.getTable(catName, dbname, name, null);
                if (tbl == null) {
                    throw new InvalidObjectException("Unable to alter partition because table or database does not exist.");
                }
                MTable mTable = msdb.ensureGetMTable(catName, dbname, name);
                try {
                    oldPart = msdb.getPartition(catName, dbname, name, part_vals);
                }
                catch (NoSuchObjectException e) {
                    throw new InvalidObjectException("Unable to rename partition because old partition does not exist");
                }
                try {
                    check_part = msdb.getPartition(catName, dbname, name, new_part.getValues());
                }
                catch (NoSuchObjectException e) {
                    check_part = null;
                }
                if (check_part != null) {
                    throw new AlreadyExistsException("Partition already exists:" + dbname + "." + name + "." + String.valueOf(new_part.getValues()));
                }
                boolean bl = shouldMoveData = !MetaStoreUtils.isExternalTable((Table)tbl) || MetaStoreUtils.isPropertyTrue((Map)tbl.getParameters(), (String)"TRANSLATED_TO_EXTERNAL");
                if (shouldMoveData) {
                    Database db;
                    try {
                        db = msdb.getDatabase(catName, dbname);
                        destPath = wh.getPartitionPath(db, tbl, new_part.getValues());
                        destPath = this.constructRenamedPath(destPath, new Path(new_part.getSd().getLocation()));
                    }
                    catch (NoSuchObjectException e) {
                        LOG.debug("Didn't find object in metastore ", (Throwable)e);
                        throw new InvalidOperationException("Unable to change partition or table. Database " + dbname + " does not exist Check metastore logs for detailed stack." + e.getMessage());
                    }
                    String newPartLoc = destPath.toString();
                    String oldPartLoc = oldPart.getSd().getLocation();
                    LOG.info("srcPath:" + oldPartLoc);
                    LOG.info("descPath:" + newPartLoc);
                    srcPath = new Path(oldPartLoc);
                    FileSystem srcFs = wh.getFs(srcPath);
                    destFs = wh.getFs(destPath);
                    if (!FileUtils.equalsFileSystem((FileSystem)srcFs, (FileSystem)destFs)) {
                        throw new InvalidOperationException("New table location " + String.valueOf(destPath) + " is on a different file system than the old location " + String.valueOf(srcPath) + ". This operation is not supported.");
                    }
                    try {
                        if (srcFs.exists(srcPath)) {
                            if (newPartLoc.compareTo(oldPartLoc) != 0 && destFs.exists(destPath)) {
                                throw new InvalidOperationException("New location for this table " + tbl.getDbName() + "." + tbl.getTableName() + " already exists : " + String.valueOf(destPath));
                            }
                            Path destParentPath = destPath.getParent();
                            if (!wh.mkdirs(destParentPath)) {
                                throw new MetaException("Unable to create path " + String.valueOf(destParentPath));
                            }
                            boolean clonePart = Optional.ofNullable(environmentContext).map(EnvironmentContext::getProperties).map(prop -> (String)prop.get("renamePartitionMakeCopy")).map(Boolean::parseBoolean).orElse(false);
                            long writeId = new_part.getWriteId();
                            if (writeId > 0L && clonePart) {
                                LOG.debug("Making a copy of the partition directory: {} under a new location: {}", (Object)srcPath, (Object)destPath);
                                if (!wh.copyDir(srcPath, destPath, ReplChangeManager.shouldEnableCm((Database)db, (Table)tbl))) {
                                    LOG.error("Copy failed for source: " + String.valueOf(srcPath) + " to destination: " + String.valueOf(destPath));
                                    throw new IOException("File copy failed.");
                                }
                                HMSHandler.addTruncateBaseFile(srcPath, writeId, this.conf, AcidMetaDataFile.DataFormat.DROPPED);
                            } else {
                                wh.renameDir(srcPath, destPath, ReplChangeManager.shouldEnableCm((Database)db, (Table)tbl));
                            }
                            LOG.info("Partition directory rename from " + String.valueOf(srcPath) + " to " + String.valueOf(destPath) + " done.");
                            dataWasMoved = true;
                        }
                    }
                    catch (IOException e) {
                        LOG.error("Cannot rename partition directory from " + String.valueOf(srcPath) + " to " + String.valueOf(destPath), (Throwable)e);
                        throw new InvalidOperationException("Unable to access src or dest location for partition " + tbl.getDbName() + "." + tbl.getTableName() + " " + String.valueOf(new_part.getValues()));
                    }
                    catch (MetaException me) {
                        LOG.error("Cannot rename partition directory from " + String.valueOf(srcPath) + " to " + String.valueOf(destPath), (Throwable)me);
                        throw me;
                    }
                    new_part.getSd().setLocation(newPartLoc);
                } else {
                    new_part.getSd().setLocation(oldPart.getSd().getLocation());
                }
                if (MetaStoreServerUtils.requireCalStats(oldPart, new_part, tbl, environmentContext)) {
                    MetaStoreServerUtils.updatePartitionStatsFast(new_part, tbl, wh, false, true, environmentContext, false);
                }
                HiveAlterHandler.updateOrGetPartitionColumnStats(msdb, catName, dbname, name, oldPart.getValues(), oldPart.getSd().getCols(), tbl, new_part, null);
                msdb.alterPartition(catName, dbname, name, part_vals, new_part, validWriteIds);
                if (transactionalListeners != null && !transactionalListeners.isEmpty()) {
                    MetaStoreListenerNotifier.notifyEvent(transactionalListeners, EventMessage.EventType.ALTER_PARTITION, new AlterPartitionEvent(oldPart, new_part, tbl, false, true, new_part.getWriteId(), handler), environmentContext);
                }
                if (success = msdb.commitTransaction()) break block50;
            }
            catch (Throwable throwable) {
                if (!success) {
                    LOG.error("Failed to rename a partition. Rollback transaction");
                    msdb.rollbackTransaction();
                    if (dataWasMoved) {
                        LOG.error("Revert the data move in renaming a partition.");
                        try {
                            if (destFs.exists(destPath)) {
                                wh.renameDir(destPath, srcPath, false);
                            }
                        }
                        catch (IOException | MetaException me) {
                            LOG.error("Failed to restore partition data from " + String.valueOf(destPath) + " to " + String.valueOf(srcPath) + " in alter partition failure. Manual restore is needed.");
                        }
                    }
                }
                throw throwable;
            }
            LOG.error("Failed to rename a partition. Rollback transaction");
            msdb.rollbackTransaction();
            if (dataWasMoved) {
                LOG.error("Revert the data move in renaming a partition.");
                try {
                    if (destFs.exists(destPath)) {
                        wh.renameDir(destPath, srcPath, false);
                    }
                }
                catch (IOException | MetaException me) {
                    LOG.error("Failed to restore partition data from " + String.valueOf(destPath) + " to " + String.valueOf(srcPath) + " in alter partition failure. Manual restore is needed.");
                }
            }
        }
        return oldPart;
    }

    private Map<List<String>, Partition> getExistingPartitions(RawStore msdb, List<Partition> new_parts, Table tbl, String catName, String dbname, String name) throws MetaException, NoSuchObjectException, InvalidOperationException {
        LinkedList<String> partValues = new LinkedList<String>();
        for (Partition tmpPart : new_parts) {
            partValues.add(Warehouse.makePartName((List)tbl.getPartitionKeys(), (List)tmpPart.getValues()));
        }
        List<Partition> oldParts = msdb.getPartitionsByNames(catName, dbname, name, partValues);
        if (new_parts.size() != oldParts.size()) {
            throw new InvalidOperationException("Alter partition operation failed: new parts size " + new_parts.size() + " not matching with old parts size " + oldParts.size());
        }
        return oldParts.stream().collect(Collectors.toMap(Partition::getValues, Partition2 -> Partition2));
    }

    @Override
    public List<Partition> alterPartitions(RawStore msdb, Warehouse wh, String catName, String dbname, String name, List<Partition> new_parts, EnvironmentContext environmentContext, String writeIdList, long writeId, IHMSHandler handler) throws InvalidOperationException, InvalidObjectException, AlreadyExistsException, MetaException {
        ArrayList<Partition> oldParts = new ArrayList<Partition>();
        ArrayList<List<String>> partValsList = new ArrayList<List<String>>();
        List<TransactionalMetaStoreEventListener> transactionalListeners = null;
        if (handler != null) {
            transactionalListeners = handler.getTransactionalListeners();
        }
        boolean success = false;
        try {
            msdb.openTransaction();
            Table tbl = msdb.getTable(catName, dbname, name, null);
            if (tbl == null) {
                throw new InvalidObjectException("Unable to alter partitions because table or database does not exist.");
            }
            this.blockPartitionLocationChangesOnReplSource(msdb.getDatabase(catName, dbname), tbl, environmentContext);
            Map<List<String>, Partition> oldPartMap = this.getExistingPartitions(msdb, new_parts, tbl, catName, dbname, name);
            for (Partition tmpPart : new_parts) {
                if (tmpPart.getParameters() == null || tmpPart.getParameters().get("transient_lastDdlTime") == null || Integer.parseInt((String)tmpPart.getParameters().get("transient_lastDdlTime")) == 0) {
                    tmpPart.putToParameters("transient_lastDdlTime", Long.toString(System.currentTimeMillis() / 1000L));
                }
                Partition oldTmpPart = oldPartMap.get(tmpPart.getValues());
                oldParts.add(oldTmpPart);
                partValsList.add(tmpPart.getValues());
                if (MetaStoreServerUtils.requireCalStats(oldTmpPart, tmpPart, tbl, environmentContext)) {
                    if (MetaStoreServerUtils.isFastStatsSame(oldTmpPart, tmpPart)) {
                        MetaStoreServerUtils.updateBasicState(environmentContext, tmpPart.getParameters());
                    } else {
                        MetaStoreServerUtils.updatePartitionStatsFast(tmpPart, tbl, wh, false, true, environmentContext, false);
                    }
                }
                if (oldTmpPart.getSd() == null) continue;
                HiveAlterHandler.updateOrGetPartitionColumnStats(msdb, catName, dbname, name, oldTmpPart.getValues(), oldTmpPart.getSd().getCols(), tbl, tmpPart, null);
            }
            msdb.alterPartitions(catName, dbname, name, partValsList, new_parts, writeId, writeIdList);
            if (transactionalListeners != null && !transactionalListeners.isEmpty()) {
                boolean shouldSendSingleEvent = MetastoreConf.getBoolVar((Configuration)handler.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.NOTIFICATION_ALTER_PARTITIONS_V2_ENABLED);
                if (shouldSendSingleEvent) {
                    MetaStoreListenerNotifier.notifyEvent(transactionalListeners, EventMessage.EventType.ALTER_PARTITIONS, new AlterPartitionsEvent(oldParts, new_parts, tbl, false, true, handler), environmentContext);
                } else {
                    for (Partition newPart : new_parts) {
                        Partition oldPart = oldPartMap.get(newPart.getValues());
                        MetaStoreListenerNotifier.notifyEvent(transactionalListeners, EventMessage.EventType.ALTER_PARTITION, new AlterPartitionEvent(oldPart, newPart, tbl, false, true, newPart.getWriteId(), handler), environmentContext);
                    }
                }
            }
            success = msdb.commitTransaction();
        }
        catch (InvalidObjectException | NoSuchObjectException e) {
            throw new InvalidOperationException("Alter partition operation failed: " + String.valueOf(e));
        }
        finally {
            if (!success) {
                msdb.rollbackTransaction();
            }
        }
        return oldParts;
    }

    private void blockPartitionLocationChangesOnReplSource(Database db, Table tbl, EnvironmentContext ec) throws InvalidOperationException {
        String alterType;
        if (!ReplChangeManager.isSourceOfReplication((Database)db)) {
            return;
        }
        if (ec != null && ec.isSetProperties() && (alterType = (String)ec.getProperties().get("alterTableOpType")) != null && alterType.equalsIgnoreCase("ALTERLOCATION") && tbl.getTableType().equalsIgnoreCase(TableType.MANAGED_TABLE.name())) {
            String tableName = TableName.getQualified((String)tbl.getCatName(), (String)tbl.getDbName(), (String)tbl.getTableName());
            throw new InvalidOperationException("Cannot change location of a managed table " + tableName + " as it is enabled for replication.");
        }
    }

    private void validateTableChangesOnReplSource(Database db, Table oldTbl, Table newTbl, EnvironmentContext ec) throws InvalidOperationException {
        String alterType;
        if (!ReplChangeManager.isSourceOfReplication((Database)db)) {
            return;
        }
        if (ec != null && ec.isSetProperties() && (alterType = (String)ec.getProperties().get("alterTableOpType")) != null && alterType.equalsIgnoreCase("ALTERLOCATION") && oldTbl.getTableType().equalsIgnoreCase(TableType.MANAGED_TABLE.name())) {
            String tableName = TableName.getQualified((String)oldTbl.getCatName(), (String)oldTbl.getDbName(), (String)oldTbl.getTableName());
            throw new InvalidOperationException("Cannot change location of a managed table " + tableName + " as it is enabled for replication.");
        }
        if (this.conf.getBoolean(MetastoreConf.ConfVars.STRICT_MANAGED_TABLES.getHiveName(), false)) {
            return;
        }
        if (!oldTbl.getTableType().equalsIgnoreCase(newTbl.getTableType())) {
            throw new InvalidOperationException("Table type cannot be changed from " + oldTbl.getTableType() + " to " + newTbl.getTableType() + " for the table " + TableName.getQualified((String)oldTbl.getCatName(), (String)oldTbl.getDbName(), (String)oldTbl.getTableName()) + " as it is enabled for replication.");
        }
        if (!TxnUtils.isTransactionalTable(oldTbl) && TxnUtils.isTransactionalTable(newTbl)) {
            throw new InvalidOperationException("A non-Acid table cannot be converted to an Acid table for the table " + TableName.getQualified((String)oldTbl.getCatName(), (String)oldTbl.getDbName(), (String)oldTbl.getTableName()) + " as it is enabled for replication.");
        }
    }

    private boolean checkPartialPartKeysEqual(List<FieldSchema> oldPartKeys, List<FieldSchema> newPartKeys) {
        if (newPartKeys == null || oldPartKeys == null) {
            return oldPartKeys == newPartKeys;
        }
        if (oldPartKeys.size() != newPartKeys.size()) {
            return false;
        }
        Iterator<FieldSchema> oldPartKeysIter = oldPartKeys.iterator();
        Iterator<FieldSchema> newPartKeysIter = newPartKeys.iterator();
        while (oldPartKeysIter.hasNext()) {
            FieldSchema oldFs = oldPartKeysIter.next();
            FieldSchema newFs = newPartKeysIter.next();
            if (oldFs.getName().equals(newFs.getName())) continue;
            return false;
        }
        return true;
    }

    private Path constructRenamedPath(Path defaultNewPath, Path currentPath) {
        URI currentUri = currentPath.toUri();
        return new Path(currentUri.getScheme(), currentUri.getAuthority(), defaultNewPath.toUri().getPath());
    }

    @VisibleForTesting
    public void deleteTableColumnStats(RawStore msdb, Table oldTable, Table newTable) throws InvalidObjectException, MetaException {
        try {
            String catName = StringUtils.normalizeIdentifier((String)(oldTable.isSetCatName() ? oldTable.getCatName() : MetaStoreUtils.getDefaultCatalog((Configuration)msdb.getConf())));
            String dbName = oldTable.getDbName().toLowerCase();
            String tableName = StringUtils.normalizeIdentifier((String)oldTable.getTableName());
            List<String> staleColumns = MetaStoreServerUtils.findStaleColumns(oldTable.getSd().getCols(), newTable.getSd().getCols());
            if (!staleColumns.isEmpty() && TxnUtils.isAcidTable(oldTable) == TxnUtils.isAcidTable(newTable)) {
                msdb.deleteTableColumnStatistics(catName, dbName, tableName, staleColumns, null);
                Map parameters = newTable.getParameters();
                if (parameters != null && parameters.containsKey("COLUMN_STATS_ACCURATE")) {
                    StatsSetupConst.removeColumnStatsState((Map)parameters, staleColumns);
                }
            }
        }
        catch (NoSuchObjectException nsoe) {
            LOG.debug("Could not find db entry." + String.valueOf((Object)nsoe));
        }
        catch (InvalidInputException e) {
            throw new InvalidObjectException("Invalid inputs to update table column stats: " + String.valueOf((Object)e));
        }
    }

    public static void updateOrGetPartitionColumnStats(RawStore msdb, String catName, String dbname, String tblname, List<String> partVals, List<FieldSchema> oldCols, Table table, Partition part, List<String> deletedCols) throws MetaException, InvalidObjectException {
        try {
            List newCols = part.getSd().getCols();
            String oldPartName = Warehouse.makePartName((List)table.getPartitionKeys(), partVals);
            List<String> staleColumns = MetaStoreServerUtils.findStaleColumns(oldCols, newCols);
            if (staleColumns.isEmpty()) {
                return;
            }
            if (deletedCols == null) {
                msdb.deletePartitionColumnStatistics(catName, dbname, tblname, Lists.newArrayList((Object[])new String[]{oldPartName}), staleColumns, null);
            } else {
                deletedCols.addAll(staleColumns);
            }
            Map parameters = part.getParameters();
            if (parameters != null && parameters.containsKey("COLUMN_STATS_ACCURATE")) {
                StatsSetupConst.removeColumnStatsState((Map)parameters, staleColumns);
            }
        }
        catch (NoSuchObjectException newCols) {
        }
        catch (InvalidInputException iie) {
            throw new InvalidObjectException("Invalid input to delete partition column stats." + String.valueOf((Object)iie));
        }
    }
}

