/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.histogram;

import org.apache.hadoop.hive.common.histogram.KllHistogramEstimator;
import org.apache.hadoop.hive.common.histogram.kll.KllUtils;

public class KllHistogramEstimatorFactory {
    private KllHistogramEstimatorFactory() {
        throw new AssertionError((Object)"Suppress default constructor for non instantiation");
    }

    public static KllHistogramEstimator getKllHistogramEstimator(byte[] buf) {
        return new KllHistogramEstimator(KllUtils.deserializeKll(buf, 0, buf.length));
    }

    public static KllHistogramEstimator getKllHistogramEstimator(byte[] buf, int start, int len) {
        return new KllHistogramEstimator(KllUtils.deserializeKll(buf, start, len));
    }

    public static KllHistogramEstimator getEmptyHistogramEstimator() {
        return new KllHistogramEstimator();
    }

    public static KllHistogramEstimator getEmptyHistogramEstimator(int k) {
        return new KllHistogramEstimator(k);
    }

    public static KllHistogramEstimator getEmptyHistogramEstimator(KllHistogramEstimator kllHistogramEstimator) {
        return kllHistogramEstimator == null ? KllHistogramEstimatorFactory.getEmptyHistogramEstimator() : KllHistogramEstimatorFactory.getEmptyHistogramEstimator(kllHistogramEstimator.getSketch().getK());
    }
}

