/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.client;

import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.tez.common.Preconditions;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class CallerContext {
    private String context;
    private String callerType;
    private String callerId;
    private String blob;

    private CallerContext() {
    }

    public static CallerContext create(String context, String callerId, String callerType, @Nullable String blob) {
        return new CallerContext(context, callerId, callerType, blob);
    }

    @InterfaceAudience.Private
    public static CallerContext create(String context, @Nullable String blob) {
        return new CallerContext(context, blob);
    }

    private CallerContext(String context, String callerId, String callerType, @Nullable String blob) {
        if (callerId != null || callerType != null) {
            this.setCallerIdAndType(callerId, callerType);
        }
        this.setContext(context);
        this.setBlob(blob);
    }

    private CallerContext(String context, @Nullable String blob) {
        this.setContext(context);
        this.setBlob(blob);
    }

    public String getCallerType() {
        return this.callerType;
    }

    public String getCallerId() {
        return this.callerId;
    }

    public String getBlob() {
        return this.blob;
    }

    public String getContext() {
        return this.context;
    }

    public CallerContext setContext(String context) {
        Preconditions.checkArgument(context != null && !context.isEmpty(), "Context cannot be null or empty");
        this.context = context;
        return this;
    }

    public CallerContext setCallerIdAndType(String callerId, String callerType) {
        Preconditions.checkArgument(callerType != null && !callerType.isEmpty() && callerId != null && !callerId.isEmpty(), "Caller Id and Caller Type cannot be null or empty");
        this.callerType = callerType;
        this.callerId = callerId;
        return this;
    }

    public CallerContext setBlob(@Nullable String blob) {
        this.blob = blob;
        return this;
    }

    public String toString() {
        return "{ context=" + this.context + ", callerType=" + this.callerType + ", callerId=" + this.callerId + ", blob=" + this.blob + " }";
    }

    public String contextAsSimpleString() {
        return "{ context=" + this.context + ", callerType=" + this.callerType + ", callerId=" + this.callerId + " }";
    }
}

