/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.lang.reflect.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NotYetFlushedException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.scostore.ElementContainerStore;
import org.datanucleus.store.types.scostore.ArrayStore;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public abstract class AbstractArrayStore<E>
extends ElementContainerStore
implements ArrayStore<E> {
    protected AbstractArrayStore(RDBMSStoreManager storeMgr, ClassLoaderResolver clr) {
        super(storeMgr, clr);
    }

    public List<E> getArray(DNStateManager sm) {
        Iterator<E> iter = this.iterator(sm);
        ArrayList<E> elements = new ArrayList<E>();
        while (iter.hasNext()) {
            E elem = iter.next();
            elements.add(elem);
        }
        return elements;
    }

    @Override
    public void clear(DNStateManager sm) {
        HashSet<E> dependentElements = null;
        if (this.ownerMemberMetaData.getArray().isDependentElement()) {
            dependentElements = new HashSet<E>();
            Iterator<E> iter = this.iterator(sm);
            while (iter.hasNext()) {
                E elem = iter.next();
                if (!sm.getExecutionContext().getApiAdapter().isPersistable(elem)) continue;
                dependentElements.add(elem);
            }
        }
        this.clearInternal(sm);
        if (dependentElements != null && dependentElements.size() > 0) {
            sm.getExecutionContext().deleteObjects(dependentElements.toArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(DNStateManager sm, Object array) {
        if (array == null || Array.getLength(array) == 0) {
            return true;
        }
        ExecutionContext ec = sm.getExecutionContext();
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object obj = Array.get(array, i);
            this.validateElementForWriting(ec, obj, null);
        }
        boolean modified = false;
        ArrayList exceptions = new ArrayList();
        boolean batched = this.allowsBatching() && length > 1;
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
        try {
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                sqlControl.processStatementsForConnection(mconn);
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException("SQLException", (Throwable)e);
            }
            Object element = null;
            for (int i = 0; i < length; ++i) {
                element = Array.get(array, i);
                int[] rc = this.internalAdd(sm, element, mconn, batched, i, i == length - 1);
                if (rc == null) continue;
                for (int j = 0; j < rc.length; ++j) {
                    if (rc[j] <= 0) continue;
                    modified = true;
                }
            }
        }
        finally {
            mconn.release();
        }
        if (!exceptions.isEmpty()) {
            String msg = Localiser.msg((String)"056009", (Object[])new Object[]{((Throwable)exceptions.get(0)).getMessage()});
            NucleusLogger.DATASTORE.error((Object)msg);
            throw new NucleusDataStoreException(msg, exceptions.toArray(new Throwable[exceptions.size()]), sm.getObject());
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(DNStateManager sm, E element, int position) {
        ExecutionContext ec = sm.getExecutionContext();
        this.validateElementForWriting(ec, element, null);
        boolean modified = false;
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
        try {
            int[] returnCode = this.internalAdd(sm, element, mconn, false, position, true);
            if (returnCode[0] > 0) {
                modified = true;
            }
        }
        finally {
            mconn.release();
        }
        return modified;
    }

    @Override
    public abstract Iterator<E> iterator(DNStateManager var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInternal(DNStateManager ownerSM) {
        String clearStmt = this.getClearStmt();
        try {
            ExecutionContext ec = ownerSM.getExecutionContext();
            ManagedConnection mconn = this.getStoreManager().getConnectionManager().getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, clearStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(ownerSM, ec, ps, jdbcPosition, this);
                    if (this.relationDiscriminatorMapping != null) {
                        BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                    }
                    sqlControl.executeStatementUpdate(ec, mconn, clearStmt, ps, true);
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"056013", (Object[])new Object[]{clearStmt}), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] internalAdd(DNStateManager sm, E element, ManagedConnection conn, boolean batched, int orderId, boolean executeNow) {
        ExecutionContext ec = sm.getExecutionContext();
        SQLController sqlControl = this.storeMgr.getSQLController();
        String addStmt = this.getAddStmtForJoinTable();
        try {
            PreparedStatement ps = sqlControl.getStatementForUpdate(conn, addStmt, batched);
            boolean notYetFlushedError = false;
            try {
                int jdbcPosition = 1;
                jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, ec, ps, jdbcPosition, this);
                jdbcPosition = BackingStoreHelper.populateElementInStatement(ec, ps, element, jdbcPosition, this.elementMapping);
                jdbcPosition = BackingStoreHelper.populateOrderInStatement(ec, ps, orderId, jdbcPosition, this.orderMapping);
                if (this.relationDiscriminatorMapping != null) {
                    jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                }
                int[] nArray = sqlControl.executeStatementUpdate(ec, conn, addStmt, ps, executeNow);
                return nArray;
            }
            catch (NotYetFlushedException nfe) {
                notYetFlushedError = true;
                throw nfe;
            }
            finally {
                if (notYetFlushedError) {
                    sqlControl.abortStatementForConnection(conn, ps);
                } else {
                    sqlControl.closeStatement(conn, ps);
                }
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"056009", (Object[])new Object[]{addStmt}), (Throwable)e);
        }
    }
}

