/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.v1.model.instance;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.atlas.v1.model.instance.Id;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class AtlasSystemAttributes
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String createdBy;
    private String modifiedBy;
    private Date createdTime;
    private Date modifiedTime;

    public AtlasSystemAttributes() {
    }

    public AtlasSystemAttributes(AtlasSystemAttributes that) {
        if (that != null) {
            this.createdBy = that.createdBy;
            this.modifiedBy = that.modifiedBy;
            this.createdTime = that.createdTime;
            this.modifiedTime = that.modifiedTime;
        }
    }

    public AtlasSystemAttributes(String createdBy, String modifiedBy, Date createdTime, Date modifiedTime) {
        this.createdBy = createdBy;
        this.modifiedBy = modifiedBy;
        this.createdTime = createdTime;
        this.modifiedTime = modifiedTime;
    }

    public AtlasSystemAttributes(Map<String, Object> map) {
        this();
        if (map != null) {
            this.createdBy = Id.asString(map.get("createdBy"));
            this.modifiedBy = Id.asString(map.get("modifiedBy"));
            this.createdTime = Id.asDate(map.get("createdTime"));
            this.modifiedTime = Id.asDate(map.get("modifiedTime"));
        }
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getModifiedTime() {
        return this.modifiedTime;
    }

    public void setModifiedTime(Date modifiedTime) {
        this.modifiedTime = modifiedTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtlasSystemAttributes obj = (AtlasSystemAttributes)o;
        return Objects.equals(this.createdBy, obj.createdBy) && Objects.equals(this.modifiedBy, obj.modifiedBy) && Objects.equals(this.createdTime, obj.createdTime) && Objects.equals(this.modifiedTime, obj.modifiedTime);
    }

    public int hashCode() {
        return Objects.hash(this.createdBy, this.modifiedBy, this.createdTime, this.modifiedTime);
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("AtlasSystemAttributes{").append("createdBy=").append(this.createdBy).append(", modifiedBy=").append(this.modifiedBy).append(", createdTime=").append(this.createdTime).append(", modifiedTime=").append(this.modifiedTime).append("}");
        return sb;
    }
}

