/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.profile;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.atlas.model.AtlasBaseModelObject;
import org.apache.atlas.model.profile.AtlasUserSavedSearch;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AtlasUserProfile
extends AtlasBaseModelObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String fullName;
    private List<AtlasUserSavedSearch> savedSearches;

    public AtlasUserProfile() {
        this(null, null);
    }

    public AtlasUserProfile(String name) {
        this(name, null);
    }

    public AtlasUserProfile(String name, String fullName) {
        this.name = name;
        this.fullName = fullName;
        this.savedSearches = new ArrayList<AtlasUserSavedSearch>();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setSavedSearches(List<AtlasUserSavedSearch> searches) {
        this.savedSearches = searches;
    }

    public List<AtlasUserSavedSearch> getSavedSearches() {
        return this.savedSearches;
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        sb.append(", name=").append(this.name);
        sb.append(", fullName=").append(this.fullName);
        sb.append(", savedSearches=[");
        if (this.savedSearches != null) {
            AtlasBaseTypeDef.dumpObjects(this.savedSearches, sb);
        }
        sb.append("]");
        return sb;
    }
}

