/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimator;
import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimatorFactory;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.io.BytesWritable;

public abstract class GenericUDAFComputeBitVectorBase
extends AbstractGenericUDAFResolver {
    @InterfaceAudience.LimitedPrivate(value={"Hive"})
    static int lengthFor(JavaDataModel model) {
        int length = model.object();
        length += model.array() * 3;
        length += model.primitive1() * 16 * 2;
        return length += (model.object() + model.array() + model.primitive1() + model.primitive2()) * 16;
    }

    @GenericUDAFEvaluator.AggregationType(estimable=true)
    public static class StringStatsAgg
    extends GenericUDAFEvaluator.AbstractAggregationBuffer {
        public NumDistinctValueEstimator numDV;
        public boolean firstItem;

        @Override
        public int estimate() {
            JavaDataModel model = JavaDataModel.get();
            return this.numDV == null ? GenericUDAFComputeBitVectorBase.lengthFor(model) : this.numDV.lengthFor(model);
        }
    }

    @GenericUDAFEvaluator.AggregationType(estimable=true)
    public static class TimestampStatsAgg
    extends NumericStatsAgg {
        @Override
        public int estimate() {
            JavaDataModel model = JavaDataModel.get();
            return super.estimate() + model.primitive2() * 2;
        }

        @Override
        protected void update(Object p, PrimitiveObjectInspector inputOI) {
            TimestampWritableV2 v = new TimestampWritableV2((TimestampWritableV2)inputOI.getPrimitiveWritableObject(p));
            this.numDV.addToEstimator(v.getSeconds());
        }
    }

    @GenericUDAFEvaluator.AggregationType(estimable=true)
    public static class DateStatsAgg
    extends NumericStatsAgg {
        @Override
        public int estimate() {
            JavaDataModel model = JavaDataModel.get();
            return super.estimate() + model.primitive2() * 2;
        }

        @Override
        protected void update(Object p, PrimitiveObjectInspector inputOI) {
            DateWritableV2 v = new DateWritableV2((DateWritableV2)inputOI.getPrimitiveWritableObject(p));
            this.numDV.addToEstimator((long)v.getDays());
        }
    }

    @GenericUDAFEvaluator.AggregationType(estimable=true)
    public static class DecimalStatsAgg
    extends NumericStatsAgg {
        @Override
        public int estimate() {
            JavaDataModel model = JavaDataModel.get();
            return super.estimate() + model.lengthOfDecimal() * 2;
        }

        @Override
        protected void update(Object p, PrimitiveObjectInspector inputOI) {
            HiveDecimal v = PrimitiveObjectInspectorUtils.getHiveDecimal((Object)p, (PrimitiveObjectInspector)inputOI);
            this.numDV.addToEstimator(v);
        }
    }

    @GenericUDAFEvaluator.AggregationType(estimable=true)
    public static class DoubleStatsAgg
    extends NumericStatsAgg {
        @Override
        public int estimate() {
            JavaDataModel model = JavaDataModel.get();
            return super.estimate() + model.primitive2() * 2;
        }

        @Override
        protected void update(Object p, PrimitiveObjectInspector inputOI) {
            double v = PrimitiveObjectInspectorUtils.getDouble((Object)p, (PrimitiveObjectInspector)inputOI);
            this.numDV.addToEstimator(v);
        }
    }

    @GenericUDAFEvaluator.AggregationType(estimable=true)
    public static class LongStatsAgg
    extends NumericStatsAgg {
        @Override
        public int estimate() {
            JavaDataModel model = JavaDataModel.get();
            return super.estimate() + model.primitive2() * 2;
        }

        @Override
        protected void update(Object p, PrimitiveObjectInspector inputOI) {
            long v = PrimitiveObjectInspectorUtils.getLong((Object)p, (PrimitiveObjectInspector)inputOI);
            this.numDV.addToEstimator(v);
        }
    }

    public static abstract class NumericStatsAgg
    extends GenericUDAFEvaluator.AbstractAggregationBuffer {
        public NumDistinctValueEstimator numDV;

        @Override
        public int estimate() {
            JavaDataModel model = JavaDataModel.get();
            return this.numDV == null ? GenericUDAFComputeBitVectorBase.lengthFor(model) : this.numDV.lengthFor(model);
        }

        protected abstract void update(Object var1, PrimitiveObjectInspector var2);

        protected Object serialize(BytesWritable result) {
            if (this.numDV != null) {
                byte[] buf = this.numDV.serialize();
                result.set(buf, 0, buf.length);
            }
            return result;
        }

        protected Object serializePartial(BytesWritable result) {
            if (this.numDV != null) {
                byte[] buf = this.numDV.serialize();
                result.set(buf, 0, buf.length);
            }
            return result;
        }

        public void reset() throws HiveException {
            this.numDV = null;
        }
    }

    public static abstract class StringStatsEvaluatorBase
    extends GenericUDAFEvaluator {
        protected transient PrimitiveObjectInspector inputOI;
        protected transient BinaryObjectInspector ndvFieldOI;
        protected transient BytesWritable partialResult;
        protected transient BytesWritable result;

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            StringStatsAgg result = new StringStatsAgg();
            this.reset(result);
            return result;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            StringStatsAgg myagg = (StringStatsAgg)agg;
            myagg.firstItem = true;
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial != null) {
                StringStatsAgg myagg = (StringStatsAgg)agg;
                byte[] buf = this.ndvFieldOI.getPrimitiveJavaObject(partial);
                if (buf != null && buf.length != 0) {
                    if (myagg.numDV == null) {
                        myagg.numDV = NumDistinctValueEstimatorFactory.getNumDistinctValueEstimator((byte[])buf);
                    } else {
                        myagg.numDV.mergeEstimators(NumDistinctValueEstimatorFactory.getNumDistinctValueEstimator((byte[])buf));
                    }
                }
            }
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            StringStatsAgg myagg = (StringStatsAgg)agg;
            if (myagg.numDV != null) {
                byte[] buf = myagg.numDV.serialize();
                this.partialResult.set(buf, 0, buf.length);
            }
            return this.partialResult;
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            StringStatsAgg myagg = (StringStatsAgg)agg;
            if (myagg.numDV != null) {
                byte[] buf = myagg.numDV.serialize();
                this.result.set(buf, 0, buf.length);
            }
            return this.result;
        }
    }

    public static abstract class NumericStatsEvaluatorBase<V, OI extends PrimitiveObjectInspector>
    extends GenericUDAFEvaluator {
        protected transient PrimitiveObjectInspector inputOI;
        protected transient BinaryObjectInspector ndvFieldOI;
        protected transient BytesWritable partialResult;
        protected transient BytesWritable result;

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            ((NumericStatsAgg)agg).reset();
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial != null) {
                NumericStatsAgg myagg = (NumericStatsAgg)agg;
                byte[] buf = this.ndvFieldOI.getPrimitiveJavaObject(partial);
                if (buf != null && buf.length != 0) {
                    if (myagg.numDV == null) {
                        myagg.numDV = NumDistinctValueEstimatorFactory.getNumDistinctValueEstimator((byte[])buf);
                    } else {
                        myagg.numDV.mergeEstimators(NumDistinctValueEstimatorFactory.getNumDistinctValueEstimator((byte[])buf));
                    }
                }
            }
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            return ((NumericStatsAgg)agg).serializePartial(this.partialResult);
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            return ((NumericStatsAgg)agg).serialize(this.result);
        }
    }
}

