/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.Text;

@Description(name="replace", value="_FUNC_(str, search, rep) - replace all substrings of 'str' that match 'search' with 'rep'", extended="Example:\n  > SELECT _FUNC_('Hack and Hue', 'H', 'BL') FROM src LIMIT 1;\n  'BLack and BLue'")
public class UDFReplace
extends UDF {
    private Text result = new Text();

    public Text evaluate(Text s, Text search, Text replacement) {
        if (s == null || search == null || replacement == null) {
            return null;
        }
        String r = s.toString().replace(search.toString(), replacement.toString());
        this.result.set(r);
        return this.result;
    }
}

