/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan.ptf;

import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.WindowingSpec;
import org.apache.hadoop.hive.ql.plan.ptf.BoundaryDef;
import org.apache.hadoop.hive.ql.plan.ptf.OrderDef;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class WindowFrameDef {
    private WindowingSpec.WindowType windowType;
    private BoundaryDef start;
    private BoundaryDef end;
    private final int windowSize;
    private OrderDef orderDef;

    public WindowFrameDef(WindowingSpec.WindowType windowType, BoundaryDef start, BoundaryDef end) {
        this.windowType = windowType;
        this.start = start;
        this.end = end;
        this.windowSize = start.getDirection() == end.getDirection() ? Math.abs(end.getAmt() - start.getAmt()) + 1 : end.getAmt() + start.getAmt() + 1;
    }

    public BoundaryDef getStart() {
        return this.start;
    }

    public BoundaryDef getEnd() {
        return this.end;
    }

    public WindowingSpec.WindowType getWindowType() {
        return this.windowType;
    }

    public void setOrderDef(OrderDef orderDef) {
        this.orderDef = orderDef;
    }

    public OrderDef getOrderDef() throws HiveException {
        if (this.windowType != WindowingSpec.WindowType.RANGE) {
            throw new HiveException("Order expressions should only be used for RANGE windowing type");
        }
        return this.orderDef;
    }

    public boolean isStartUnbounded() {
        return this.start.isUnbounded();
    }

    public boolean isEndUnbounded() {
        return this.end.isUnbounded();
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public String toString() {
        return String.valueOf((Object)this.windowType) + " " + String.valueOf(this.start) + "~" + String.valueOf(this.end);
    }
}

