/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ConstantVectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBytesCountDistinct;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorCount;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorCountStar;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorDecimalAvg;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorDecimalCountDistinct;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorDecimalFirstValue;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorDecimalLastValue;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorDecimalMax;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorDecimalMin;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorDecimalSum;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorDenseRank;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorDoubleAvg;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorDoubleCountDistinct;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorDoubleFirstValue;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorDoubleLastValue;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorDoubleMax;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorDoubleMin;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorDoubleSum;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorLag;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorLead;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorLongAvg;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorLongCountDistinct;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorLongFirstValue;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorLongLastValue;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorLongMax;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorLongMin;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorLongSum;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorRank;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorRowNumber;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorStreamingDecimalAvg;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorStreamingDecimalMax;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorStreamingDecimalMin;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorStreamingDecimalSum;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorStreamingDoubleAvg;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorStreamingDoubleMax;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorStreamingDoubleMin;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorStreamingDoubleSum;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorStreamingLongAvg;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorStreamingLongMax;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorStreamingLongMin;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorStreamingLongSum;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorTimestampCountDistinct;
import org.apache.hadoop.hive.ql.parse.WindowingSpec;
import org.apache.hadoop.hive.ql.plan.AbstractVectorDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.VectorPTFInfo;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class VectorPTFDesc
extends AbstractVectorDesc {
    private static final long serialVersionUID = 1L;
    public static HashMap<String, SupportedFunctionType> supportedFunctionsMap = new HashMap();
    public static List<String> supportedFunctionNames;
    private TypeInfo[] reducerBatchTypeInfos;
    private DataTypePhysicalVariation[] reducerBatchDataTypePhysicalVariations;
    private boolean isPartitionOrderBy = false;
    private String[] evaluatorFunctionNames = null;
    private boolean[] evaluatorsAreDistinct = null;
    private boolean[] evaluatorsRespectNulls = null;
    private WindowFrameDef[] evaluatorWindowFrameDefs;
    private List<ExprNodeDesc>[] evaluatorInputExprNodeDescLists = null;
    private ExprNodeDesc[] orderExprNodeDescs = null;
    private ExprNodeDesc[] partitionExprNodeDescs = null;
    private String[] outputColumnNames = null;
    private TypeInfo[] outputTypeInfos = null;
    private DataTypePhysicalVariation[] outputDataTypePhysicalVariations;
    private VectorPTFInfo vectorPTFInfo;
    private int vectorizedPTFMaxMemoryBufferingBatchCount = -1;

    public static VectorPTFEvaluatorBase getEvaluator(SupportedFunctionType functionType, boolean isDistinct, boolean respectNulls, WindowFrameDef windowFrameDef, ColumnVector.Type[] columnVectorTypes, VectorExpression[] inputVectorExpressions, int outputColumnNum) {
        boolean isRowEndCurrent = windowFrameDef.getWindowType() == WindowingSpec.WindowType.ROWS && windowFrameDef.getEnd().isCurrentRow();
        boolean canStream = windowFrameDef.getStart().isUnbounded() && isRowEndCurrent;
        VectorExpression inputVectorExpression = inputVectorExpressions[0];
        ColumnVector.Type columnVectorType = columnVectorTypes[0];
        VectorPTFEvaluatorBase evaluator = switch (functionType.ordinal()) {
            case 0 -> new VectorPTFEvaluatorRowNumber(windowFrameDef, inputVectorExpression, outputColumnNum);
            case 1 -> new VectorPTFEvaluatorRank(windowFrameDef, outputColumnNum);
            case 2 -> new VectorPTFEvaluatorDenseRank(windowFrameDef, outputColumnNum);
            case 3 -> {
                switch (columnVectorType) {
                    case LONG: {
                        yield !canStream ? new VectorPTFEvaluatorLongMin(windowFrameDef, inputVectorExpression, outputColumnNum) : new VectorPTFEvaluatorStreamingLongMin(windowFrameDef, inputVectorExpression, outputColumnNum);
                    }
                    case DOUBLE: {
                        yield !canStream ? new VectorPTFEvaluatorDoubleMin(windowFrameDef, inputVectorExpression, outputColumnNum) : new VectorPTFEvaluatorStreamingDoubleMin(windowFrameDef, inputVectorExpression, outputColumnNum);
                    }
                    case DECIMAL: {
                        yield !canStream ? new VectorPTFEvaluatorDecimalMin(windowFrameDef, inputVectorExpression, outputColumnNum) : new VectorPTFEvaluatorStreamingDecimalMin(windowFrameDef, inputVectorExpression, outputColumnNum);
                    }
                }
                throw new RuntimeException("Unexpected column vector type " + String.valueOf(columnVectorType) + " for " + String.valueOf((Object)functionType));
            }
            case 4 -> {
                switch (columnVectorType) {
                    case LONG: {
                        yield !canStream ? new VectorPTFEvaluatorLongMax(windowFrameDef, inputVectorExpression, outputColumnNum) : new VectorPTFEvaluatorStreamingLongMax(windowFrameDef, inputVectorExpression, outputColumnNum);
                    }
                    case DOUBLE: {
                        yield !canStream ? new VectorPTFEvaluatorDoubleMax(windowFrameDef, inputVectorExpression, outputColumnNum) : new VectorPTFEvaluatorStreamingDoubleMax(windowFrameDef, inputVectorExpression, outputColumnNum);
                    }
                    case DECIMAL: {
                        yield !canStream ? new VectorPTFEvaluatorDecimalMax(windowFrameDef, inputVectorExpression, outputColumnNum) : new VectorPTFEvaluatorStreamingDecimalMax(windowFrameDef, inputVectorExpression, outputColumnNum);
                    }
                }
                throw new RuntimeException("Unexpected column vector type " + String.valueOf(columnVectorType) + " for " + String.valueOf((Object)functionType));
            }
            case 5 -> {
                switch (columnVectorType) {
                    case LONG: {
                        yield !canStream ? new VectorPTFEvaluatorLongSum(windowFrameDef, inputVectorExpression, outputColumnNum) : new VectorPTFEvaluatorStreamingLongSum(windowFrameDef, inputVectorExpression, outputColumnNum);
                    }
                    case DOUBLE: {
                        yield !canStream ? new VectorPTFEvaluatorDoubleSum(windowFrameDef, inputVectorExpression, outputColumnNum) : new VectorPTFEvaluatorStreamingDoubleSum(windowFrameDef, inputVectorExpression, outputColumnNum);
                    }
                    case DECIMAL: {
                        yield !canStream ? new VectorPTFEvaluatorDecimalSum(windowFrameDef, inputVectorExpression, outputColumnNum) : new VectorPTFEvaluatorStreamingDecimalSum(windowFrameDef, inputVectorExpression, outputColumnNum);
                    }
                }
                throw new RuntimeException("Unexpected column vector type " + String.valueOf(columnVectorType) + " for " + String.valueOf((Object)functionType));
            }
            case 6 -> {
                switch (columnVectorType) {
                    case LONG: {
                        yield !canStream ? new VectorPTFEvaluatorLongAvg(windowFrameDef, inputVectorExpression, outputColumnNum) : new VectorPTFEvaluatorStreamingLongAvg(windowFrameDef, inputVectorExpression, outputColumnNum);
                    }
                    case DOUBLE: {
                        yield !canStream ? new VectorPTFEvaluatorDoubleAvg(windowFrameDef, inputVectorExpression, outputColumnNum) : new VectorPTFEvaluatorStreamingDoubleAvg(windowFrameDef, inputVectorExpression, outputColumnNum);
                    }
                    case DECIMAL: {
                        yield !canStream ? new VectorPTFEvaluatorDecimalAvg(windowFrameDef, inputVectorExpression, outputColumnNum) : new VectorPTFEvaluatorStreamingDecimalAvg(windowFrameDef, inputVectorExpression, outputColumnNum);
                    }
                }
                throw new RuntimeException("Unexpected column vector type " + String.valueOf(columnVectorType) + " for " + String.valueOf((Object)functionType));
            }
            case 7 -> {
                switch (columnVectorType) {
                    case LONG: {
                        yield new VectorPTFEvaluatorLongFirstValue(windowFrameDef, inputVectorExpression, outputColumnNum);
                    }
                    case DOUBLE: {
                        yield new VectorPTFEvaluatorDoubleFirstValue(windowFrameDef, inputVectorExpression, outputColumnNum);
                    }
                    case DECIMAL: {
                        yield new VectorPTFEvaluatorDecimalFirstValue(windowFrameDef, inputVectorExpression, outputColumnNum);
                    }
                }
                throw new RuntimeException("Unexpected column vector type " + String.valueOf(columnVectorType) + " for " + String.valueOf((Object)functionType));
            }
            case 8 -> {
                switch (columnVectorType) {
                    case LONG: {
                        yield new VectorPTFEvaluatorLongLastValue(windowFrameDef, inputVectorExpression, outputColumnNum);
                    }
                    case DOUBLE: {
                        yield new VectorPTFEvaluatorDoubleLastValue(windowFrameDef, inputVectorExpression, outputColumnNum);
                    }
                    case DECIMAL: {
                        yield new VectorPTFEvaluatorDecimalLastValue(windowFrameDef, inputVectorExpression, outputColumnNum);
                    }
                }
                throw new RuntimeException("Unexpected column vector type " + String.valueOf(columnVectorType) + " for " + String.valueOf((Object)functionType));
            }
            case 9 -> {
                if (inputVectorExpression == null) {
                    yield new VectorPTFEvaluatorCountStar(windowFrameDef, inputVectorExpression, outputColumnNum);
                }
                if (isDistinct) {
                    switch (columnVectorType) {
                        case BYTES: {
                            yield new VectorPTFEvaluatorBytesCountDistinct(windowFrameDef, inputVectorExpression, outputColumnNum);
                        }
                        case LONG: 
                        case DECIMAL_64: {
                            yield new VectorPTFEvaluatorLongCountDistinct(windowFrameDef, inputVectorExpression, outputColumnNum);
                        }
                        case DOUBLE: {
                            yield new VectorPTFEvaluatorDoubleCountDistinct(windowFrameDef, inputVectorExpression, outputColumnNum);
                        }
                        case DECIMAL: {
                            yield new VectorPTFEvaluatorDecimalCountDistinct(windowFrameDef, inputVectorExpression, outputColumnNum);
                        }
                        case TIMESTAMP: {
                            yield new VectorPTFEvaluatorTimestampCountDistinct(windowFrameDef, inputVectorExpression, outputColumnNum);
                        }
                    }
                    throw new RuntimeException("Unexpected column type for ptf count distinct: " + String.valueOf(columnVectorType));
                }
                yield new VectorPTFEvaluatorCount(windowFrameDef, inputVectorExpression, outputColumnNum);
            }
            case 11 -> {
                int amt = inputVectorExpressions.length > 1 ? (int)((ConstantVectorExpression)inputVectorExpressions[1]).getLongValue() : 1;
                VectorExpression defaultValueExpression = inputVectorExpressions.length > 2 ? inputVectorExpressions[2] : null;
                switch (columnVectorType) {
                    case LONG: 
                    case DOUBLE: 
                    case DECIMAL: {
                        yield new VectorPTFEvaluatorLag(windowFrameDef, inputVectorExpression, outputColumnNum, columnVectorType, amt, defaultValueExpression);
                    }
                }
                throw new RuntimeException("Unexpected column vector type " + String.valueOf(columnVectorType) + " for " + String.valueOf((Object)functionType));
            }
            case 10 -> {
                int amt = inputVectorExpressions.length > 1 ? (int)((ConstantVectorExpression)inputVectorExpressions[1]).getLongValue() : 1;
                VectorExpression defaultValueExpression = inputVectorExpressions.length > 2 ? inputVectorExpressions[2] : null;
                switch (columnVectorType) {
                    case LONG: 
                    case DOUBLE: 
                    case DECIMAL: {
                        yield new VectorPTFEvaluatorLead(windowFrameDef, inputVectorExpression, outputColumnNum, columnVectorType, amt, defaultValueExpression);
                    }
                }
                throw new RuntimeException("Unexpected column vector type " + String.valueOf(columnVectorType) + " for " + String.valueOf((Object)functionType));
            }
            default -> throw new RuntimeException("Unexpected function type " + String.valueOf((Object)functionType));
        };
        evaluator.setRespectNulls(respectNulls);
        return evaluator;
    }

    public static VectorPTFEvaluatorBase[] getEvaluators(VectorPTFDesc vectorPTFDesc, VectorPTFInfo vectorPTFInfo) {
        String[] evaluatorFunctionNames = vectorPTFDesc.getEvaluatorFunctionNames();
        boolean[] evaluatorsAreDistinct = vectorPTFDesc.getEvaluatorsAreDistinct();
        boolean[] evaluatorsRespectNulls = vectorPTFDesc.getEvaluatorsRespectNulls();
        int evaluatorCount = evaluatorFunctionNames.length;
        WindowFrameDef[] evaluatorWindowFrameDefs = vectorPTFDesc.getEvaluatorWindowFrameDefs();
        VectorExpression[][] evaluatorInputExpressions = vectorPTFInfo.getEvaluatorInputExpressions();
        ColumnVector.Type[][] evaluatorInputColumnVectorTypes = vectorPTFInfo.getEvaluatorInputColumnVectorTypes();
        int[] outputColumnMap = vectorPTFInfo.getOutputColumnMap();
        VectorPTFEvaluatorBase[] evaluators = new VectorPTFEvaluatorBase[evaluatorCount];
        for (int i = 0; i < evaluatorCount; ++i) {
            VectorPTFEvaluatorBase evaluator;
            String functionName = evaluatorFunctionNames[i].toLowerCase();
            boolean isDistinct = evaluatorsAreDistinct[i];
            boolean respectNulls = evaluatorsRespectNulls[i];
            WindowFrameDef windowFrameDef = evaluatorWindowFrameDefs[i];
            SupportedFunctionType functionType = supportedFunctionsMap.get(functionName);
            VectorExpression[] inputVectorExpressions = evaluatorInputExpressions[i];
            ColumnVector.Type[] columnVectorTypes = evaluatorInputColumnVectorTypes[i];
            int outputColumnNum = outputColumnMap[i];
            evaluators[i] = evaluator = VectorPTFDesc.getEvaluator(functionType, isDistinct, respectNulls, windowFrameDef, columnVectorTypes, inputVectorExpressions, outputColumnNum);
        }
        return evaluators;
    }

    public static int[] getStreamingEvaluatorNums(VectorPTFEvaluatorBase[] evaluators) {
        int evaluatorCount = evaluators.length;
        ArrayList<Integer> streamingEvaluatorNums = new ArrayList<Integer>();
        for (int i = 0; i < evaluatorCount; ++i) {
            VectorPTFEvaluatorBase evaluator = evaluators[i];
            if (!evaluator.streamsResult()) continue;
            streamingEvaluatorNums.add(i);
        }
        return ArrayUtils.toPrimitive((Integer[])streamingEvaluatorNums.toArray(new Integer[0]));
    }

    public TypeInfo[] getReducerBatchTypeInfos() {
        return this.reducerBatchTypeInfos;
    }

    public void setReducerBatchTypeInfos(TypeInfo[] reducerBatchTypeInfos, DataTypePhysicalVariation[] reducerBatchDataTypePhysicalVariations) {
        this.reducerBatchTypeInfos = reducerBatchTypeInfos;
        this.reducerBatchDataTypePhysicalVariations = reducerBatchDataTypePhysicalVariations;
    }

    public boolean getIsPartitionOrderBy() {
        return this.isPartitionOrderBy;
    }

    public void setIsPartitionOrderBy(boolean isPartitionOrderBy) {
        this.isPartitionOrderBy = isPartitionOrderBy;
    }

    public String[] getEvaluatorFunctionNames() {
        return this.evaluatorFunctionNames;
    }

    public void setEvaluatorFunctionNames(String[] evaluatorFunctionNames) {
        this.evaluatorFunctionNames = evaluatorFunctionNames;
    }

    public void setEvaluatorsAreDistinct(boolean[] evaluatorsAreDistinct) {
        this.evaluatorsAreDistinct = evaluatorsAreDistinct;
    }

    public boolean[] getEvaluatorsAreDistinct() {
        return this.evaluatorsAreDistinct;
    }

    public boolean[] getEvaluatorsRespectNulls() {
        return this.evaluatorsRespectNulls;
    }

    public void setEvaluatorsRespectNulls(boolean[] evaluatorsRespectNulls) {
        this.evaluatorsRespectNulls = evaluatorsRespectNulls;
    }

    public WindowFrameDef[] getEvaluatorWindowFrameDefs() {
        return this.evaluatorWindowFrameDefs;
    }

    public void setEvaluatorWindowFrameDefs(WindowFrameDef[] evaluatorWindowFrameDefs) {
        this.evaluatorWindowFrameDefs = evaluatorWindowFrameDefs;
    }

    public List<ExprNodeDesc>[] getEvaluatorInputExprNodeDescLists() {
        return this.evaluatorInputExprNodeDescLists;
    }

    public void setEvaluatorInputExprNodeDescLists(List<ExprNodeDesc>[] evaluatorInputExprNodeDescLists) {
        this.evaluatorInputExprNodeDescLists = evaluatorInputExprNodeDescLists;
    }

    public ExprNodeDesc[] getOrderExprNodeDescs() {
        return this.orderExprNodeDescs;
    }

    public void setOrderExprNodeDescs(ExprNodeDesc[] orderExprNodeDescs) {
        this.orderExprNodeDescs = orderExprNodeDescs;
    }

    public ExprNodeDesc[] getPartitionExprNodeDescs() {
        return this.partitionExprNodeDescs;
    }

    public void setPartitionExprNodeDescs(ExprNodeDesc[] partitionExprNodeDescs) {
        this.partitionExprNodeDescs = partitionExprNodeDescs;
    }

    public String[] getOutputColumnNames() {
        return this.outputColumnNames;
    }

    public void setOutputColumnNames(String[] outputColumnNames) {
        this.outputColumnNames = outputColumnNames;
    }

    public TypeInfo[] getOutputTypeInfos() {
        return this.outputTypeInfos;
    }

    public DataTypePhysicalVariation[] getOutputDataTypePhysicalVariations() {
        return this.outputDataTypePhysicalVariations;
    }

    public void setOutputTypeInfos(TypeInfo[] outputTypeInfos, DataTypePhysicalVariation[] outputDataTypePhysicalVariations) {
        this.outputTypeInfos = outputTypeInfos;
        this.outputDataTypePhysicalVariations = outputDataTypePhysicalVariations;
    }

    public void setVectorPTFInfo(VectorPTFInfo vectorPTFInfo) {
        this.vectorPTFInfo = vectorPTFInfo;
    }

    public VectorPTFInfo getVectorPTFInfo() {
        return this.vectorPTFInfo;
    }

    public void setVectorizedPTFMaxMemoryBufferingBatchCount(int vectorizedPTFMaxMemoryBufferingBatchCount) {
        this.vectorizedPTFMaxMemoryBufferingBatchCount = vectorizedPTFMaxMemoryBufferingBatchCount;
    }

    public int getVectorizedPTFMaxMemoryBufferingBatchCount() {
        return this.vectorizedPTFMaxMemoryBufferingBatchCount;
    }

    static {
        for (SupportedFunctionType supportedFunctionType : SupportedFunctionType.values()) {
            supportedFunctionsMap.put(supportedFunctionType.name().toLowerCase(), supportedFunctionType);
        }
        supportedFunctionNames = new ArrayList<String>();
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.addAll(supportedFunctionsMap.keySet());
        supportedFunctionNames.addAll(treeSet);
    }

    public static enum SupportedFunctionType {
        ROW_NUMBER,
        RANK,
        DENSE_RANK,
        MIN,
        MAX,
        SUM,
        AVG,
        FIRST_VALUE,
        LAST_VALUE,
        COUNT(true),
        LEAD,
        LAG;

        private final boolean supportDistinct;

        private SupportedFunctionType() {
            this.supportDistinct = false;
        }

        private SupportedFunctionType(boolean supportDistinct) {
            this.supportDistinct = supportDistinct;
        }

        public boolean isSupportDistinct() {
            return this.supportDistinct;
        }
    }
}

