/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryProperties;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.ColumnAccessInfo;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.rewrite.Rewriter;
import org.apache.hadoop.hive.ql.parse.rewrite.RewriterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RewriteSemanticAnalyzer<T>
extends CalcitePlanner {
    protected static final Logger LOG = LoggerFactory.getLogger(RewriteSemanticAnalyzer.class);
    private final RewriterFactory<T> rewriterFactory;
    protected boolean useSuper = false;
    private ASTNode tableName;
    private Table targetTable;

    RewriteSemanticAnalyzer(QueryState queryState, RewriterFactory<T> rewriterFactory) throws SemanticException {
        super(queryState);
        this.rewriterFactory = rewriterFactory;
    }

    @Override
    public void analyzeInternal(ASTNode tree) throws SemanticException {
        if (this.useSuper) {
            super.analyzeInternal(tree);
        } else {
            this.analyze(tree);
            this.cleanUpMetaColumnAccessControl();
        }
    }

    protected abstract ASTNode getTargetTableNode(ASTNode var1);

    private void analyze(ASTNode tree) throws SemanticException {
        this.tableName = this.getTargetTableNode(tree);
        this.targetTable = RewriteSemanticAnalyzer.getTable(this.tableName, this.db, true);
        this.validateTxnManager(this.targetTable);
        this.validateTargetTable(this.targetTable);
        this.analyze(tree, this.targetTable, this.tableName);
    }

    protected abstract void analyze(ASTNode var1, Table var2, ASTNode var3) throws SemanticException;

    protected void rewriteAndAnalyze(T statementData, String subQueryAlias) throws SemanticException {
        Rewriter<T> rewriter = this.rewriterFactory.createRewriter(this.targetTable, this.getFullTableNameForSQL(this.tableName), subQueryAlias);
        ParseUtils.ReparseResult rr = rewriter.rewrite(this.ctx, statementData);
        Context rewrittenCtx = rr.rewrittenCtx;
        ASTNode rewrittenTree = rr.rewrittenTree;
        this.analyzeRewrittenTree(rewrittenTree, rewrittenCtx);
    }

    protected void analyzeRewrittenTree(ASTNode rewrittenTree, Context rewrittenCtx) throws SemanticException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Rewritten AST {}", (Object)rewrittenTree.dump());
            }
            this.useSuper = true;
            super.analyze(rewrittenTree, rewrittenCtx);
        }
        finally {
            this.useSuper = false;
        }
    }

    protected void checkValidSetClauseTarget(ASTNode colName, Table targetTable) throws SemanticException {
        String columnName = RewriteSemanticAnalyzer.normalizeColName(colName.getText());
        for (FieldSchema fschema : targetTable.getPartCols()) {
            if (!fschema.getName().equalsIgnoreCase(columnName)) continue;
            throw new SemanticException(ErrorMsg.UPDATE_CANNOT_UPDATE_PART_VALUE.getMsg());
        }
        if (targetTable.getBucketCols() != null && targetTable.getBucketCols().contains(columnName)) {
            throw new SemanticException(ErrorMsg.UPDATE_CANNOT_UPDATE_BUCKET_VALUE, new String[]{columnName});
        }
        boolean foundColumnInTargetTable = false;
        for (FieldSchema col : targetTable.getCols()) {
            if (!columnName.equalsIgnoreCase(col.getName())) continue;
            foundColumnInTargetTable = true;
            break;
        }
        if (!foundColumnInTargetTable) {
            throw new SemanticException(ErrorMsg.INVALID_TARGET_COLUMN_IN_SET_CLAUSE, new String[]{colName.getText(), targetTable.getFullyQualifiedName()});
        }
    }

    protected ASTNode findLHSofAssignment(ASTNode assignment) {
        assert (assignment.getToken().getType() == 18) : "Expected set assignments to use equals operator but found " + assignment.getName();
        ASTNode tableOrColTok = (ASTNode)assignment.getChildren().get(0);
        assert (tableOrColTok.getToken().getType() == 1276) : "Expected left side of assignment to be table or column";
        ASTNode colName = (ASTNode)tableOrColTok.getChildren().get(0);
        assert (colName.getToken().getType() == 24) : "Expected column name";
        return colName;
    }

    protected Map<String, ASTNode> collectSetColumnsAndExpressions(ASTNode setClause, Set<String> setRCols, Table targetTable) throws SemanticException {
        assert (setClause.getToken().getType() == 1205) : "Expected second child of update token to be set token";
        List assignments = setClause.getChildren();
        LinkedHashMap<String, ASTNode> setCols = new LinkedHashMap<String, ASTNode>(assignments.size());
        for (Node a : assignments) {
            ASTNode assignment = (ASTNode)a;
            ASTNode colName = this.findLHSofAssignment(assignment);
            if (setRCols != null) {
                this.addSetRCols((ASTNode)assignment.getChildren().get(1), setRCols);
            }
            this.checkValidSetClauseTarget(colName, targetTable);
            String columnName = RewriteSemanticAnalyzer.normalizeColName(colName.getText());
            setCols.put(columnName, (ASTNode)assignment.getChildren().get(1));
        }
        return setCols;
    }

    protected static Table getTable(ASTNode tabRef, Hive db, boolean throwException) throws SemanticException {
        Table mTable;
        TableName tableName = switch (tabRef.getType()) {
            case 1280 -> RewriteSemanticAnalyzer.getQualifiedTableName((ASTNode)tabRef.getChild(0));
            case 1279 -> RewriteSemanticAnalyzer.getQualifiedTableName(tabRef);
            default -> throw RewriteSemanticAnalyzer.raiseWrongType("TOK_TABREF|TOK_TABNAME", tabRef);
        };
        try {
            mTable = db.getTable(tableName.getDb(), tableName.getTable(), tableName.getTableMetaRef(), throwException);
        }
        catch (InvalidTableException e) {
            LOG.error("Failed to find table " + tableName.getNotEmptyDbTable() + " got exception " + e.getMessage());
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tableName.getNotEmptyDbTable()), (Throwable)((Object)e));
        }
        catch (HiveException e) {
            LOG.error("Failed to find table " + tableName.getNotEmptyDbTable() + " got exception " + e.getMessage());
            throw new SemanticException(e.getMessage(), (Throwable)e);
        }
        return mTable;
    }

    protected void markReadEntityForUpdate() {
        for (ReadEntity input : this.inputs) {
            if (!this.isWritten(input)) continue;
            input.setUpdateOrDelete(true);
        }
    }

    protected void setUpAccessControlInfoForUpdate(Table mTable, Map<String, ASTNode> setCols) {
        ColumnAccessInfo cai = new ColumnAccessInfo();
        for (String colName : setCols.keySet()) {
            cai.add(Table.getCompleteName(mTable.getDbName(), mTable.getTableName()), colName);
        }
        this.setUpdateColumnAccessInfo(cai);
    }

    private void cleanUpMetaColumnAccessControl() {
        if (this.columnAccessInfo != null) {
            this.columnAccessInfo.stripVirtualColumn(VirtualColumn.ROWID);
        }
    }

    private void validateTxnManager(Table mTable) throws SemanticException {
        if (!AcidUtils.acidTableWithoutTransactions(mTable) && !this.getTxnMgr().supportsAcid()) {
            throw new SemanticException(ErrorMsg.ACID_OP_ON_NONACID_TXNMGR.getMsg());
        }
    }

    protected void validateTargetTable(Table mTable) throws SemanticException {
        if (mTable.getTableType() == TableType.VIRTUAL_VIEW || mTable.getTableType() == TableType.MATERIALIZED_VIEW) {
            LOG.error("Table " + mTable.getFullyQualifiedName() + " is a view or materialized view");
            throw new SemanticException(ErrorMsg.UPDATE_DELETE_VIEW.getMsg());
        }
    }

    private boolean isWritten(Entity readEntity) {
        for (Entity writeEntity : this.outputs) {
            if (!writeEntity.toString().equalsIgnoreCase(readEntity.toString())) continue;
            return true;
        }
        return false;
    }

    private void addSetRCols(ASTNode node, Set<String> setRCols) {
        if (node.getToken().getType() == 1276) {
            ASTNode colName = (ASTNode)node.getChildren().get(0);
            if (colName.getToken().getType() == 990) {
                return;
            }
            assert (colName.getToken().getType() == 24) : "Expected column name";
            setRCols.add(RewriteSemanticAnalyzer.normalizeColName(colName.getText()));
        } else if (node.getChildren() != null) {
            for (Node n : node.getChildren()) {
                this.addSetRCols((ASTNode)n, setRCols);
            }
        }
    }

    private static String normalizeColName(String colName) {
        return colName.toLowerCase();
    }

    protected void updateOutputs(Table targetTable) {
        List<ReadEntity> partitionsRead;
        this.markReadEntityForUpdate();
        if (targetTable.isPartitioned() && !targetTable.hasNonNativePartitionSupport() && !(partitionsRead = this.getRestrictedPartitionSet(targetTable)).isEmpty()) {
            ArrayList<WriteEntity> toRemove = new ArrayList<WriteEntity>();
            for (WriteEntity we : this.outputs) {
                WriteEntity.WriteType wt = we.getWriteType();
                if (!this.isTargetTable(we, targetTable) || wt != WriteEntity.WriteType.UPDATE && wt != WriteEntity.WriteType.DELETE) continue;
                toRemove.add(we);
            }
            this.outputs.removeAll(toRemove);
            for (ReadEntity re : partitionsRead) {
                for (WriteEntity original : toRemove) {
                    WriteEntity we = new WriteEntity(re.getPartition(), original.getWriteType());
                    we.setDynamicPartitionWrite(original.isDynamicPartitionWrite());
                    this.outputs.add(we);
                }
            }
        }
    }

    private List<ReadEntity> getRestrictedPartitionSet(Table targetTable) {
        ArrayList<ReadEntity> partitionsRead = new ArrayList<ReadEntity>();
        for (ReadEntity re : this.inputs) {
            if (!re.isFromTopLevelQuery || re.getType() != Entity.Type.PARTITION || !this.isTargetTable(re, targetTable)) continue;
            partitionsRead.add(re);
        }
        return partitionsRead;
    }

    private boolean isTargetTable(Entity entity, Table targetTable) {
        return targetTable.equalsWithIgnoreWriteId(entity.getTable());
    }

    @Override
    public void setQueryType(ASTNode tree) {
        this.queryProperties.setQueryType(QueryProperties.QueryType.DML);
    }
}

