/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.unionproc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.optimizer.unionproc.UnionProcContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.UnionDesc;

public final class UnionProcFactory {
    private UnionProcFactory() {
    }

    public static int getPositionParent(UnionOperator union, Stack<Node> stack) {
        int pos = 0;
        int size = stack.size();
        assert (size >= 2 && stack.get(size - 1) == union);
        Operator parent = (Operator)stack.get(size - 2);
        List<Operator<OperatorDesc>> parUnion = union.getParentOperators();
        pos = parUnion.indexOf(parent);
        assert (pos < parUnion.size());
        return pos;
    }

    public static SemanticNodeProcessor getMapRedUnion() {
        return new MapRedUnion();
    }

    public static SemanticNodeProcessor getMapUnion() {
        return new MapUnion();
    }

    public static SemanticNodeProcessor getUnknownUnion() {
        return new UnknownUnion();
    }

    public static SemanticNodeProcessor getNoUnion() {
        return new NoUnion();
    }

    public static SemanticNodeProcessor getUnionNoProcessFile() {
        return new UnionNoProcessFile();
    }

    public static class MapRedUnion
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            UnionOperator union = (UnionOperator)nd;
            UnionProcContext ctx = (UnionProcContext)procCtx;
            int pos = UnionProcFactory.getPositionParent(union, stack);
            UnionProcContext.UnionParseContext uCtx = ctx.getUnionParseContext(union);
            if (uCtx == null) {
                uCtx = new UnionProcContext.UnionParseContext(((UnionDesc)union.getConf()).getNumInputs());
            }
            ctx.setMapOnlySubq(false);
            uCtx.setMapOnlySubq(pos, false);
            uCtx.setRootTask(pos, false);
            ctx.setUnionParseContext(union, uCtx);
            return null;
        }
    }

    public static class MapUnion
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            UnionOperator union = (UnionOperator)nd;
            UnionProcContext ctx = (UnionProcContext)procCtx;
            int pos = UnionProcFactory.getPositionParent(union, stack);
            UnionProcContext.UnionParseContext uCtx = ctx.getUnionParseContext(union);
            if (uCtx == null) {
                uCtx = new UnionProcContext.UnionParseContext(((UnionDesc)union.getConf()).getNumInputs());
            }
            uCtx.setMapOnlySubq(pos, true);
            uCtx.setRootTask(pos, true);
            ctx.setUnionParseContext(union, uCtx);
            return null;
        }
    }

    public static class UnknownUnion
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            UnionOperator union = (UnionOperator)nd;
            UnionProcContext ctx = (UnionProcContext)procCtx;
            int pos = UnionProcFactory.getPositionParent(union, stack);
            UnionProcContext.UnionParseContext uCtx = ctx.getUnionParseContext(union);
            if (uCtx == null) {
                uCtx = new UnionProcContext.UnionParseContext(((UnionDesc)union.getConf()).getNumInputs());
            }
            UnionOperator parentUnionOperator = null;
            for (int start = stack.size() - 2; start >= 0; --start) {
                Operator parent = (Operator)stack.get(start);
                if (!(parent instanceof UnionOperator)) continue;
                parentUnionOperator = (UnionOperator)parent;
                break;
            }
            assert (parentUnionOperator != null);
            boolean mapOnly = false;
            boolean rootTask = false;
            UnionProcContext.UnionParseContext parentUCtx = ctx.getUnionParseContext(parentUnionOperator);
            if (parentUCtx != null && parentUCtx.allMapOnlySubQSet()) {
                mapOnly = parentUCtx.allMapOnlySubQ();
                rootTask = parentUCtx.allRootTasks();
            }
            uCtx.setMapOnlySubq(pos, mapOnly);
            uCtx.setRootTask(pos, rootTask);
            ctx.setUnionParseContext(union, uCtx);
            return null;
        }
    }

    public static class NoUnion
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            return null;
        }
    }

    public static class UnionNoProcessFile
    implements SemanticNodeProcessor {
        private void pushOperatorsAboveUnion(UnionOperator union, Stack<Node> stack, int pos) throws SemanticException {
            try {
                List<Operator<OperatorDesc>> parents = union.getParentOperators();
                int numParents = parents.size();
                for (Operator<OperatorDesc> parent : parents) {
                    parent.setChildOperators(null);
                }
                while (pos < stack.size() - 1) {
                    Operator originalOp = (Operator)stack.get(pos);
                    for (int p = 0; p < numParents; ++p) {
                        OperatorDesc cloneDesc = (OperatorDesc)originalOp.getConf().clone();
                        RowSchema origSchema = originalOp.getSchema();
                        Map<String, ExprNodeDesc> origColExprMap = originalOp.getColumnExprMap();
                        Operator<OperatorDesc> cloneOp = OperatorFactory.getAndMakeChild(cloneDesc, origSchema == null ? null : new RowSchema(origSchema), origColExprMap == null ? null : new HashMap<String, ExprNodeDesc>(origColExprMap), parents.get(p), new Operator[0]);
                        parents.set(p, cloneOp);
                    }
                    ++pos;
                }
                FileSinkOperator fileSinkOp = (FileSinkOperator)stack.get(pos);
                Path parentDirName = ((FileSinkDesc)fileSinkOp.getConf()).getDirName();
                ArrayList<FileSinkDesc> fileDescLists = new ArrayList<FileSinkDesc>();
                for (Operator<OperatorDesc> parent : parents) {
                    FileSinkDesc fileSinkDesc = (FileSinkDesc)((FileSinkDesc)fileSinkOp.getConf()).clone();
                    fileSinkDesc.setDirName(new Path(parentDirName, "HIVE_UNION_SUBDIR_" + parent.getIdentifier()));
                    fileSinkDesc.setLinkedFileSink(true);
                    if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                        Utilities.FILE_OP_LOGGER.trace("Created LinkedFileSink for union " + String.valueOf(fileSinkDesc.getDirName()) + "; parent " + String.valueOf(parentDirName));
                    }
                    parent.setChildOperators(null);
                    Operator<FileSinkDesc> tmpFileSinkOp = OperatorFactory.getAndMakeChild(fileSinkDesc, parent.getSchema(), parent, new Operator[0]);
                    tmpFileSinkOp.setChildOperators(null);
                    fileDescLists.add(fileSinkDesc);
                }
                for (FileSinkDesc fileDesc : fileDescLists) {
                    fileDesc.setLinkedFileSinkDesc(fileDescLists);
                }
                union.setChildOperators(null);
                union.setParentOperators(null);
            }
            catch (Exception e) {
                throw new SemanticException(e.getMessage());
            }
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            UnionProcContext ctx;
            UnionProcContext.UnionParseContext uCtx;
            int pos;
            FileSinkOperator fileSinkOp = (FileSinkOperator)nd;
            if (((FileSinkDesc)fileSinkOp.getConf()).isLinkedFileSink()) {
                return null;
            }
            int size = stack.size();
            UnionOperator union = null;
            for (pos = size - 2; pos >= 0; --pos) {
                Operator operator = (Operator)stack.get(pos);
                if (operator.getChildOperators() != null && operator.getChildOperators().size() > 1) {
                    return null;
                }
                if (operator instanceof UnionOperator) {
                    union = (UnionOperator)operator;
                    break;
                }
                if (operator.supportUnionRemoveOptimization()) continue;
                return null;
            }
            if ((uCtx = (ctx = (UnionProcContext)procCtx).getUnionParseContext(union)) != null && uCtx.allMapOnlySubQ()) {
                return null;
            }
            this.pushOperatorsAboveUnion(union, stack, ++pos);
            return null;
        }
    }
}

