/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.stats.annotation;

import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.Statistics;

public class AnnotateStatsProcCtx
implements NodeProcessorCtx {
    private ParseContext pctx;
    private HiveConf conf;
    private boolean uniformWithinRange;
    private Statistics andExprStats;
    private Set<String> affectedColumns;

    public AnnotateStatsProcCtx(ParseContext pctx) {
        this.pctx = pctx;
        if (pctx != null) {
            this.conf = pctx.getConf();
            this.uniformWithinRange = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_RANGE_SELECTIVITY_UNIFORM_DISTRIBUTION);
        } else {
            this.conf = null;
            this.uniformWithinRange = false;
        }
        this.andExprStats = null;
        this.affectedColumns = new HashSet<String>();
    }

    public HiveConf getConf() {
        return this.conf;
    }

    public boolean isUniformWithinRange() {
        return this.uniformWithinRange;
    }

    public ParseContext getParseContext() {
        return this.pctx;
    }

    public Statistics getAndExprStats() {
        return this.andExprStats;
    }

    public void setAndExprStats(Statistics andExprStats) {
        this.andExprStats = andExprStats;
    }

    public void clearAffectedColumns() {
        this.affectedColumns.clear();
    }

    public void addAffectedColumn(ExprNodeColumnDesc column) {
        this.affectedColumns.add(column.getColumn());
    }

    public void addAffectedColumns(Set<String> columns) {
        this.affectedColumns.addAll(columns);
    }

    public Set<String> getAffectedColumns() {
        return this.affectedColumns;
    }
}

