/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalPlanResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class StageIDsRearranger
implements PhysicalPlanResolver {
    private static final String PREFIX = "Stage-";

    @Override
    public PhysicalContext resolve(PhysicalContext pctx) throws SemanticException {
        int counter = 0;
        for (Task task : StageIDsRearranger.getExplainOrder(pctx)) {
            task.setId(PREFIX + ++counter);
        }
        return pctx;
    }

    private static List<Task> getExplainOrder(PhysicalContext pctx) {
        List<Task> tasks = StageIDsRearranger.getExplainOrder(pctx.getRootTasks(), pctx.getConf().getVar(HiveConf.ConfVars.HIVE_STAGE_ID_REARRANGE));
        if (pctx.getFetchTask() != null) {
            tasks.add(pctx.getFetchTask());
        }
        return tasks;
    }

    public static List<Task> getFetchSources(List<Task<?>> tasks) {
        final ArrayList<Task> sources = new ArrayList<Task>();
        TaskTraverse traverse = new TaskTraverse(){

            @Override
            protected void accepted(Task<?> task) {
                if (task.getNumChild() == 0 && task.isFetchSource()) {
                    sources.add(task);
                }
            }
        };
        for (Task<?> task : tasks) {
            traverse.traverse(task);
        }
        return sources;
    }

    public static List<Task> getExplainOrder(List<Task<?>> tasks, String stageIdRearrange) {
        for (Task<?> task : tasks) {
            task.setRootTask(true);
        }
        ArrangeType type = ArrangeType.valueOf(stageIdRearrange.toUpperCase());
        if (type == ArrangeType.EXECUTION) {
            return StageIDsRearranger.executionOrder(tasks);
        }
        return StageIDsRearranger.traverseOrder(type, tasks);
    }

    private static List<Task> executionOrder(List<Task<?>> tasks) {
        final ConcurrentLinkedQueue queue = new ConcurrentLinkedQueue(tasks);
        TaskTraverse traverse = new TaskTraverse(){

            @Override
            protected void accepted(Task<?> task) {
                List<Task<?>> childTasks = this.getChildTasks(task);
                if (childTasks != null && !childTasks.isEmpty()) {
                    queue.addAll(childTasks);
                }
            }

            @Override
            protected void rejected(Task<?> child) {
                queue.add(child);
            }

            @Override
            protected List<Task<?>> next(Task<?> task) {
                return queue.isEmpty() ? null : Arrays.asList((Task)queue.remove());
            }
        };
        if (!queue.isEmpty()) {
            traverse.traverse((Task)queue.remove());
        }
        return new ArrayList<Task>(traverse.traversed);
    }

    static List<Task> traverseOrder(final ArrangeType type, List<Task<?>> tasks) {
        TaskTraverse traverse = new TaskTraverse(){

            @Override
            protected boolean isReady(Task<?> task) {
                return type == ArrangeType.NONE || type == ArrangeType.IDONLY || super.isReady(task);
            }
        };
        for (Task<?> task : tasks) {
            traverse.traverse(task);
        }
        return new ArrayList<Task>(traverse.traversed);
    }

    public static abstract class TaskTraverse {
        protected final Set<Task<?>> traversed = new LinkedHashSet();

        public void traverse(Task<?> task) {
            List<Task<?>> children;
            if (this.traversed.add(task)) {
                this.accepted(task);
            }
            if ((children = this.next(task)) != null && !children.isEmpty()) {
                for (Task<?> child : children) {
                    if (this.isReady(child)) {
                        this.traverse(child);
                        continue;
                    }
                    this.rejected(child);
                }
            }
        }

        protected boolean isReady(Task<?> task) {
            return task.getParentTasks() == null || this.traversed.containsAll(task.getParentTasks());
        }

        protected void accepted(Task<?> task) {
        }

        protected void rejected(Task<?> child) {
        }

        protected List<Task<?>> next(Task<?> task) {
            return this.getChildTasks(task);
        }

        protected List<Task<?>> getChildTasks(Task<?> task) {
            if (task instanceof ConditionalTask) {
                return ((ConditionalTask)task).getListTasks();
            }
            return task.getChildTasks();
        }
    }

    static enum ArrangeType {
        NONE,
        IDONLY,
        TRAVERSE,
        EXECUTION;

    }
}

