/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.graph;

import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hive.ql.optimizer.graph.DiGraph;

class DagGraph<V, E>
extends DiGraph<V, E> {
    DagGraph() {
    }

    @Override
    protected DiGraph.Node<V, E> newNode(V s) {
        return new DagNode(s);
    }

    public int getDepth(V o1) {
        HashSet active = new HashSet();
        active.add(this.nodeOf(o1));
        int depth = 0;
        while (!active.isEmpty()) {
            HashSet newActive = new HashSet();
            for (DiGraph.Node node : active) {
                Set p = this.successors(node.v);
                for (Object n : p) {
                    newActive.add(this.nodeOf(n));
                }
            }
            ++depth;
            active = newActive;
        }
        return depth;
    }

    static class DagNode<V, E>
    extends DiGraph.Node<V, E> {
        int dagIdx = 0;

        public DagNode(V v) {
            super(v);
        }

        @Override
        public void addEdge(DiGraph.Edge<V, E> edge) {
            if (edge.s == this) {
                DagNode t = (DagNode)edge.t;
                this.ensureDagIdxAtLeast(t.dagIdx + 1);
                if (t.dagIdx > this.dagIdx) {
                    throw new IllegalArgumentException("adding this edge would violate dag properties");
                }
            }
            super.addEdge(edge);
        }

        void ensureDagIdxAtLeast(int min) {
            if (this.dagIdx >= min) {
                return;
            }
            this.dagIdx = min;
            for (DiGraph.Edge e : this.edges) {
                if (e.t != this) continue;
                DagNode s = (DagNode)e.s;
                s.ensureDagIdxAtLeast(min + 1);
            }
        }
    }
}

