/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.util.Pair;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.ExprNodeConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer.HiveOpConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer.HiveOpConverterUtils;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer.HiveRelNodeVisitor;
import org.apache.hadoop.hive.ql.parse.PTFInvocationSpec;
import org.apache.hadoop.hive.ql.parse.PTFTranslator;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.WindowingComponentizer;
import org.apache.hadoop.hive.ql.parse.WindowingSpec;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.PTFDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;

class HiveProjectVisitor
extends HiveRelNodeVisitor<HiveProject> {
    HiveProjectVisitor(HiveOpConverter hiveOpConverter) {
        super(hiveOpConverter);
    }

    @Override
    HiveOpConverter.OpAttr visit(HiveProject projectRel) throws SemanticException {
        HiveOpConverter.OpAttr inputOpAf = this.hiveOpConverter.dispatch(projectRel.getInput());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Translating operator rel#" + projectRel.getId() + ":" + projectRel.getRelTypeName() + " with row type: [" + String.valueOf(projectRel.getRowType()) + "]");
        }
        WindowingSpec windowingSpec = new WindowingSpec();
        ArrayList<String> exprNames = new ArrayList<String>(projectRel.getRowType().getFieldNames());
        ArrayList<ExprNodeDesc> exprCols = new ArrayList<ExprNodeDesc>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        for (int pos = 0; pos < projectRel.getProjects().size(); ++pos) {
            ExprNodeConverter converter = new ExprNodeConverter(inputOpAf.tabAlias, (String)projectRel.getRowType().getFieldNames().get(pos), projectRel.getInput().getRowType(), projectRel.getRowType(), (Set<Integer>)inputOpAf.vcolsInCalcite, projectRel.getCluster().getTypeFactory(), true);
            ExprNodeDesc exprCol = (ExprNodeDesc)((RexNode)projectRel.getProjects().get(pos)).accept((RexVisitor)converter);
            colExprMap.put((String)exprNames.get(pos), exprCol);
            exprCols.add(exprCol);
            if (converter.getWindowFunctionSpec() == null) continue;
            for (WindowingSpec.WindowFunctionSpec wfs : converter.getWindowFunctionSpec()) {
                windowingSpec.addWindowFunction(wfs);
            }
        }
        if (windowingSpec.getWindowExpressions() != null && !windowingSpec.getWindowExpressions().isEmpty()) {
            inputOpAf = this.genPTF(inputOpAf, windowingSpec);
        }
        SelectDesc sd = new SelectDesc(exprCols, exprNames);
        Pair<ArrayList<ColumnInfo>, Set<Integer>> colInfoVColPair = this.createColInfos(projectRel.getProjects(), exprCols, exprNames, inputOpAf);
        SelectOperator selOp = (SelectOperator)OperatorFactory.getAndMakeChild(sd, new RowSchema((List)colInfoVColPair.getKey()), (Operator)inputOpAf.inputs.get(0), new Operator[0]);
        selOp.setColumnExprMap(colExprMap);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Generated " + String.valueOf(selOp) + " with row schema: [" + String.valueOf(selOp.getSchema()) + "]");
        }
        return new HiveOpConverter.OpAttr(inputOpAf.tabAlias, (Set)colInfoVColPair.getValue(), selOp);
    }

    private HiveOpConverter.OpAttr genPTF(HiveOpConverter.OpAttr inputOpAf, WindowingSpec wSpec) throws SemanticException {
        Operator<PTFDesc> input = (Operator<PTFDesc>)inputOpAf.inputs.get(0);
        wSpec.validateAndMakeEffective();
        WindowingComponentizer groups = new WindowingComponentizer(wSpec);
        RowResolver rr = new RowResolver();
        for (ColumnInfo ci : input.getSchema().getSignature()) {
            rr.put(inputOpAf.tabAlias, ci.getInternalName(), ci);
        }
        while (groups.hasNext()) {
            wSpec = groups.next(this.hiveOpConverter.getHiveConf(), this.hiveOpConverter.getSemanticAnalyzer(), this.hiveOpConverter.getUnparseTranslator(), rr);
            ArrayList<ExprNodeDesc> keyCols = new ArrayList<ExprNodeDesc>();
            ArrayList<ExprNodeDesc> partCols = new ArrayList<ExprNodeDesc>();
            StringBuilder order = new StringBuilder();
            StringBuilder nullOrder = new StringBuilder();
            for (PTFInvocationSpec.PartitionExpression partCol : wSpec.getQueryPartitionSpec().getExpressions()) {
                ExprNodeDesc partExpr = this.hiveOpConverter.getSemanticAnalyzer().genExprNodeDesc(partCol.getExpression(), rr);
                if (ExprNodeDescUtils.indexOf(partExpr, partCols) >= 0) continue;
                keyCols.add(partExpr);
                partCols.add(partExpr);
                order.append('+');
                nullOrder.append('a');
            }
            if (wSpec.getQueryOrderSpec() != null) {
                for (PTFInvocationSpec.OrderExpression orderCol : wSpec.getQueryOrderSpec().getExpressions()) {
                    ExprNodeDesc orderExpr = this.hiveOpConverter.getSemanticAnalyzer().genExprNodeDesc(orderCol.getExpression(), rr);
                    char orderChar = orderCol.getOrder() == PTFInvocationSpec.Order.ASC ? (char)'+' : '-';
                    char nullOrderChar = orderCol.getNullOrder() == PTFInvocationSpec.NullOrder.NULLS_FIRST ? (char)'a' : 'z';
                    int index = ExprNodeDescUtils.indexOf(orderExpr, keyCols);
                    if (index >= 0) {
                        order.setCharAt(index, orderChar);
                        nullOrder.setCharAt(index, nullOrderChar);
                        continue;
                    }
                    keyCols.add(orderExpr);
                    order.append(orderChar);
                    nullOrder.append(nullOrderChar);
                }
            }
            SelectOperator selectOp = HiveProjectVisitor.genReduceSinkAndBacktrackSelect(input, keyCols.toArray(new ExprNodeDesc[keyCols.size()]), 0, partCols, order.toString(), nullOrder.toString(), -1, AcidUtils.Operation.NOT_ACID, this.hiveOpConverter.getHiveConf());
            PTFTranslator translator = new PTFTranslator();
            PTFDesc ptfDesc = translator.translate(wSpec, this.hiveOpConverter.getSemanticAnalyzer(), this.hiveOpConverter.getHiveConf(), rr, this.hiveOpConverter.getUnparseTranslator());
            RowResolver ptfOpRR = ptfDesc.getFuncDef().getOutputShape().getRr();
            Operator<PTFDesc> ptfOp = OperatorFactory.getAndMakeChild(ptfDesc, new RowSchema(ptfOpRR.getColumnInfos()), (Operator)selectOp, new Operator[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Generated " + String.valueOf(ptfOp) + " with row schema: [" + String.valueOf(ptfOp.getSchema()) + "]");
            }
            rr = ptfOpRR;
            input = ptfOp;
        }
        return inputOpAf.clone(input);
    }

    private static SelectOperator genReduceSinkAndBacktrackSelect(Operator<?> input, ExprNodeDesc[] keys, int tag, ArrayList<ExprNodeDesc> partitionCols, String order, String nullOrder, int numReducers, AcidUtils.Operation acidOperation, HiveConf hiveConf) throws SemanticException {
        return HiveOpConverterUtils.genReduceSinkAndBacktrackSelect(input, keys, tag, partitionCols, order, nullOrder, numReducers, acidOperation, hiveConf, input.getSchema().getColumnNames());
    }

    private Pair<ArrayList<ColumnInfo>, Set<Integer>> createColInfos(List<RexNode> calciteExprs, List<ExprNodeDesc> hiveExprs, List<String> projNames, HiveOpConverter.OpAttr inpOpAf) {
        if (hiveExprs.size() != projNames.size()) {
            throw new RuntimeException("Column expressions list doesn't match Column Names list");
        }
        ArrayList<ColumnInfo> colInfos = new ArrayList<ColumnInfo>();
        HashSet<Integer> newVColSet = new HashSet<Integer>();
        for (int i = 0; i < hiveExprs.size(); ++i) {
            ExprNodeDesc pe = hiveExprs.get(i);
            RexNode rexN = calciteExprs.get(i);
            boolean vc = false;
            if (rexN instanceof RexInputRef && inpOpAf.vcolsInCalcite.contains((Object)((RexInputRef)rexN).getIndex())) {
                newVColSet.add(i);
                vc = true;
            }
            colInfos.add(new ColumnInfo(projNames.get(i), pe.getTypeInfo(), inpOpAf.tabAlias, vc));
        }
        return new Pair(colInfos, newVColSet);
    }
}

