/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules.views;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveHepExtractRelNodeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveAggregateIncrementalRewritingRuleBase;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveRowIsDeletedPropagator;

public class HiveAggregateInsertDeleteIncrementalRewritingRule
extends HiveAggregateIncrementalRewritingRuleBase<IncrementalComputePlanWithDeletedRows> {
    public static final HiveAggregateInsertDeleteIncrementalRewritingRule INSTANCE = new HiveAggregateInsertDeleteIncrementalRewritingRule();

    private HiveAggregateInsertDeleteIncrementalRewritingRule() {
        super(HiveAggregateInsertDeleteIncrementalRewritingRule.operand(Aggregate.class, (RelOptRuleOperand)HiveAggregateInsertDeleteIncrementalRewritingRule.operand(Union.class, (RelOptRuleOperand)HiveAggregateInsertDeleteIncrementalRewritingRule.operand(Aggregate.class, (RelOptRuleOperandChildren)HiveAggregateInsertDeleteIncrementalRewritingRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), HiveRelFactories.HIVE_BUILDER, "HiveAggregateInsertDeleteIncrementalRewritingRule", 2);
    }

    @Override
    protected IncrementalComputePlanWithDeletedRows createJoinRightInput(RelOptRuleCall call) {
        RelBuilder relBuilder = call.builder();
        Aggregate aggregate = (Aggregate)call.rel(2);
        RexBuilder rexBuilder = relBuilder.getRexBuilder();
        RelNode aggInput = aggregate.getInput();
        aggInput = HiveHepExtractRelNodeRule.execute(aggInput);
        aggInput = new HiveRowIsDeletedPropagator(relBuilder).propagate(aggInput);
        int rowIsDeletedIdx = aggInput.getRowType().getFieldCount() - 2;
        RexInputRef rowIsDeletedNode = rexBuilder.makeInputRef(((RelDataTypeField)aggInput.getRowType().getFieldList().get(rowIsDeletedIdx)).getType(), rowIsDeletedIdx);
        int countIdx = -1;
        ArrayList<RelBuilder.AggCall> newAggregateCalls = new ArrayList<RelBuilder.AggCall>(aggregate.getAggCallList().size());
        for (int i = 0; i < aggregate.getAggCallList().size(); ++i) {
            SqlAggFunction aggFunction;
            AggregateCall aggregateCall = (AggregateCall)aggregate.getAggCallList().get(i);
            if (aggregateCall.getAggregation().getKind() == SqlKind.COUNT && aggregateCall.getArgList().isEmpty()) {
                countIdx = i + aggregate.getGroupCount();
            }
            RexLiteral argument = switch (aggregateCall.getAggregation().getKind()) {
                case SqlKind.COUNT -> {
                    aggFunction = SqlStdOperatorTable.SUM;
                    if (aggregateCall.getArgList().isEmpty()) {
                        yield relBuilder.literal((Object)1);
                    }
                    yield this.genArgumentForCountColumn(relBuilder, aggInput, (Integer)aggregateCall.getArgList().get(0));
                }
                case SqlKind.SUM -> {
                    aggFunction = SqlStdOperatorTable.SUM;
                    Integer argumentIdx = (Integer)aggregateCall.getArgList().get(0);
                    yield rexBuilder.makeInputRef(((RelDataTypeField)aggInput.getRowType().getFieldList().get(argumentIdx)).getType(), argumentIdx.intValue());
                }
                default -> throw new AssertionError((Object)("Found an aggregation that could not be recognized: " + String.valueOf(aggregateCall)));
            };
            RexNode minus = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, new RexNode[]{relBuilder.literal((Object)-1), argument});
            RexNode newArgument = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, new RexNode[]{rowIsDeletedNode, minus, argument});
            newAggregateCalls.add(relBuilder.aggregateCall(aggFunction, new RexNode[]{newArgument}));
        }
        if (countIdx == -1) {
            return null;
        }
        return new IncrementalComputePlanWithDeletedRows(relBuilder.push(aggInput).aggregate(relBuilder.groupKey(aggregate.getGroupSet()), newAggregateCalls).build(), countIdx);
    }

    private RexNode genArgumentForCountColumn(RelBuilder relBuilder, RelNode aggInput, int argumentIdx) {
        RexBuilder rexBuilder = relBuilder.getRexBuilder();
        RexInputRef countArg = rexBuilder.makeInputRef(((RelDataTypeField)aggInput.getRowType().getFieldList().get(argumentIdx)).getType(), argumentIdx);
        RexNode isNull = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{countArg});
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, new RexNode[]{isNull, relBuilder.literal((Object)0), relBuilder.literal((Object)1)});
    }

    @Override
    protected RexNode createFilterCondition(IncrementalComputePlanWithDeletedRows incrementalComputePlan, RexNode flagNode, List<RexNode> projExprs, RelBuilder relBuilder) {
        RexBuilder rexBuilder = relBuilder.getRexBuilder();
        RexNode countStarCase = projExprs.get(incrementalComputePlan.countStarIndex);
        RexNode countStarGT0 = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{countStarCase, relBuilder.literal((Object)0)});
        RexNode countStarEq0 = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{countStarCase, relBuilder.literal((Object)0)});
        RexNode insert = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{flagNode}), countStarGT0});
        RexNode update = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{flagNode, countStarGT0});
        RexNode delete = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{flagNode, countStarEq0});
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{insert, update, delete});
    }

    static class IncrementalComputePlanWithDeletedRows
    extends HiveAggregateIncrementalRewritingRuleBase.IncrementalComputePlan {
        private final int countStarIndex;

        public IncrementalComputePlanWithDeletedRows(RelNode rightInput, int countStarIndex) {
            super(rightInput);
            this.countStarIndex = countStarIndex;
        }
    }
}

