/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.ImmutableList;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.calcite.util.ReflectUtil;
import org.apache.calcite.util.ReflectiveVisitor;

public class HiveReflectUtil {
    protected static <T, E> MethodDispatcherWrapper<T, E> createCalciteMethodDispatcherWrapper(ReflectUtil.MethodDispatcher<T> methodDispatcher) {
        return new MethodDispatcherWrapper(methodDispatcher);
    }

    protected static <E, T> HiveMethodDispatcher<T, E> createMethodDispatcher(Class<T> returnClazz, ReflectiveVisitor visitor, String methodName, Class<E> arg0Clazz, Class ... otherArgClasses) {
        ImmutableList otherArgClassList = ImmutableList.copyOf((Object[])otherArgClasses);
        VisitDispatcher dispatcher = HiveReflectUtil.createDispatcher(visitor.getClass(), arg0Clazz);
        return new HiveMethodDispatcher<T, E>(dispatcher, returnClazz, visitor, methodName, arg0Clazz, (List<Class>)otherArgClassList);
    }

    private static <R extends ReflectiveVisitor, E> VisitDispatcher<R, E> createDispatcher(Class<R> visitorBaseClazz, Class<E> visiteeBaseClazz) {
        assert (ReflectiveVisitor.class.isAssignableFrom(visitorBaseClazz));
        assert (Object.class.isAssignableFrom(visiteeBaseClazz));
        return new VisitDispatcher();
    }

    private static Class<? extends VarArgsFunc> getVarArgsFuncClass(int length) {
        switch (length) {
            case 1: {
                return VarArgsFunc1.class;
            }
            case 2: {
                return VarArgsFunc2.class;
            }
            case 3: {
                return VarArgsFunc3.class;
            }
            case 4: {
                return VarArgsFunc4.class;
            }
        }
        throw new RuntimeException("Unsupported function with length " + length);
    }

    private static VarArgsFunc getVarArgsFunc(int length, CallSite site) throws Throwable {
        switch (length) {
            case 1: {
                return site.getTarget().invokeExact();
            }
            case 2: {
                return site.getTarget().invokeExact();
            }
            case 3: {
                return site.getTarget().invokeExact();
            }
            case 4: {
                return site.getTarget().invokeExact();
            }
        }
        throw new RuntimeException("Unsupported function with length " + length);
    }

    private static class MethodDispatcherWrapper<T, E>
    implements ClassMethodDispatcher<T, E> {
        private final ReflectUtil.MethodDispatcher<T> methodDispatcher;

        public MethodDispatcherWrapper(ReflectUtil.MethodDispatcher<T> methodDispatcher) {
            this.methodDispatcher = methodDispatcher;
        }

        public T invoke(Object ... args) {
            return (T)this.methodDispatcher.invoke(args);
        }
    }

    protected static class VisitDispatcher<R extends ReflectiveVisitor, E> {
        final Map<List<Object>, VarArgsFunc> map = new ConcurrentHashMap<List<Object>, VarArgsFunc>();

        protected VisitDispatcher() {
        }

        public VarArgsFunc lookupVisitFunc(Class<? extends R> visitorClass, Class<? extends E> visiteeClass, String visitMethodName, List<Class> additionalParameterTypes) throws Throwable {
            ImmutableList key = ImmutableList.of(visitorClass, visiteeClass, (Object)visitMethodName, additionalParameterTypes);
            VarArgsFunc method = this.map.get(key);
            if (method == null && !this.map.containsKey(key)) {
                Method method1 = ReflectUtil.lookupVisitMethod(visitorClass, visiteeClass, (String)visitMethodName, additionalParameterTypes);
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                MethodHandle methodHandle = lookup.unreflect(method1);
                int argsLength = 1 + method1.getParameterTypes().length;
                MethodType invokedType = MethodType.methodType(HiveReflectUtil.getVarArgsFuncClass(argsLength));
                MethodType functionMethodType = MethodType.methodType(method1.getReturnType(), visitorClass, method1.getParameterTypes());
                CallSite site = LambdaMetafactory.metafactory(lookup, "apply", invokedType, functionMethodType.generic(), methodHandle, methodHandle.type());
                method = HiveReflectUtil.getVarArgsFunc(argsLength, site);
                this.map.put((List<Object>)key, method);
            }
            return method;
        }
    }

    protected static class HiveMethodDispatcher<T, E>
    implements ClassMethodDispatcher<T, E> {
        private final VisitDispatcher<ReflectiveVisitor, E> dispatcher;
        private final Class<T> returnClazz;
        private final ReflectiveVisitor visitor;
        private final String methodName;
        private final Class<E> arg0Clazz;
        private final List<Class> otherArgClassList;

        public HiveMethodDispatcher(VisitDispatcher<ReflectiveVisitor, E> dispatcher, Class<T> returnClazz, ReflectiveVisitor visitor, String methodName, Class<E> arg0Clazz, List<Class> otherArgClassList) {
            this.dispatcher = dispatcher;
            this.returnClazz = returnClazz;
            this.visitor = visitor;
            this.methodName = methodName;
            this.arg0Clazz = arg0Clazz;
            this.otherArgClassList = otherArgClassList;
        }

        public T invoke(Object ... args) {
            VarArgsFunc method = null;
            try {
                method = this.lookupVisitFunc(args[0]);
                Object o = method.apply(this.visitor, args[0], args[1], args[2]);
                return this.returnClazz.cast(o);
            }
            catch (Throwable e) {
                throw new RuntimeException("While invoking method " + (String)(method != null ? "'" + String.valueOf(method) + "'" : ""), e);
            }
        }

        private VarArgsFunc lookupVisitFunc(Object arg0) throws Throwable {
            if (!this.arg0Clazz.isInstance(arg0)) {
                throw new IllegalArgumentException();
            }
            VarArgsFunc method = this.dispatcher.lookupVisitFunc(this.visitor.getClass(), arg0.getClass(), this.methodName, this.otherArgClassList);
            if (method == null) {
                ArrayList<Class> classList = new ArrayList<Class>();
                classList.add(this.arg0Clazz);
                classList.addAll(this.otherArgClassList);
                throw new IllegalArgumentException("Method not found: " + this.methodName + "(" + String.valueOf(classList) + ")");
            }
            return method;
        }

        @Override
        public void register(Iterable<Class<? extends E>> classes) throws Throwable {
            for (Class<E> clazz : classes) {
                VarArgsFunc method = this.dispatcher.lookupVisitFunc(this.visitor.getClass(), clazz, this.methodName, this.otherArgClassList);
                if (method != null) continue;
                ArrayList<Class> classList = new ArrayList<Class>();
                classList.add(this.arg0Clazz);
                classList.addAll(this.otherArgClassList);
                throw new IllegalArgumentException("Method not found: " + this.methodName + "(" + String.valueOf(classList) + ")");
            }
        }
    }

    @FunctionalInterface
    private static interface VarArgsFunc1<T, R>
    extends VarArgsFunc<R> {
        @Override
        default public R apply(Object ... args) {
            return this.apply((T)args[0]);
        }

        public R apply(T var1);
    }

    @FunctionalInterface
    private static interface VarArgsFunc2<T, U, R>
    extends VarArgsFunc<R> {
        @Override
        default public R apply(Object ... args) {
            return this.apply((T)args[0], (U)args[1]);
        }

        public R apply(T var1, U var2);
    }

    @FunctionalInterface
    private static interface VarArgsFunc3<T, U, V, R>
    extends VarArgsFunc<R> {
        @Override
        default public R apply(Object ... args) {
            return this.apply((T)args[0], (U)args[1], (V)args[2]);
        }

        public R apply(T var1, U var2, V var3);
    }

    @FunctionalInterface
    private static interface VarArgsFunc4<T, U, V, W, R>
    extends VarArgsFunc<R> {
        @Override
        default public R apply(Object ... args) {
            return this.apply((T)args[0], (U)args[1], (V)args[2], (W)args[3]);
        }

        public R apply(T var1, U var2, V var3, W var4);
    }

    private static interface VarArgsFunc<R> {
        default public R apply(Object ... args) {
            throw new UnsupportedOperationException();
        }
    }

    public static interface ClassMethodDispatcher<T, E>
    extends ReflectUtil.MethodDispatcher<T> {
        default public void register(Iterable<Class<? extends E>> classes) throws Throwable {
        }
    }
}

