/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelShuttleImpl;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveTezModelRelMetadataProvider;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveDefaultCostModel;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveCardinalityPreservingJoinOptimization;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveFieldTrimmerRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveCardinalityPreservingJoinRule
extends HiveFieldTrimmerRule {
    private static final Logger LOG = LoggerFactory.getLogger(HiveCardinalityPreservingJoinRule.class);
    private final double factor;

    public HiveCardinalityPreservingJoinRule(double factor) {
        super(false, "HiveCardinalityPreservingJoinRule");
        this.factor = Math.max(factor, 0.0);
    }

    @Override
    protected RelNode trim(RelOptRuleCall call, RelNode node) {
        RelNode optimized = new HiveCardinalityPreservingJoinOptimization().trim(call.builder(), node);
        if (optimized == node) {
            return node;
        }
        RelNode chosen = this.choosePlan(node, optimized);
        new JoinAlgorithmSetter().visit(chosen);
        return chosen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RelNode choosePlan(RelNode node, RelNode optimized) {
        JaninoRelMetadataProvider original = (JaninoRelMetadataProvider)RelMetadataQuery.THREAD_PROVIDERS.get();
        try {
            RelMetadataQuery.THREAD_PROVIDERS.set(HiveTezModelRelMetadataProvider.DEFAULT);
            node.getCluster().invalidateMetadataQuery();
            RelMetadataQuery metadataQuery = RelMetadataQuery.instance();
            RelOptCost optimizedCost = metadataQuery.getCumulativeCost(optimized);
            RelOptCost originalCost = metadataQuery.getCumulativeCost(node);
            originalCost = originalCost.multiplyBy(this.factor);
            LOG.debug("Original plan cost {} vs Optimized plan cost {}", (Object)originalCost, (Object)optimizedCost);
            if (optimizedCost.isLt(originalCost)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Plan after:\n" + RelOptUtil.toString((RelNode)optimized));
                }
                RelNode relNode = optimized;
                return relNode;
            }
            RelNode relNode = node;
            return relNode;
        }
        finally {
            node.getCluster().invalidateMetadataQuery();
            RelMetadataQuery.THREAD_PROVIDERS.set(original);
        }
    }

    private static class JoinAlgorithmSetter
    extends HiveRelShuttleImpl {
        private JoinAlgorithmSetter() {
        }

        @Override
        public RelNode visit(HiveJoin join) {
            join.setJoinAlgorithm(HiveDefaultCostModel.DefaultJoinAlgorithm.INSTANCE);
            return super.visit(join);
        }
    }
}

