/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.functions;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSplittableAggFunction;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.hadoop.hive.ql.optimizer.calcite.functions.CanAggregateDistinct;
import org.apache.hadoop.hive.ql.optimizer.calcite.functions.HiveSqlSumEmptyIsZeroAggFunction;
import org.checkerframework.checker.nullness.qual.Nullable;

public class HiveSqlCountAggFunction
extends SqlAggFunction
implements CanAggregateDistinct {
    final boolean isDistinct;
    final SqlReturnTypeInference returnTypeInference;
    final SqlOperandTypeInference operandTypeInference;
    final SqlOperandTypeChecker operandTypeChecker;

    public HiveSqlCountAggFunction(boolean isDistinct, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker) {
        super("count", SqlKind.COUNT, returnTypeInference, operandTypeInference, operandTypeChecker, SqlFunctionCategory.NUMERIC);
        this.isDistinct = isDistinct;
        this.returnTypeInference = returnTypeInference;
        this.operandTypeChecker = operandTypeChecker;
        this.operandTypeInference = operandTypeInference;
    }

    @Override
    public boolean isDistinct() {
        return this.isDistinct;
    }

    public SqlSyntax getSyntax() {
        return SqlSyntax.FUNCTION_STAR;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz == SqlSplittableAggFunction.class) {
            return clazz.cast((Object)new HiveCountSplitter());
        }
        return (T)super.unwrap(clazz);
    }

    public @Nullable SqlAggFunction getRollup() {
        return new HiveSqlSumEmptyIsZeroAggFunction(this.isDistinct(), this.getReturnTypeInference(), this.getOperandTypeInference(), this.getOperandTypeChecker());
    }

    class HiveCountSplitter
    extends SqlSplittableAggFunction.CountSplitter {
        HiveCountSplitter() {
        }

        public AggregateCall other(RelDataTypeFactory typeFactory, AggregateCall e) {
            return AggregateCall.create((SqlAggFunction)new HiveSqlCountAggFunction(HiveSqlCountAggFunction.this.isDistinct, HiveSqlCountAggFunction.this.returnTypeInference, HiveSqlCountAggFunction.this.operandTypeInference, HiveSqlCountAggFunction.this.operandTypeChecker), (boolean)false, (List)ImmutableIntList.of(), (int)-1, (RelDataType)typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BIGINT), true), (String)"count");
        }

        public AggregateCall topSplit(RexBuilder rexBuilder, SqlSplittableAggFunction.Registry<RexNode> extra, int offset, RelDataType inputRowType, AggregateCall aggregateCall, int leftSubTotal, int rightSubTotal) {
            ArrayList<RexInputRef> merges = new ArrayList<RexInputRef>();
            if (leftSubTotal >= 0) {
                merges.add(rexBuilder.makeInputRef(aggregateCall.type, leftSubTotal));
            }
            if (rightSubTotal >= 0) {
                merges.add(rexBuilder.makeInputRef(aggregateCall.type, rightSubTotal));
            }
            int ordinal = extra.register((Object)(switch (merges.size()) {
                case 1 -> (RexNode)merges.get(0);
                case 2 -> rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, merges);
                default -> throw new AssertionError((Object)("unexpected count " + String.valueOf(merges)));
            }));
            return AggregateCall.create((SqlAggFunction)new HiveSqlSumEmptyIsZeroAggFunction(HiveSqlCountAggFunction.this.isDistinct, HiveSqlCountAggFunction.this.returnTypeInference, HiveSqlCountAggFunction.this.operandTypeInference, HiveSqlCountAggFunction.this.operandTypeChecker), (boolean)false, (List)ImmutableList.of((Object)ordinal), (int)-1, (RelDataType)aggregateCall.type, (String)aggregateCall.name);
        }
    }
}

