/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FooterBuffer;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidInputFormat;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.IOContext;
import org.apache.hadoop.hive.ql.io.IOContextMap;
import org.apache.hadoop.hive.ql.io.IOPrepareCache;
import org.apache.hadoop.hive.ql.io.RCFile;
import org.apache.hadoop.hive.ql.io.RCFileRecordReader;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.ql.io.orc.OrcRawRecordMerger;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.TextInputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HiveContextAwareRecordReader<K extends WritableComparable, V extends Writable>
implements RecordReader<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger((String)HiveContextAwareRecordReader.class.getName());
    private boolean initDone = false;
    private long rangeStart;
    private long rangeEnd;
    private long splitEnd;
    private long previousPosition = -1L;
    private boolean wasUsingSortedSearch = false;
    private String genericUDFClassName = null;
    private final List<IOContext.Comparison> stopComparisons = new ArrayList<IOContext.Comparison>();
    private Map<Path, PartitionDesc> pathToPartitionInfo;
    protected RecordReader<K, V> recordReader;
    protected JobConf jobConf;
    protected boolean isSorted = false;
    private IOContext ioCxtRef = null;
    private FooterBuffer footerBuffer = null;
    private int headerCount = 0;
    private int footerCount = 0;

    public HiveContextAwareRecordReader(JobConf conf) throws IOException {
        this(null, conf);
    }

    public HiveContextAwareRecordReader(RecordReader<K, V> recordReader) {
        this.recordReader = recordReader;
    }

    public HiveContextAwareRecordReader(RecordReader<K, V> recordReader, JobConf conf) throws IOException {
        this.recordReader = recordReader;
        this.jobConf = conf;
    }

    public void setRecordReader(RecordReader<K, V> recordReader) {
        this.recordReader = recordReader;
    }

    public abstract void doClose() throws IOException;

    public void close() throws IOException {
        this.doClose();
        this.initDone = false;
        this.ioCxtRef = null;
    }

    public boolean next(K key, V value) throws IOException {
        if (!this.initDone) {
            throw new IOException("Hive IOContext is not inited.");
        }
        this.updateIOContext();
        try {
            boolean retVal = this.doNext(key, value);
            if (retVal) {
                if (key instanceof RecordIdentifier) {
                    this.ioCxtRef.setRecordIdentifier((RecordIdentifier)key);
                } else if (this.recordReader instanceof AcidInputFormat.AcidRecordReader) {
                    AcidInputFormat.AcidRecordReader acidRecordReader = (AcidInputFormat.AcidRecordReader)this.recordReader;
                    OrcRawRecordMerger.ReaderKey recordIdentifier = acidRecordReader.getRecordIdentifier();
                    if (recordIdentifier == null) {
                        this.ioCxtRef.parseRecordIdentifier((Configuration)this.jobConf);
                    } else {
                        this.ioCxtRef.setRecordIdentifier(recordIdentifier);
                    }
                    this.ioCxtRef.setDeletedRecord(recordIdentifier != null && recordIdentifier.isDeleteEvent());
                } else {
                    this.ioCxtRef.parseRecordIdentifier((Configuration)this.jobConf);
                    this.ioCxtRef.parsePositionDeleteInfo((Configuration)this.jobConf);
                }
            }
            return retVal;
        }
        catch (IOException e) {
            this.ioCxtRef.setIOExceptions(true);
            throw e;
        }
    }

    protected void updateIOContext() throws IOException {
        long pointerPos = this.getPos();
        if (!this.ioCxtRef.isBlockPointer()) {
            this.ioCxtRef.setCurrentBlockStart(pointerPos);
            this.ioCxtRef.setCurrentRow(0L);
            return;
        }
        this.ioCxtRef.setCurrentRow(this.ioCxtRef.getCurrentRow() + 1L);
        if (this.ioCxtRef.getNextBlockStart() == -1L) {
            this.ioCxtRef.setNextBlockStart(pointerPos);
            this.ioCxtRef.setCurrentRow(0L);
        }
        if (pointerPos != this.ioCxtRef.getNextBlockStart()) {
            this.ioCxtRef.setCurrentRow(0L);
            if (this.ioCxtRef.getCurrentBlockStart() == this.ioCxtRef.getNextBlockStart()) {
                this.ioCxtRef.setCurrentRow(1L);
            }
            this.ioCxtRef.setCurrentBlockStart(this.ioCxtRef.getNextBlockStart());
            this.ioCxtRef.setNextBlockStart(pointerPos);
        }
    }

    public IOContext getIOContext() {
        return IOContextMap.get((Configuration)this.jobConf);
    }

    private void initIOContext(long startPos, boolean isBlockPointer, Path inputPath) {
        this.ioCxtRef = this.getIOContext();
        this.ioCxtRef.setCurrentBlockStart(startPos);
        this.ioCxtRef.setBlockPointer(isBlockPointer);
        this.ioCxtRef.setInputPath(inputPath);
        LOG.debug("Processing file " + String.valueOf(inputPath));
        this.initDone = true;
    }

    public void initIOContext(FileSplit split, JobConf job, Class inputFormatClass) throws IOException {
        this.initIOContext(split, job, inputFormatClass, null);
    }

    public void initIOContext(FileSplit split, JobConf job, Class inputFormatClass, RecordReader recordReader) throws IOException {
        boolean blockPointer = false;
        long blockStart = -1L;
        FileSplit fileSplit = split;
        Path path = fileSplit.getPath();
        if (inputFormatClass.getName().contains("SequenceFile")) {
            FileSystem fs = path.getFileSystem((Configuration)job);
            SequenceFile.Reader in = new SequenceFile.Reader(fs, path, (Configuration)job);
            blockPointer = in.isBlockCompressed();
            in.sync(fileSplit.getStart());
            blockStart = in.getPosition();
            in.close();
        } else if (recordReader instanceof RCFileRecordReader) {
            blockPointer = true;
            blockStart = ((RCFileRecordReader)recordReader).getStart();
        } else if (inputFormatClass.getName().contains("RCFile")) {
            FileSystem fs = path.getFileSystem((Configuration)job);
            blockPointer = true;
            RCFile.Reader in = new RCFile.Reader(fs, path, (Configuration)job);
            in.sync(fileSplit.getStart());
            blockStart = in.getPosition();
            in.close();
        }
        this.jobConf = job;
        this.initIOContext(blockStart, blockPointer, path);
        this.initIOContextSortedProps(split, recordReader, job);
    }

    public void initIOContextSortedProps(FileSplit split, RecordReader recordReader, JobConf job) {
        this.jobConf = job;
        this.getIOContext().resetSortingValues();
        this.isSorted = this.jobConf.getBoolean("hive.input.format.sorted", false);
        this.rangeStart = split.getStart();
        this.splitEnd = this.rangeEnd = split.getStart() + split.getLength();
        if (recordReader instanceof RCFileRecordReader && this.rangeEnd != 0L && this.isSorted) {
            this.getIOContext().setUseSorted(true);
            this.getIOContext().setBinarySearching(true);
            this.wasUsingSortedSearch = true;
        } else {
            this.isSorted = false;
        }
    }

    public float getProgress() throws IOException {
        if (this.getIOContext().isBinarySearching()) {
            return 0.0f;
        }
        return this.recordReader.getProgress();
    }

    protected FooterBuffer getFooterBuffer() {
        return this.footerBuffer;
    }

    protected void setFooterBuffer(FooterBuffer buf) {
        this.footerBuffer = buf;
    }

    public boolean doNext(K key, V value) throws IOException {
        if (this.isSorted) {
            if (this.getIOContext().shouldEndBinarySearch() || !this.getIOContext().useSorted() && this.wasUsingSortedSearch) {
                this.beginLinearSearch();
                this.wasUsingSortedSearch = false;
                this.getIOContext().setEndBinarySearch(false);
            }
            if (this.getIOContext().useSorted()) {
                if (this.genericUDFClassName == null && this.getIOContext().getGenericUDFClassName() != null) {
                    this.setGenericUDFClassName(this.getIOContext().getGenericUDFClassName());
                }
                if (this.getIOContext().isBinarySearching()) {
                    if (this.getIOContext().getComparison() != null) {
                        switch (this.getIOContext().getComparison()) {
                            case GREATER: 
                            case EQUAL: {
                                this.rangeEnd = this.previousPosition;
                                break;
                            }
                            case LESS: {
                                this.rangeStart = this.previousPosition;
                                break;
                            }
                        }
                    }
                    long position = (this.rangeStart + this.rangeEnd) / 2L;
                    this.sync(position);
                    long newPosition = this.getSyncedPosition();
                    if (newPosition == this.previousPosition || newPosition >= this.splitEnd) {
                        this.getIOContext().setBinarySearching(false);
                        this.sync(this.rangeStart);
                    }
                    this.previousPosition = newPosition;
                } else if (this.foundAllTargets()) {
                    return false;
                }
            }
        }
        if (this.ioCxtRef.getCurrentBlockStart() == 0L) {
            TableDesc table;
            this.footerBuffer = null;
            Path filePath = this.ioCxtRef.getInputPath();
            PartitionDesc part = null;
            try {
                if (this.pathToPartitionInfo == null) {
                    this.pathToPartitionInfo = Utilities.getMapWork((Configuration)this.jobConf).getPathToPartitionInfo();
                }
                part = HiveFileFormatUtils.getFromPathRecursively(this.pathToPartitionInfo, filePath, IOPrepareCache.get().getPartitionDescMap());
            }
            catch (AssertionError ae) {
                LOG.info("Cannot get partition description from " + String.valueOf(this.ioCxtRef.getInputPath()) + "because " + ((Throwable)((Object)ae)).getMessage());
                part = null;
            }
            catch (Exception e) {
                LOG.info("Cannot get partition description from " + String.valueOf(this.ioCxtRef.getInputPath()) + "because " + e.getMessage());
                part = null;
            }
            TableDesc tableDesc = table = part == null ? null : part.getTableDesc();
            if (table != null && !TextInputFormat.class.isAssignableFrom(part.getInputFileFormatClass())) {
                this.headerCount = Utilities.getHeaderCount(table);
                this.footerCount = Utilities.getFooterCount(table, this.jobConf);
            }
            if (!Utilities.skipHeader(this.recordReader, this.headerCount, key, value)) {
                return false;
            }
            if (this.footerCount > 0) {
                this.footerBuffer = new FooterBuffer();
                if (!this.footerBuffer.initializeBuffer(this.jobConf, (RecordReader)this.recordReader, this.footerCount, (WritableComparable)key, (Writable)value)) {
                    return false;
                }
            }
        }
        if (this.footerBuffer == null) {
            return this.recordReader.next(key, value);
        }
        return this.footerBuffer.updateBuffer(this.jobConf, (RecordReader)this.recordReader, (WritableComparable)key, (Writable)value);
    }

    private void sync(long position) throws IOException {
        ((RCFileRecordReader)this.recordReader).sync(position);
        ((RCFileRecordReader)this.recordReader).resetBuffer();
    }

    private long getSyncedPosition() throws IOException {
        return this.recordReader.getPos();
    }

    private void setGenericUDFClassName(String genericUDFClassName) throws IOException {
        this.genericUDFClassName = genericUDFClassName;
        if (genericUDFClassName.equals(GenericUDFOPEqual.class.getName())) {
            this.stopComparisons.add(IOContext.Comparison.GREATER);
        } else if (genericUDFClassName.equals(GenericUDFOPLessThan.class.getName())) {
            this.stopComparisons.add(IOContext.Comparison.EQUAL);
            this.stopComparisons.add(IOContext.Comparison.GREATER);
            if (this.getIOContext().isBinarySearching()) {
                this.beginLinearSearch();
            }
        } else if (genericUDFClassName.equals(GenericUDFOPEqualOrLessThan.class.getName())) {
            this.stopComparisons.add(IOContext.Comparison.GREATER);
            if (this.getIOContext().isBinarySearching()) {
                this.beginLinearSearch();
            }
        } else if (!genericUDFClassName.equals(GenericUDFOPGreaterThan.class.getName()) && !genericUDFClassName.equals(GenericUDFOPEqualOrGreaterThan.class.getName())) {
            LOG.debug(genericUDFClassName + " is not the name of a supported class.  Continuing linearly.");
            if (this.getIOContext().isBinarySearching()) {
                this.beginLinearSearch();
            }
        }
    }

    private void beginLinearSearch() throws IOException {
        this.sync(this.rangeStart);
        this.getIOContext().setBinarySearching(false);
        this.wasUsingSortedSearch = false;
    }

    public boolean foundAllTargets() {
        return this.getIOContext().getComparison() != null && this.stopComparisons.contains((Object)this.getIOContext().getComparison());
    }
}

