/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class VectorPTFEvaluatorStreamingDecimalMin
extends VectorPTFEvaluatorBase {
    protected boolean isNull;
    protected HiveDecimalWritable min = new HiveDecimalWritable();

    public VectorPTFEvaluatorStreamingDecimalMin(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
        this.resetEvaluator();
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch) throws HiveException {
        this.evaluateInputExpr(batch);
        Preconditions.checkState((!batch.selectedInUse ? 1 : 0) != 0);
        int size = batch.size;
        if (size == 0) {
            return;
        }
        DecimalColumnVector decimalColVector = (DecimalColumnVector)batch.cols[this.inputColumnNum];
        DecimalColumnVector outputColVector = (DecimalColumnVector)batch.cols[this.outputColumnNum];
        if (decimalColVector.isRepeating) {
            if (decimalColVector.noNulls || !decimalColVector.isNull[0]) {
                HiveDecimalWritable repeatedMin = decimalColVector.vector[0];
                if (this.isNull) {
                    this.min.set(repeatedMin);
                    this.isNull = false;
                } else if (repeatedMin.compareTo(this.min) == -1) {
                    this.min.set(repeatedMin);
                }
                outputColVector.set(0, this.min);
            } else if (this.isNull) {
                outputColVector.isNull[0] = true;
                outputColVector.noNulls = false;
            } else {
                outputColVector.set(0, this.min);
            }
            outputColVector.isRepeating = true;
        } else if (decimalColVector.noNulls) {
            HiveDecimalWritable[] vector = decimalColVector.vector;
            for (int i = 0; i < size; ++i) {
                HiveDecimalWritable value = vector[i];
                if (this.isNull) {
                    this.min.set(value);
                    this.isNull = false;
                } else if (value.compareTo(this.min) == -1) {
                    this.min.set(value);
                }
                outputColVector.set(i, this.min);
            }
        } else {
            boolean[] batchIsNull = decimalColVector.isNull;
            int i = 0;
            while (batchIsNull[i]) {
                if (this.isNull) {
                    outputColVector.isNull[i] = true;
                    outputColVector.noNulls = false;
                } else {
                    outputColVector.set(i, this.min);
                }
                if (++i < size) continue;
                return;
            }
            HiveDecimalWritable[] vector = decimalColVector.vector;
            HiveDecimalWritable firstValue = vector[i];
            if (this.isNull) {
                this.min.set(firstValue);
                this.isNull = false;
            } else if (firstValue.compareTo(this.min) == -1) {
                this.min.set(firstValue);
            }
            outputColVector.set(i++, this.min);
            while (i < size) {
                if (!batchIsNull[i]) {
                    HiveDecimalWritable value = vector[i];
                    if (this.isNull) {
                        this.min.set(value);
                        this.isNull = false;
                    } else if (value.compareTo(this.min) == -1) {
                        this.min.set(value);
                    }
                    outputColVector.set(i, this.min);
                } else {
                    outputColVector.set(i, this.min);
                }
                ++i;
            }
        }
    }

    @Override
    public boolean streamsResult() {
        return true;
    }

    @Override
    public ColumnVector.Type getResultColumnVectorType() {
        return ColumnVector.Type.DECIMAL;
    }

    @Override
    public void resetEvaluator() {
        this.isNull = true;
        this.min.set(HiveDecimal.ZERO);
    }
}

