/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;

public class VectorPTFEvaluatorDoubleFirstValue
extends VectorPTFEvaluatorBase {
    protected boolean haveFirstValue;
    protected boolean isGroupResultNull;
    protected Double firstValue = null;

    public VectorPTFEvaluatorDoubleFirstValue(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
        this.resetEvaluator();
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch) throws HiveException {
        block4: {
            block6: {
                DoubleColumnVector doubleColVector;
                int size;
                block8: {
                    block7: {
                        block5: {
                            this.evaluateInputExpr(batch);
                            Preconditions.checkState((!batch.selectedInUse ? 1 : 0) != 0);
                            if (this.haveFirstValue) break block4;
                            size = batch.size;
                            if (size == 0) {
                                return;
                            }
                            doubleColVector = (DoubleColumnVector)batch.cols[this.inputColumnNum];
                            if (!doubleColVector.isRepeating) break block5;
                            if (!doubleColVector.noNulls && doubleColVector.isNull[0]) break block6;
                            this.firstValue = doubleColVector.vector[0];
                            this.isGroupResultNull = false;
                            break block6;
                        }
                        if (!doubleColVector.noNulls) break block7;
                        this.firstValue = doubleColVector.vector[0];
                        this.isGroupResultNull = false;
                        break block6;
                    }
                    if (!this.doesRespectNulls()) break block8;
                    if (doubleColVector.isNull[0]) break block6;
                    this.firstValue = doubleColVector.vector[0];
                    this.isGroupResultNull = false;
                    break block6;
                }
                for (int i = 0; i < size; ++i) {
                    if (doubleColVector.isNull[i]) continue;
                    this.firstValue = doubleColVector.vector[i];
                    this.isGroupResultNull = false;
                    break;
                }
            }
            this.haveFirstValue = this.doesRespectNulls() || !this.isGroupResultNull;
        }
        DoubleColumnVector outputColVector = (DoubleColumnVector)batch.cols[this.outputColumnNum];
        outputColVector.isRepeating = true;
        if (this.isGroupResultNull) {
            outputColVector.noNulls = false;
            outputColVector.isNull[0] = true;
        } else {
            outputColVector.isNull[0] = false;
            outputColVector.vector[0] = this.firstValue;
        }
    }

    @Override
    public boolean streamsResult() {
        return true;
    }

    @Override
    public boolean isGroupResultNull() {
        return this.isGroupResultNull;
    }

    @Override
    public ColumnVector.Type getResultColumnVectorType() {
        return ColumnVector.Type.DOUBLE;
    }

    @Override
    public Object getGroupResult() {
        return this.firstValue;
    }

    @Override
    public void resetEvaluator() {
        this.haveFirstValue = false;
        this.isGroupResultNull = true;
        this.firstValue = null;
    }

    @Override
    public boolean isCacheableForRange() {
        throw new RuntimeException("isCacheableForRange check is not expected for first_value");
    }
}

