/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.nio.charset.StandardCharsets;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.TruncDateFromTimestamp;
import org.apache.hive.common.util.DateParser;

public class TruncDateFromString
extends TruncDateFromTimestamp {
    private transient Date date = new Date();
    private static final long serialVersionUID = 1L;

    public TruncDateFromString(int colNum, byte[] fmt, int outputColumnNum) {
        super(colNum, fmt, outputColumnNum);
    }

    public TruncDateFromString() {
    }

    @Override
    protected void truncDate(ColumnVector inV, BytesColumnVector outV, int i) {
        this.truncDate((BytesColumnVector)inV, outV, i);
    }

    protected void truncDate(BytesColumnVector inV, BytesColumnVector outV, int i) {
        String dateString;
        if (inV.vector[i] == null) {
            outV.isNull[i] = true;
            outV.noNulls = false;
        }
        if (DateParser.parseDate((String)(dateString = new String(inV.vector[i], inV.start[i], inV.length[i], StandardCharsets.UTF_8)), (Date)this.date)) {
            this.processDate(outV, i, this.date);
        } else {
            outV.isNull[i] = true;
            outV.noNulls = false;
        }
    }

    @Override
    protected VectorExpressionDescriptor.ArgumentType getInputColumnType() {
        return VectorExpressionDescriptor.ArgumentType.STRING_FAMILY;
    }
}

