/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class IfExprNullColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;

    public IfExprNullColumn(int arg1Column, int arg2Column, int outputColumnNum) {
        super(arg1Column, arg2Column, outputColumnNum);
    }

    public IfExprNullColumn() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector arg1ColVector = (LongColumnVector)batch.cols[this.inputColumnNum[0]];
        ColumnVector arg2ColVector = batch.cols[this.inputColumnNum[1]];
        ColumnVector outputColVector = batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        int n = batch.size;
        boolean[] null1 = arg1ColVector.isNull;
        long[] vector1 = arg1ColVector.vector;
        boolean[] isNull = outputColVector.isNull;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        if (arg1ColVector.isRepeating) {
            if ((arg1ColVector.noNulls || !null1[0]) && vector1[0] == 1L) {
                outputColVector.isRepeating = true;
                outputColVector.noNulls = false;
                isNull[0] = true;
            } else {
                arg2ColVector.copySelected(batch.selectedInUse, sel, n, outputColVector);
            }
            return;
        }
        if (arg1ColVector.noNulls) {
            if (arg2ColVector.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j < n; ++j) {
                        int i = sel[j];
                        if (vector1[i] == 1L) {
                            isNull[i] = true;
                            outputColVector.noNulls = false;
                            continue;
                        }
                        isNull[i] = false;
                        outputColVector.setElement(i, 0, arg2ColVector);
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        if (vector1[i] == 1L) {
                            isNull[i] = true;
                            outputColVector.noNulls = false;
                            continue;
                        }
                        isNull[i] = false;
                        outputColVector.setElement(i, 0, arg2ColVector);
                    }
                }
            } else if (batch.selectedInUse) {
                for (int j = 0; j < n; ++j) {
                    int i = sel[j];
                    if (vector1[i] == 1L) {
                        isNull[i] = true;
                        outputColVector.noNulls = false;
                        continue;
                    }
                    isNull[i] = false;
                    outputColVector.setElement(i, i, arg2ColVector);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    if (vector1[i] == 1L) {
                        isNull[i] = true;
                        outputColVector.noNulls = false;
                        continue;
                    }
                    isNull[i] = false;
                    outputColVector.setElement(i, i, arg2ColVector);
                }
            }
        } else if (arg2ColVector.isRepeating) {
            if (batch.selectedInUse) {
                for (int j = 0; j < n; ++j) {
                    int i = sel[j];
                    if (!null1[i] && vector1[i] == 1L) {
                        isNull[i] = true;
                        outputColVector.noNulls = false;
                        continue;
                    }
                    isNull[i] = false;
                    outputColVector.setElement(i, 0, arg2ColVector);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    if (!null1[i] && vector1[i] == 1L) {
                        isNull[i] = true;
                        outputColVector.noNulls = false;
                        continue;
                    }
                    isNull[i] = false;
                    outputColVector.setElement(i, 0, arg2ColVector);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j < n; ++j) {
                int i = sel[j];
                if (!null1[i] && vector1[i] == 1L) {
                    isNull[i] = true;
                    outputColVector.noNulls = false;
                    continue;
                }
                isNull[i] = false;
                outputColVector.setElement(i, i, arg2ColVector);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (!null1[i] && vector1[i] == 1L) {
                    isNull[i] = true;
                    outputColVector.noNulls = false;
                    continue;
                }
                isNull[i] = false;
                outputColVector.setElement(i, i, arg2ColVector);
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumnNum[0]) + ", null, col " + this.inputColumnNum[1];
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        throw new UnsupportedOperationException("Undefined descriptor");
    }
}

