/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import org.apache.hadoop.hive.ql.metadata.HiveException;

public class VectorUtilBatchObjectPool<T> {
    private final T[] buffer;
    private int head = 0;
    private int count = 0;
    private IAllocator<T> allocator;

    public VectorUtilBatchObjectPool(int size, IAllocator<T> allocator) {
        this.buffer = new Object[size];
        this.allocator = allocator;
    }

    public T getFromPool() throws HiveException {
        T ret = null;
        if (this.count == 0) {
            ret = this.allocator.alloc();
        } else {
            int tail = (this.head + this.buffer.length - this.count) % this.buffer.length;
            ret = this.buffer[tail];
            this.buffer[tail] = null;
            --this.count;
        }
        return ret;
    }

    public void putInPool(T object) {
        if (this.count < this.buffer.length) {
            this.buffer[this.head] = object;
            ++this.count;
            ++this.head;
            if (this.head == this.buffer.length) {
                this.head = 0;
            }
        } else {
            this.allocator.free(object);
        }
    }

    public static interface IAllocator<T> {
        public T alloc() throws HiveException;

        public void free(T var1);
    }
}

