/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hive.common.util.AnnotationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorExpressionDescriptor {
    private static final Logger LOG = LoggerFactory.getLogger((String)VectorExpressionDescriptor.class.getName());
    static final int MAX_NUM_ARGUMENTS = 3;

    public Class<?> getVectorExpressionClass(Class<?> udf, Descriptor descriptor, boolean useCheckedExpressionIfAvailable) throws HiveException {
        VectorizedExpressions annotation = (VectorizedExpressions)AnnotationUtils.getAnnotation(udf, VectorizedExpressions.class);
        if (annotation == null || annotation.value() == null) {
            return null;
        }
        Class<? extends VectorExpression>[] list = annotation.value();
        Class<? extends VectorExpression> matchedVe = null;
        for (Class<? extends VectorExpression> ve : list) {
            try {
                VectorExpression candidateVe = ve.newInstance();
                if (!candidateVe.getDescriptor().matches(descriptor)) continue;
                if (!useCheckedExpressionIfAvailable) {
                    return ve;
                }
                if (candidateVe.supportsCheckedExecution()) {
                    return ve;
                }
                matchedVe = ve;
            }
            catch (Exception ex) {
                throw new HiveException("Could not instantiate VectorExpression class " + ve.getSimpleName(), (Throwable)ex);
            }
        }
        if (matchedVe != null) {
            return matchedVe;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getVectorExpressionClass udf " + udf.getSimpleName() + " descriptor: " + descriptor.toString());
            for (Class<? extends VectorExpression> ve : list) {
                try {
                    LOG.debug("getVectorExpressionClass doesn't match " + ve.getSimpleName() + " " + ve.newInstance().getDescriptor().toString());
                }
                catch (Exception ex) {
                    throw new HiveException((Throwable)ex);
                }
            }
        }
        return null;
    }

    public static final class Descriptor {
        private final Mode mode;
        private final ArgumentType[] argTypes;
        private final InputExpressionType[] exprTypes;
        private final int argCount;
        private final boolean unscaled;

        public boolean matches(Descriptor other) {
            if (!this.mode.equals((Object)other.mode) || this.argCount != other.argCount) {
                return false;
            }
            if (this.unscaled != other.unscaled) {
                return false;
            }
            for (int i = 0; i < this.argCount; ++i) {
                if (!this.argTypes[i].isSameTypeOrFamily(other.argTypes[i])) {
                    return false;
                }
                if (this.exprTypes[i].equals((Object)other.exprTypes[i])) continue;
                return false;
            }
            return true;
        }

        private Descriptor(Mode mode, int argCount, ArgumentType[] argTypes, InputExpressionType[] exprTypes, boolean unscaled) {
            this.mode = mode;
            this.argTypes = (ArgumentType[])argTypes.clone();
            this.exprTypes = (InputExpressionType[])exprTypes.clone();
            this.argCount = argCount;
            this.unscaled = unscaled;
        }

        public String toString() {
            int i;
            StringBuilder b = new StringBuilder("Argument Count = ");
            b.append(this.argCount);
            b.append(", mode = ");
            b.append((Object)this.mode);
            b.append(", Argument Types = {");
            for (i = 0; i < this.argCount; ++i) {
                if (i != 0) {
                    b.append(",");
                }
                b.append((Object)this.argTypes[i]);
            }
            b.append("}");
            b.append(", Input Expression Types = {");
            for (i = 0; i < this.argCount; ++i) {
                if (i != 0) {
                    b.append(",");
                }
                b.append((Object)this.exprTypes[i]);
            }
            b.append("}");
            return b.toString();
        }
    }

    public static class Builder {
        private Mode mode = Mode.PROJECTION;
        ArgumentType[] argTypes = new ArgumentType[3];
        InputExpressionType[] exprTypes = new InputExpressionType[3];
        private boolean unscaled;
        private int argCount = 0;

        public Builder() {
            for (int i = 0; i < 3; ++i) {
                this.argTypes[i] = ArgumentType.NONE;
                this.exprTypes[i] = InputExpressionType.NONE;
            }
        }

        public Builder setMode(Mode m) {
            this.mode = m;
            return this;
        }

        public Builder setNumArguments(int argCount) {
            this.argCount = argCount;
            return this;
        }

        public Builder setArgumentTypes(ArgumentType ... types) {
            for (int i = 0; i < types.length; ++i) {
                this.argTypes[i] = types[i];
            }
            return this;
        }

        public Builder setArgumentTypes(String ... types) {
            for (int i = 0; i < types.length; ++i) {
                this.argTypes[i] = ArgumentType.getType(types[i]);
            }
            return this;
        }

        public Builder setArgumentType(int index, ArgumentType type) {
            this.argTypes[index] = type;
            return this;
        }

        public Builder setArgumentType(int index, String type) {
            this.argTypes[index] = ArgumentType.getType(type);
            return this;
        }

        public Builder setInputExpressionTypes(InputExpressionType ... types) {
            for (int i = 0; i < types.length; ++i) {
                this.exprTypes[i] = types[i];
            }
            return this;
        }

        public Builder setInputExpressionType(int index, InputExpressionType type) {
            this.exprTypes[index] = type;
            return this;
        }

        public Builder setUnscaled(boolean unscaled) {
            this.unscaled = unscaled;
            return this;
        }

        public Descriptor build() {
            return new Descriptor(this.mode, this.argCount, this.argTypes, this.exprTypes, this.unscaled);
        }
    }

    public static enum Mode {
        PROJECTION(0),
        FILTER(1);

        private final int value;

        private Mode(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum InputExpressionType {
        NONE(0),
        COLUMN(1),
        SCALAR(2),
        DYNAMICVALUE(3),
        NULLSCALAR(4);

        private final int value;

        private InputExpressionType(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum ArgumentType {
        NONE(0L),
        INT_FAMILY(1L),
        FLOAT(2L),
        DOUBLE(4L),
        FLOAT_FAMILY(ArgumentType.FLOAT.value | ArgumentType.DOUBLE.value),
        DECIMAL(8L),
        STRING(16L),
        CHAR(32L),
        VARCHAR(64L),
        STRING_FAMILY(ArgumentType.STRING.value | ArgumentType.CHAR.value | ArgumentType.VARCHAR.value),
        DATE(128L),
        TIMESTAMP(256L),
        INTERVAL_YEAR_MONTH(512L),
        INTERVAL_DAY_TIME(1024L),
        BINARY(2048L),
        STRUCT(4096L),
        DECIMAL_64(8192L),
        LIST(16384L),
        MAP(32768L),
        VOID(65536L),
        INT_DECIMAL_64_FAMILY(ArgumentType.INT_FAMILY.value | ArgumentType.DECIMAL_64.value),
        DATETIME_FAMILY(ArgumentType.DATE.value | ArgumentType.TIMESTAMP.value),
        INTERVAL_FAMILY(ArgumentType.INTERVAL_YEAR_MONTH.value | ArgumentType.INTERVAL_DAY_TIME.value),
        INT_INTERVAL_YEAR_MONTH(ArgumentType.INT_FAMILY.value | ArgumentType.INTERVAL_YEAR_MONTH.value),
        INT_DATE_INTERVAL_YEAR_MONTH(ArgumentType.INT_FAMILY.value | ArgumentType.DATE.value | ArgumentType.INTERVAL_YEAR_MONTH.value),
        STRING_DATETIME_FAMILY(ArgumentType.STRING_FAMILY.value | ArgumentType.DATETIME_FAMILY.value),
        STRING_FAMILY_BINARY(ArgumentType.STRING_FAMILY.value | ArgumentType.BINARY.value),
        STRING_BINARY(ArgumentType.STRING.value | ArgumentType.BINARY.value),
        ALL_FAMILY(0xFFFFFFL);

        private final long value;

        private ArgumentType(long val) {
            this.value = val;
        }

        public long getValue() {
            return this.value;
        }

        public static ArgumentType fromHiveTypeName(String hiveTypeName) {
            String lower = hiveTypeName.toLowerCase();
            if (lower.equals("tinyint") || lower.equals("smallint") || lower.equals("int") || lower.equals("bigint") || lower.equals("boolean") || lower.equals("long")) {
                return INT_FAMILY;
            }
            if (lower.equals("double") || lower.equals("float")) {
                return FLOAT_FAMILY;
            }
            if (lower.equals("string")) {
                return STRING;
            }
            if (VectorizationContext.charTypePattern.matcher(lower).matches()) {
                return CHAR;
            }
            if (VectorizationContext.varcharTypePattern.matcher(lower).matches()) {
                return VARCHAR;
            }
            if (lower.equals("binary")) {
                return BINARY;
            }
            if (VectorizationContext.decimalTypePattern.matcher(lower).matches()) {
                return DECIMAL;
            }
            if (lower.equals("timestamp")) {
                return TIMESTAMP;
            }
            if (lower.equals("date")) {
                return DATE;
            }
            if (lower.equals("interval_year_month")) {
                return INTERVAL_YEAR_MONTH;
            }
            if (lower.equals("interval_day_time")) {
                return INTERVAL_DAY_TIME;
            }
            if (VectorizationContext.structTypePattern.matcher(lower).matches()) {
                return STRUCT;
            }
            if (VectorizationContext.listTypePattern.matcher(lower).matches()) {
                return LIST;
            }
            if (VectorizationContext.mapTypePattern.matcher(lower).matches()) {
                return MAP;
            }
            if (lower.equals("void")) {
                return VOID;
            }
            return NONE;
        }

        public static ArgumentType getType(String inType) {
            if (inType.equalsIgnoreCase("long")) {
                return INT_FAMILY;
            }
            if (inType.equalsIgnoreCase("double")) {
                return FLOAT_FAMILY;
            }
            if (VectorizationContext.decimalTypePattern.matcher(inType).matches()) {
                return DECIMAL;
            }
            if (VectorizationContext.charTypePattern.matcher(inType).matches()) {
                return CHAR;
            }
            if (VectorizationContext.varcharTypePattern.matcher(inType).matches()) {
                return VARCHAR;
            }
            return ArgumentType.valueOf(inType.toUpperCase());
        }

        public boolean isSameTypeOrFamily(ArgumentType other) {
            return (this.value & other.value) != 0L;
        }
    }
}

