/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.hive.ql.exec.ObjectCache;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapObjectCache
implements ObjectCache {
    private static final Logger LOG = LoggerFactory.getLogger((String)LlapObjectCache.class.getName());
    private static ExecutorService staticPool = Executors.newCachedThreadPool();
    private final Cache<String, Object> registry = CacheBuilder.newBuilder().softValues().build();
    private final Map<String, ReentrantLock> locks = new HashMap<String, ReentrantLock>();
    private final ReentrantLock lock = new ReentrantLock();

    @Override
    public void release(String key) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T retrieve(String key) throws HiveException {
        Object value = null;
        this.lock.lock();
        try {
            value = this.registry.getIfPresent((Object)key);
            if (value != null && LOG.isDebugEnabled()) {
                LOG.debug("Found " + key + " in cache");
            }
            Object object = value;
            return (T)object;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T retrieve(String key, Callable<T> fn) throws HiveException {
        Object value = null;
        ReentrantLock objectLock = null;
        this.lock.lock();
        try {
            value = this.registry.getIfPresent((Object)key);
            if (value != null) {
                LOG.debug("Found {} in cache", (Object)key);
                Object object = value;
                return (T)object;
            }
            if (this.locks.containsKey(key)) {
                objectLock = this.locks.get(key);
            } else {
                objectLock = new ReentrantLock();
                this.locks.put(key, objectLock);
            }
        }
        finally {
            this.lock.unlock();
        }
        objectLock.lock();
        try {
            block20: {
                this.lock.lock();
                value = this.registry.getIfPresent((Object)key);
                if (value == null) break block20;
                LOG.debug("Found {} in cache", (Object)key);
                Object object = value;
                return (T)object;
                finally {
                    this.lock.unlock();
                }
            }
            try {
                value = fn.call();
            }
            catch (Exception e) {
                throw new HiveException((Throwable)e);
            }
            this.lock.lock();
            try {
                LOG.debug("Caching new object for key: {}", (Object)key);
                this.registry.put((Object)key, value);
                this.locks.remove(key);
            }
            finally {
                this.lock.unlock();
            }
        }
        finally {
            objectLock.unlock();
        }
        return (T)value;
    }

    @Override
    public <T> Future<T> retrieveAsync(final String key, final Callable<T> fn) throws HiveException {
        return staticPool.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return LlapObjectCache.this.retrieve(key, fn);
            }
        });
    }

    @Override
    public void remove(String key) {
        LOG.debug("Removing key: {}", (Object)key);
        this.registry.invalidate((Object)key);
    }
}

