/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.RecordWriter;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class TextRecordWriter
implements RecordWriter {
    private OutputStream out;
    private Configuration conf;

    @Override
    public void initialize(OutputStream out, Configuration conf) throws IOException {
        this.out = out;
        this.conf = conf;
    }

    @Override
    public void write(Writable row) throws IOException {
        Text text;
        Text escapeText = text = (Text)row;
        if (HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SCRIPT_ESCAPE)) {
            escapeText = HiveUtils.escapeText(text);
        }
        this.out.write(escapeText.getBytes(), 0, escapeText.getLength());
        this.out.write(10);
    }

    @Override
    public void close() throws IOException {
        this.out.flush();
        this.out.close();
    }
}

