/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.AmbiguousMethodException;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.NoMatchingMethodException;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFMethodResolver;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class NumericOpMethodResolver
implements UDFMethodResolver {
    Class<? extends UDF> udfClass;

    public NumericOpMethodResolver(Class<? extends UDF> udfClass) {
        this.udfClass = udfClass;
    }

    public Method getEvalMethod(List<TypeInfo> argTypeInfos) throws UDFArgumentException {
        assert (argTypeInfos.size() == 2);
        ArrayList<TypeInfo> pTypeInfos = null;
        ArrayList<Object> modArgTypeInfos = new ArrayList<Object>();
        if (argTypeInfos.get(0).equals((Object)TypeInfoFactory.stringTypeInfo) || argTypeInfos.get(1).equals((Object)TypeInfoFactory.stringTypeInfo)) {
            if (argTypeInfos.get(0).equals((Object)TypeInfoFactory.decimalTypeInfo) || argTypeInfos.get(1).equals((Object)TypeInfoFactory.decimalTypeInfo)) {
                modArgTypeInfos.add(TypeInfoFactory.decimalTypeInfo);
                modArgTypeInfos.add(TypeInfoFactory.decimalTypeInfo);
            } else {
                modArgTypeInfos.add(TypeInfoFactory.doubleTypeInfo);
                modArgTypeInfos.add(TypeInfoFactory.doubleTypeInfo);
            }
        } else {
            for (int i = 0; i < 2; ++i) {
                if (argTypeInfos.get(i).equals((Object)TypeInfoFactory.voidTypeInfo)) {
                    modArgTypeInfos.add(TypeInfoFactory.byteTypeInfo);
                    continue;
                }
                modArgTypeInfos.add(argTypeInfos.get(i));
            }
        }
        TypeInfo commonType = FunctionRegistry.getCommonClass((TypeInfo)modArgTypeInfos.get(0), (TypeInfo)modArgTypeInfos.get(1));
        if (commonType == null) {
            throw new UDFArgumentException("Unable to find a common class betweentypes " + ((TypeInfo)modArgTypeInfos.get(0)).getTypeName() + " and " + ((TypeInfo)modArgTypeInfos.get(1)).getTypeName());
        }
        pTypeInfos = new ArrayList<TypeInfo>();
        pTypeInfos.add(commonType);
        pTypeInfos.add(commonType);
        Method udfMethod = null;
        for (Method m : Arrays.asList(this.udfClass.getMethods())) {
            List argumentTypeInfos;
            if (!m.getName().equals("evaluate") || (argumentTypeInfos = TypeInfoUtils.getParameterTypeInfos((Method)m, (int)pTypeInfos.size())) == null) continue;
            boolean match = argumentTypeInfos.size() == pTypeInfos.size();
            for (int i = 0; i < pTypeInfos.size() && match; ++i) {
                TypeInfo accepted = (TypeInfo)argumentTypeInfos.get(i);
                if (accepted.accept((TypeInfo)pTypeInfos.get(i))) continue;
                match = false;
            }
            if (!match) continue;
            if (udfMethod != null) {
                throw new AmbiguousMethodException(this.udfClass, argTypeInfos, Arrays.asList(udfMethod, m));
            }
            udfMethod = m;
        }
        if (udfMethod == null) {
            throw new NoMatchingMethodException(this.udfClass, argTypeInfos, null);
        }
        return udfMethod;
    }
}

