/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.CommonJoinOperator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.persistence.RowContainer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

public abstract class AbstractMapJoinOperator<T extends MapJoinDesc>
extends CommonJoinOperator<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient List<ExprNodeEvaluator>[] joinKeys;
    protected transient List<ObjectInspector>[] joinKeysObjectInspectors;
    protected transient byte posBigTable = (byte)-1;
    protected transient RowContainer<List<Object>> emptyList = null;
    transient int numMapRowsRead;

    protected AbstractMapJoinOperator() {
    }

    public AbstractMapJoinOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public AbstractMapJoinOperator(AbstractMapJoinOperator<? extends MapJoinDesc> mjop) {
        super(mjop);
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        RowContainer<List<Object>> bigPosRC;
        if (((MapJoinDesc)this.conf).getGenJoinKeys()) {
            int tagLen = ((MapJoinDesc)this.conf).getTagLength();
            this.joinKeys = new List[tagLen];
            JoinUtil.populateJoinKeyValue(this.joinKeys, ((MapJoinDesc)this.conf).getKeys(), -1, hconf);
            this.joinKeysObjectInspectors = JoinUtil.getObjectInspectorsFromEvaluators(this.joinKeys, this.inputObjInspectors, -1, tagLen);
        }
        super.initializeOp(hconf);
        this.numMapRowsRead = 0;
        this.posBigTable = (byte)((MapJoinDesc)this.conf).getPosBigTable();
        this.emptyList = new RowContainer(1, hconf, this.reporter);
        this.storage[this.posBigTable] = bigPosRC = JoinUtil.getRowContainer(hconf, this.rowContainerStandardObjectInspectors[this.posBigTable], this.posBigTable, this.joinCacheSize, this.spillTableDesc, (JoinDesc)this.conf, !this.hasFilter(this.posBigTable), this.reporter);
    }

    @Override
    protected List<ObjectInspector> getValueObjectInspectors(byte alias, List<ObjectInspector>[] aliasToObjectInspectors) {
        List<ObjectInspector> inspectors = aliasToObjectInspectors[alias];
        List<Integer> retained = ((MapJoinDesc)this.conf).getRetainList().get(alias);
        if (inspectors.size() == retained.size()) {
            return inspectors;
        }
        ArrayList<ObjectInspector> retainedOIs = new ArrayList<ObjectInspector>();
        for (int index : retained) {
            retainedOIs.add(inspectors.get(index));
        }
        return retainedOIs;
    }

    @Override
    public OperatorType getType() {
        return OperatorType.MAPJOIN;
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        super.closeOp(abort);
        this.emptyList = null;
        this.joinKeys = null;
    }
}

