/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.workloadmanagement.pool.alter;

import java.io.IOException;
import org.apache.hadoop.hive.metastore.api.WMNullablePool;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.workloadmanagement.pool.alter.AlterWMPoolDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class AlterWMPoolOperation
extends DDLOperation<AlterWMPoolDesc> {
    public AlterWMPoolOperation(DDLOperationContext context, AlterWMPoolDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException, IOException {
        WMNullablePool pool = new WMNullablePool(((AlterWMPoolDesc)this.desc).getResourcePlanName(), ((AlterWMPoolDesc)this.desc).getPoolPath());
        if (((AlterWMPoolDesc)this.desc).getAllocFraction() != null) {
            pool.setAllocFraction(((AlterWMPoolDesc)this.desc).getAllocFraction().doubleValue());
        }
        if (((AlterWMPoolDesc)this.desc).getQueryParallelism() != null) {
            pool.setQueryParallelism(((AlterWMPoolDesc)this.desc).getQueryParallelism().intValue());
        }
        if (((AlterWMPoolDesc)this.desc).getSchedulingPolicy() != null || ((AlterWMPoolDesc)this.desc).isRemoveSchedulingPolicy()) {
            pool.setIsSetSchedulingPolicy(true);
            pool.setSchedulingPolicy(((AlterWMPoolDesc)this.desc).getSchedulingPolicy());
        }
        if (((AlterWMPoolDesc)this.desc).getNewPath() != null) {
            pool.setPoolPath(((AlterWMPoolDesc)this.desc).getNewPath());
        }
        this.context.getDb().alterWMPool(pool, ((AlterWMPoolDesc)this.desc).getPoolPath());
        return 0;
    }
}

