/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.view.materialized.alter.rewrite;

import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Alter Materialized View Rewrite", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class AlterMaterializedViewRewriteDesc
implements DDLDesc.DDLDescWithWriteId {
    private final String fqMaterializedViewName;
    private final boolean rewriteEnable;

    public AlterMaterializedViewRewriteDesc(String fqMaterializedViewName, boolean rewriteEnable) {
        this.fqMaterializedViewName = fqMaterializedViewName;
        this.rewriteEnable = rewriteEnable;
    }

    @Explain(displayName="name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getMaterializedViewName() {
        return this.fqMaterializedViewName;
    }

    @Explain(displayName="enable", displayOnlyOnTrue=true, explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public boolean isRewriteEnable() {
        return this.rewriteEnable;
    }

    @Explain(displayName="disable", displayOnlyOnTrue=true, explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public boolean isRewriteDisable() {
        return !this.rewriteEnable;
    }

    @Override
    public void setWriteId(long writeId) {
    }

    @Override
    public String getFullTableName() {
        return this.fqMaterializedViewName;
    }

    @Override
    public boolean mayNeedWriteId() {
        return true;
    }
}

