/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.misc.touch;

import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.CommonTree;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.ddl.table.misc.touch.AlterTableTouchDesc;
import org.apache.hadoop.hive.ql.ddl.table.partition.PartitionUtils;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={900})
public class AlterTableTouchAnalyzer
extends AbstractAlterTableAnalyzer {
    public AlterTableTouchAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected void analyzeCommand(TableName tableName, Map<String, String> partitionSpecFromFramework, ASTNode command) throws SemanticException {
        Table table = this.getTable(tableName);
        this.validateAlterTableType(table, AlterTableType.TOUCH, false);
        this.inputs.add(new ReadEntity(table));
        List<Map<String, String>> partitionSpecs = this.getPartitionSpecs(table, (CommonTree)command);
        if (partitionSpecs.isEmpty()) {
            AlterTableTouchDesc desc = new AlterTableTouchDesc(tableName.getNotEmptyDbTable(), null);
            this.outputs.add(new WriteEntity(table, WriteEntity.WriteType.DDL_NO_LOCK));
            this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
        } else {
            PartitionUtils.addTablePartsOutputs(this.db, this.outputs, table, partitionSpecs, false, WriteEntity.WriteType.DDL_NO_LOCK);
            for (Map<String, String> partitionSpec : partitionSpecs) {
                AlterTableTouchDesc desc = new AlterTableTouchDesc(tableName.getNotEmptyDbTable(), partitionSpec);
                this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
            }
        }
    }
}

