/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.convert;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableOperation;
import org.apache.hadoop.hive.ql.ddl.table.convert.AlterTableConvertDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class AlterTableConvertOperation
extends AbstractAlterTableOperation<AlterTableConvertDesc> {
    public AlterTableConvertOperation(DDLOperationContext context, AlterTableConvertDesc desc) {
        super(context, desc);
    }

    @Override
    protected void doAlteration(Table table, Partition partition) throws HiveException {
        String convertType = ((AlterTableConvertDesc)this.desc).getConvertSpec().getTargetType();
        ConversionFormats format = ConversionFormats.valueOf(convertType.toUpperCase());
        this.validatePropertiesAlreadyExist(format, table.getParameters());
        table.getParameters().putAll(format.properties());
        if (((AlterTableConvertDesc)this.desc).getConvertSpec().getTblProperties() != null) {
            table.getParameters().putAll(((AlterTableConvertDesc)this.desc).getConvertSpec().getTblProperties());
        }
    }

    private void validatePropertiesAlreadyExist(ConversionFormats targetFormat, Map<String, String> originalParameters) throws SemanticException {
        boolean needsMigration = false;
        for (Map.Entry<String, String> entry : targetFormat.properties().entrySet()) {
            String originalParam = originalParameters.get(entry.getKey());
            if (originalParam != null && originalParam.equalsIgnoreCase(entry.getValue())) continue;
            needsMigration = true;
            break;
        }
        if (!needsMigration) {
            throw new SemanticException("Can not convert table to " + String.valueOf((Object)targetFormat) + " ,Table is already of that format");
        }
    }

    public static enum ConversionFormats {
        ICEBERG((Map<String, String>)ImmutableMap.of((Object)"storage_handler", (Object)"org.apache.iceberg.mr.hive.HiveIcebergStorageHandler")),
        ACID((Map<String, String>)ImmutableMap.of((Object)"transactional", (Object)"true", (Object)"transactional_properties", (Object)"default"));

        private final Map<String, String> properties;

        private ConversionFormats(Map<String, String> properties) {
            this.properties = properties;
        }

        public Map<String, String> properties() {
            return this.properties;
        }
    }
}

