/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.catalog.desc;

import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Describe Catalog", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class DescCatalogDesc
implements DDLDesc,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DESC_CATALOG_SCHEMA = "cat_name,comment,location#string:string:string";
    public static final String DESC_CATALOG_SCHEMA_EXTENDED = "cat_name,comment,location,create_time#string:string:string:string";
    private final String resFile;
    private final String catName;
    private final boolean isExtended;

    public DescCatalogDesc(Path resFile, String catName, boolean isExtended) {
        this.resFile = resFile.toString();
        this.catName = catName;
        this.isExtended = isExtended;
    }

    @Explain(displayName="result file", explainLevels={Explain.Level.EXTENDED})
    public String getResFile() {
        return this.resFile;
    }

    @Explain(displayName="catalog", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getCatName() {
        return this.catName;
    }

    @Explain(displayName="extended", displayOnlyOnTrue=true, explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public boolean isExtended() {
        return this.isExtended;
    }

    public String getSchema() {
        return this.isExtended ? DESC_CATALOG_SCHEMA_EXTENDED : DESC_CATALOG_SCHEMA;
    }
}

