/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.druid;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Objects;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.adapter.druid.Granularity;
import org.apache.calcite.avatica.util.TimeUnitRange;

public class Granularities {
    private Granularities() {
    }

    public static Granularity all() {
        return AllGranularity.INSTANCE;
    }

    public static Granularity createGranularity(TimeUnitRange timeUnit, String timeZone) {
        switch (timeUnit) {
            case YEAR: {
                return new PeriodGranularity(Granularity.Type.YEAR, "P1Y", timeZone);
            }
            case QUARTER: {
                return new PeriodGranularity(Granularity.Type.QUARTER, "P3M", timeZone);
            }
            case MONTH: {
                return new PeriodGranularity(Granularity.Type.MONTH, "P1M", timeZone);
            }
            case WEEK: {
                return new PeriodGranularity(Granularity.Type.WEEK, "P1W", timeZone);
            }
            case DAY: {
                return new PeriodGranularity(Granularity.Type.DAY, "P1D", timeZone);
            }
            case HOUR: {
                return new PeriodGranularity(Granularity.Type.HOUR, "PT1H", timeZone);
            }
            case MINUTE: {
                return new PeriodGranularity(Granularity.Type.MINUTE, "PT1M", timeZone);
            }
            case SECOND: {
                return new PeriodGranularity(Granularity.Type.SECOND, "PT1S", timeZone);
            }
        }
        throw new AssertionError(timeUnit);
    }

    private static class PeriodGranularity
    implements Granularity {
        private final Granularity.Type type;
        private final String period;
        private final String timeZone;

        private PeriodGranularity(Granularity.Type type, String period, String timeZone) {
            this.type = Objects.requireNonNull(type, "type");
            this.period = Objects.requireNonNull(period, "period");
            this.timeZone = Objects.requireNonNull(timeZone, "timeZone");
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("type", "period");
            DruidQuery.writeFieldIf(generator, "period", this.period);
            DruidQuery.writeFieldIf(generator, "timeZone", this.timeZone);
            generator.writeEndObject();
        }

        @Override
        public Granularity.Type getType() {
            return this.type;
        }
    }

    private static enum AllGranularity implements Granularity
    {
        INSTANCE;


        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeObject((Object)"all");
        }

        @Override
        public Granularity.Type getType() {
            return Granularity.Type.ALL;
        }
    }
}

