/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.vector;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.mr.hive.vector.HiveRow;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class HiveValueConverter {
    private HiveValueConverter() {
    }

    public static Record convert(Schema schema, HiveRow row) {
        return HiveValueConverter.convert(schema.asStruct(), row);
    }

    public static Object convert(Type type, Object object) {
        if (object == null) {
            return null;
        }
        switch (type.typeId()) {
            case STRUCT: {
                return HiveValueConverter.convert(type.asStructType(), (HiveRow)object);
            }
            case LIST: {
                ArrayList<Object> convertedList = Lists.newArrayList();
                List list = (List)object;
                for (Object element : list) {
                    convertedList.add(HiveValueConverter.convert(type.asListType().elementType(), element));
                }
                return convertedList;
            }
            case MAP: {
                LinkedHashMap<Object, Object> convertedMap = Maps.newLinkedHashMap();
                Map map = (Map)object;
                for (Map.Entry entry : map.entrySet()) {
                    convertedMap.put(HiveValueConverter.convert(type.asMapType().keyType(), entry.getKey()), HiveValueConverter.convert(type.asMapType().valueType(), entry.getValue()));
                }
                return convertedMap;
            }
            case DATE: {
                Date hiveDate = (Date)object;
                return LocalDate.of(hiveDate.getYear(), hiveDate.getMonth(), hiveDate.getDay());
            }
            case TIMESTAMP: {
                if (Types.TimestampType.withZone() == type) {
                    throw new UnsupportedOperationException("Not supported with vectorization.");
                }
                return LocalDateTime.ofInstant(((Timestamp)object).toSqlTimestamp().toInstant(), ZoneId.of("UTC"));
            }
            case BINARY: {
                return ByteBuffer.wrap((byte[])object);
            }
            case FIXED: {
                return (byte[])object;
            }
            case DECIMAL: {
                BigDecimal bigDecimal = ((HiveDecimal)object).bigDecimalValue();
                if (bigDecimal.longValue() == 0L) {
                    return bigDecimal.setScale(((Types.DecimalType)type).scale());
                }
                return bigDecimal;
            }
            case INTEGER: 
            case BOOLEAN: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: {
                return object;
            }
        }
        throw new UnsupportedOperationException("Not a supported type: " + String.valueOf(type));
    }

    private static Record convert(Types.StructType struct, HiveRow row) {
        if (row == null) {
            return null;
        }
        GenericRecord record = GenericRecord.create(struct);
        List<Types.NestedField> fields = struct.fields();
        block5: for (int i = 0; i < fields.size(); ++i) {
            Types.NestedField field = fields.get(i);
            Type fieldType = field.type();
            switch (fieldType.typeId()) {
                case STRUCT: {
                    record.set(i, HiveValueConverter.convert((Type)fieldType.asStructType(), row.get(i)));
                    continue block5;
                }
                case LIST: {
                    record.set(i, HiveValueConverter.convert(fieldType.asListType(), row.get(i)));
                    continue block5;
                }
                case MAP: {
                    record.set(i, HiveValueConverter.convert(fieldType.asMapType(), row.get(i)));
                    continue block5;
                }
                default: {
                    record.set(i, HiveValueConverter.convert(fieldType, row.get(i)));
                }
            }
        }
        return record;
    }
}

