/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.io.PositionDeleteInfo;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.SerializationUtil;
import org.apache.iceberg.util.StructProjection;

public class IcebergAcidUtil {
    private static final Types.NestedField PARTITION_STRUCT_META_COL = null;
    private static final Map<Types.NestedField, Integer> FILE_READ_META_COLS = Maps.newLinkedHashMap();
    private static final Map<String, Types.NestedField> VIRTUAL_COLS_TO_META_COLS = Maps.newLinkedHashMap();
    public static final String META_TABLE_PROPERTY = "metaTable";
    private static final Map<Types.NestedField, Integer> DELETE_FILE_META_COLS = Maps.newLinkedHashMap();
    public static final Integer PARTITION_PROJECTION_COLUMN_ID = 0x7FFFFFF9;
    private static final String PARTITION_PROJECTION_COLUMN_NAME = "_partition_projection";
    private static final Types.NestedField PARTITION_HASH_META_COL;
    public static final Types.NestedField PARTITION_PROJECTION;
    private static final Map<Types.NestedField, Integer> SERDE_META_COLS;

    private IcebergAcidUtil() {
    }

    public static Schema createFileReadSchemaWithVirtualColums(List<Types.NestedField> dataCols, Table table) {
        ArrayList<Types.NestedField> cols = Lists.newArrayListWithCapacity(dataCols.size() + FILE_READ_META_COLS.size());
        FILE_READ_META_COLS.forEach((metaCol, index) -> {
            if (metaCol == PARTITION_STRUCT_META_COL) {
                cols.add(MetadataColumns.metadataColumn(table, "_partition"));
            } else {
                cols.add((Types.NestedField)metaCol);
            }
        });
        cols.addAll(dataCols);
        return new Schema(cols);
    }

    public static Schema createSerdeSchemaForDelete(List<Types.NestedField> dataCols) {
        ArrayList<Types.NestedField> cols = Lists.newArrayListWithCapacity(dataCols.size() + SERDE_META_COLS.size());
        SERDE_META_COLS.forEach((metaCol, index) -> cols.add((Types.NestedField)metaCol));
        cols.addAll(dataCols);
        return new Schema(cols);
    }

    public static PositionDelete<Record> getPositionDelete(Record rec, Record rowData) {
        int dataOffset;
        PositionDelete<Record> positionDelete = PositionDelete.create();
        String filePath = rec.get(SERDE_META_COLS.get(MetadataColumns.FILE_PATH), String.class);
        Long filePosition = rec.get(SERDE_META_COLS.get(MetadataColumns.ROW_POSITION), Long.class);
        for (int i = dataOffset = SERDE_META_COLS.size(); i < rec.size(); ++i) {
            rowData.set(i - dataOffset, rec.get(i));
        }
        positionDelete.set(filePath, (Long)ObjectUtils.defaultIfNull((Object)filePosition, (Object)0L), rowData);
        return positionDelete;
    }

    public static Schema createSerdeSchemaForUpdate(List<Types.NestedField> dataCols) {
        ArrayList<Types.NestedField> cols = Lists.newArrayListWithCapacity(dataCols.size() + SERDE_META_COLS.size());
        SERDE_META_COLS.forEach((metaCol, index) -> cols.add((Types.NestedField)metaCol));
        cols.addAll(dataCols.stream().map(f -> Types.NestedField.optional(1147483545 + f.fieldId(), "__old_value_for_" + f.name(), f.type())).toList());
        cols.addAll(dataCols);
        return new Schema(cols);
    }

    public static int parseSpecId(Record rec) {
        return rec.get(FILE_READ_META_COLS.get(MetadataColumns.SPEC_ID), Integer.class);
    }

    public static long computePartitionHash(Record rec) {
        StructProjection part = rec.get(FILE_READ_META_COLS.get(PARTITION_STRUCT_META_COL), StructProjection.class);
        return IcebergAcidUtil.computeHash(part);
    }

    public static PartitionKey parsePartitionKey(Record rec) {
        String serializedStr = rec.get(SERDE_META_COLS.get(PARTITION_PROJECTION), String.class);
        return (PartitionKey)SerializationUtil.deserializeFromBase64(serializedStr);
    }

    public static String getSerializedPartitionKey(StructLike structLike, PartitionSpec partitionSpec) {
        PartitionKey partitionKey = new PartitionKey(partitionSpec, partitionSpec.schema());
        if (structLike != null) {
            for (int idx = 0; idx < structLike.size(); ++idx) {
                partitionKey.set(idx, structLike.get(idx, Object.class));
            }
        }
        return SerializationUtil.serializeToBase64(partitionKey);
    }

    public static String parseFilePath(Record rec) {
        return rec.get(FILE_READ_META_COLS.get(MetadataColumns.FILE_PATH), String.class);
    }

    public static String getFilePath(Record rec) {
        return rec.get(DELETE_FILE_META_COLS.get(MetadataColumns.FILE_PATH), String.class);
    }

    public static long parseFilePosition(Record rec) {
        return rec.get(FILE_READ_META_COLS.get(MetadataColumns.ROW_POSITION), Long.class);
    }

    public static long getDeleteFilePosition(Record rec) {
        return rec.get(DELETE_FILE_META_COLS.get(MetadataColumns.ROW_POSITION), Long.class);
    }

    public static long computeHash(StructLike struct) {
        long partHash = -1L;
        if (struct != null) {
            Object[] partFields = new Object[struct.size()];
            for (int i = 0; i < struct.size(); ++i) {
                partFields[i] = struct.get(i, Object.class);
            }
            partHash = Objects.hash(partFields);
        }
        return partHash;
    }

    public static void copyFields(GenericRecord source, int start, int len, GenericRecord target) {
        int sourceIdx = start;
        for (int targetIdx = 0; targetIdx < len; ++targetIdx) {
            target.set(targetIdx, source.get(sourceIdx));
            ++sourceIdx;
        }
    }

    static {
        DELETE_FILE_META_COLS.put(MetadataColumns.FILE_PATH, 0);
        DELETE_FILE_META_COLS.put(MetadataColumns.ROW_POSITION, 1);
        FILE_READ_META_COLS.put(MetadataColumns.SPEC_ID, 0);
        FILE_READ_META_COLS.put(PARTITION_STRUCT_META_COL, 1);
        FILE_READ_META_COLS.put(MetadataColumns.FILE_PATH, 2);
        FILE_READ_META_COLS.put(MetadataColumns.ROW_POSITION, 3);
        VIRTUAL_COLS_TO_META_COLS.put(VirtualColumn.PARTITION_SPEC_ID.getName(), MetadataColumns.SPEC_ID);
        VIRTUAL_COLS_TO_META_COLS.put(VirtualColumn.PARTITION_HASH.getName(), PARTITION_STRUCT_META_COL);
        VIRTUAL_COLS_TO_META_COLS.put(VirtualColumn.FILE_PATH.getName(), MetadataColumns.FILE_PATH);
        VIRTUAL_COLS_TO_META_COLS.put(VirtualColumn.ROW_POSITION.getName(), MetadataColumns.ROW_POSITION);
        PARTITION_HASH_META_COL = Types.NestedField.required(0x7FFFFFFA, "_partition", Types.LongType.get());
        PARTITION_PROJECTION = Types.NestedField.required(PARTITION_PROJECTION_COLUMN_ID, PARTITION_PROJECTION_COLUMN_NAME, Types.StringType.get());
        SERDE_META_COLS = Maps.newLinkedHashMap();
        SERDE_META_COLS.put(MetadataColumns.SPEC_ID, 0);
        SERDE_META_COLS.put(PARTITION_HASH_META_COL, 1);
        SERDE_META_COLS.put(MetadataColumns.FILE_PATH, 2);
        SERDE_META_COLS.put(MetadataColumns.ROW_POSITION, 3);
        SERDE_META_COLS.put(PARTITION_PROJECTION, 4);
    }

    private static final class GenericRecordBuilder<T> {
        private final GenericRecord current;

        GenericRecordBuilder(Schema schema) {
            this.current = GenericRecord.create(schema);
        }

        public GenericRecordBuilder<T> withSpecId(int specId) {
            this.current.set(SERDE_META_COLS.get(MetadataColumns.SPEC_ID), specId);
            return this;
        }

        public GenericRecordBuilder<T> withPartitionHash(long partitionHash) {
            this.current.set(SERDE_META_COLS.get(PARTITION_HASH_META_COL), partitionHash);
            return this;
        }

        public GenericRecordBuilder<T> withFilePath(String filePath) {
            this.current.set(SERDE_META_COLS.get(MetadataColumns.FILE_PATH), filePath);
            return this;
        }

        public GenericRecordBuilder<T> withFilePosition(long filePosition) {
            this.current.set(SERDE_META_COLS.get(MetadataColumns.ROW_POSITION), filePosition);
            return this;
        }

        public GenericRecordBuilder<T> withPartitionKey(String serializedPartitionKey) {
            this.current.set(SERDE_META_COLS.get(PARTITION_PROJECTION), serializedPartitionKey);
            return this;
        }

        public T build() {
            return (T)this.current;
        }
    }

    public static class MergeTaskVirtualColumnAwareIterator<T>
    implements CloseableIterator<T> {
        private final CloseableIterator<T> currentIterator;
        private final GenericRecordBuilder<T> recordBuilder;
        private final PartitionSpec partitionSpec;
        private final StructLike partition;

        public MergeTaskVirtualColumnAwareIterator(CloseableIterator<T> currentIterator, Schema expectedSchema, ContentFile<?> contentFile, Table table) {
            this.currentIterator = currentIterator;
            this.partition = contentFile.partition();
            this.recordBuilder = new GenericRecordBuilder(new Schema(expectedSchema.columns().subList(0, expectedSchema.columns().size())));
            this.partitionSpec = table.specs().get(contentFile.specId());
        }

        @Override
        public void close() throws IOException {
            this.currentIterator.close();
        }

        @Override
        public boolean hasNext() {
            return this.currentIterator.hasNext();
        }

        @Override
        public T next() {
            Object next = this.currentIterator.next();
            GenericRecord rec = (GenericRecord)next;
            return this.recordBuilder.withSpecId(this.partitionSpec.specId()).withPartitionHash(IcebergAcidUtil.computeHash(this.partition)).withFilePath(IcebergAcidUtil.getFilePath(rec)).withFilePosition(IcebergAcidUtil.getDeleteFilePosition(rec)).withPartitionKey(IcebergAcidUtil.getSerializedPartitionKey(this.partition, this.partitionSpec)).build();
        }
    }

    public static class VirtualColumnAwareIterator<T>
    implements CloseableIterator<T> {
        private final CloseableIterator<T> currentIterator;
        private final GenericRecord current;
        private final Configuration conf;

        public VirtualColumnAwareIterator(CloseableIterator<T> currentIterator, Schema expectedSchema, Configuration conf) {
            this.currentIterator = currentIterator;
            this.current = GenericRecord.create(new Schema(expectedSchema.columns().subList(4, expectedSchema.columns().size())));
            this.conf = conf;
        }

        @Override
        public void close() throws IOException {
            this.currentIterator.close();
        }

        @Override
        public boolean hasNext() {
            return this.currentIterator.hasNext();
        }

        @Override
        public T next() {
            Object next = this.currentIterator.next();
            GenericRecord rec = (GenericRecord)next;
            IcebergAcidUtil.copyFields(rec, FILE_READ_META_COLS.size(), this.current.size(), this.current);
            PositionDeleteInfo.setIntoConf((Configuration)this.conf, (int)IcebergAcidUtil.parseSpecId(rec), (long)IcebergAcidUtil.computePartitionHash(rec), (String)IcebergAcidUtil.parseFilePath(rec), (long)IcebergAcidUtil.parseFilePosition(rec), (String)"");
            return (T)this.current;
        }
    }
}

