/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.catalog;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;

public interface SupportsNamespaces {
    default public void createNamespace(Namespace namespace) {
        this.createNamespace(namespace, ImmutableMap.of());
    }

    public void createNamespace(Namespace var1, Map<String, String> var2);

    default public List<Namespace> listNamespaces() {
        return this.listNamespaces(Namespace.empty());
    }

    public List<Namespace> listNamespaces(Namespace var1) throws NoSuchNamespaceException;

    public Map<String, String> loadNamespaceMetadata(Namespace var1) throws NoSuchNamespaceException;

    public boolean dropNamespace(Namespace var1) throws NamespaceNotEmptyException;

    public boolean setProperties(Namespace var1, Map<String, String> var2) throws NoSuchNamespaceException;

    public boolean removeProperties(Namespace var1, Set<String> var2) throws NoSuchNamespaceException;

    default public boolean namespaceExists(Namespace namespace) {
        try {
            this.loadNamespaceMetadata(namespace);
            return true;
        }
        catch (NoSuchNamespaceException e) {
            return false;
        }
    }
}

