/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.iceberg.org.apache.avro.util;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Period;
import java.time.chrono.ChronoPeriod;
import java.time.chrono.IsoChronology;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class TimePeriod
implements TemporalAmount,
Serializable {
    private static final long MAX_UNSIGNED_INT = 0xFFFFFFFFL;
    private static final long MONTHS_PER_YEAR = 12L;
    private static final long MONTHS_PER_DECADE = 120L;
    private static final long MONTHS_PER_CENTURY = 1200L;
    private static final long MONTHS_PER_MILLENNIUM = 12000L;
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final long MILLIS_PER_MINUTE = 60000L;
    private static final long MILLIS_PER_HOUR = 3600000L;
    private static final long MILLIS_IN_HALF_DAY = 43200000L;
    private static final long MICROS_PER_MILLI = 1000L;
    private static final long NANOS_PER_MILLI = 1000000L;
    private final long months;
    private final long days;
    private final long millis;

    public static TimePeriod from(TemporalAmount amount) {
        if (Objects.requireNonNull(amount, "amount") instanceof TimePeriod) {
            return (TimePeriod)amount;
        }
        if (amount instanceof ChronoPeriod && !IsoChronology.INSTANCE.equals(((ChronoPeriod)amount).getChronology())) {
            throw new DateTimeException("TimePeriod requires ISO chronology: " + String.valueOf(amount));
        }
        long months = 0L;
        long days = 0L;
        long millis = 0L;
        block16: for (TemporalUnit unit : amount.getUnits()) {
            if (unit instanceof ChronoUnit) {
                long unitAmount = amount.get(unit);
                switch ((ChronoUnit)unit) {
                    case MILLENNIA: {
                        months = TimePeriod.unsignedInt(months + unitAmount * 12000L);
                        break;
                    }
                    case CENTURIES: {
                        months = TimePeriod.unsignedInt(months + unitAmount * 1200L);
                        break;
                    }
                    case DECADES: {
                        months = TimePeriod.unsignedInt(months + unitAmount * 120L);
                        break;
                    }
                    case YEARS: {
                        months = TimePeriod.unsignedInt(months + unitAmount * 12L);
                        break;
                    }
                    case MONTHS: {
                        months = TimePeriod.unsignedInt(months + unitAmount);
                        break;
                    }
                    case WEEKS: {
                        days = TimePeriod.unsignedInt(days + unitAmount * 7L);
                        break;
                    }
                    case DAYS: {
                        days = TimePeriod.unsignedInt(days + unitAmount);
                        break;
                    }
                    case HALF_DAYS: {
                        days = TimePeriod.unsignedInt(days + unitAmount / 2L);
                        if (unitAmount % 2L == 0L) continue block16;
                        millis = TimePeriod.unsignedInt(millis + 43200000L);
                        break;
                    }
                    case HOURS: {
                        millis = TimePeriod.unsignedInt(millis + unitAmount * 3600000L);
                        break;
                    }
                    case MINUTES: {
                        millis = TimePeriod.unsignedInt(millis + unitAmount * 60000L);
                        break;
                    }
                    case SECONDS: {
                        millis = TimePeriod.unsignedInt(millis + unitAmount * 1000L);
                        break;
                    }
                    case MILLIS: {
                        millis = TimePeriod.unsignedInt(millis + unitAmount);
                        break;
                    }
                    case MICROS: {
                        if (unitAmount % 1000L != 0L) {
                            throw new DateTimeException("Cannot add " + unitAmount + " microseconds: not a whole number of milliseconds");
                        }
                        millis = TimePeriod.unsignedInt(millis + unitAmount / 1000L);
                        break;
                    }
                    case NANOS: {
                        if (unitAmount % 1000000L != 0L) {
                            throw new DateTimeException("Cannot add " + unitAmount + " nanoseconds: not a whole number of milliseconds");
                        }
                        millis = TimePeriod.unsignedInt(millis + unitAmount / 1000000L);
                        break;
                    }
                    default: {
                        throw new UnsupportedTemporalTypeException("Unsupported unit: " + String.valueOf(unit));
                    }
                }
                continue;
            }
            throw new UnsupportedTemporalTypeException("Unsupported unit: " + String.valueOf(unit));
        }
        return new TimePeriod(months, days, millis);
    }

    public static TimePeriod of(long months, long days, long millis) {
        return new TimePeriod(TimePeriod.unsignedInt(months), TimePeriod.unsignedInt(days), TimePeriod.unsignedInt(millis));
    }

    private static long unsignedInt(long number) {
        if (number != (number & 0xFFFFFFFFL)) {
            throw new ArithmeticException("Overflow/underflow of unsigned int");
        }
        return number;
    }

    private TimePeriod(long months, long days, long millis) {
        this.months = months;
        this.days = days;
        this.millis = millis;
    }

    public Duration toDuration() {
        return Duration.from(this);
    }

    public Period toPeriod() {
        if (this.isDateBased()) {
            int yearsAsInt = (int)(this.months / 12L);
            int monthsAsInt = (int)(this.months % 12L);
            int daysAsInt = (int)this.days;
            if (this.days != (long)daysAsInt) {
                throw new DateTimeException("Too many days: a Period can contain at most 2147483647 days.");
            }
            return Period.ofYears(yearsAsInt).withMonths(monthsAsInt).withDays(daysAsInt);
        }
        throw new DateTimeException("Cannot convert this TimePeriod to a Period: is not date based");
    }

    public boolean isDateBased() {
        return this.millis == 0L;
    }

    public boolean isTimeBased() {
        return this.months == 0L && this.days == 0L;
    }

    public long getMonths() {
        return this.months;
    }

    public long getDays() {
        return this.days;
    }

    public long getMillis() {
        return this.millis;
    }

    @Override
    public long get(TemporalUnit unit) {
        if (unit == ChronoUnit.MONTHS) {
            return this.months;
        }
        if (unit == ChronoUnit.DAYS) {
            return this.days;
        }
        if (unit == ChronoUnit.MILLIS) {
            return this.millis;
        }
        throw new UnsupportedTemporalTypeException("Unsupported unit: " + String.valueOf(unit));
    }

    @Override
    public List<TemporalUnit> getUnits() {
        ArrayList<ChronoUnit> units = new ArrayList<ChronoUnit>();
        if (this.months != 0L) {
            units.add(ChronoUnit.MONTHS);
        }
        if (this.days != 0L) {
            units.add(ChronoUnit.DAYS);
        }
        if (this.millis != 0L) {
            units.add(ChronoUnit.MILLIS);
        }
        return Collections.unmodifiableList(units);
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        return this.addTo(temporal, this.months, this.days, this.millis);
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        return this.addTo(temporal, -this.months, -this.days, -this.millis);
    }

    private Temporal addTo(Temporal temporal, long months, long days, long millis) {
        if (months != 0L) {
            temporal = temporal.plus(months, ChronoUnit.MONTHS);
        }
        if (days != 0L) {
            temporal = temporal.plus(days, ChronoUnit.DAYS);
        }
        if (millis != 0L) {
            temporal = temporal.plus(millis, ChronoUnit.MILLIS);
        }
        return temporal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimePeriod that = (TimePeriod)o;
        return this.months == that.months && this.days == that.days && this.millis == that.millis;
    }

    public int hashCode() {
        return Objects.hash(this.months, this.days, this.millis);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("P");
        if (this.months != 0L) {
            int years = (int)(this.months / 12L);
            int monthsLeft = (int)(this.months % 12L);
            if (years != 0) {
                buffer.append(years).append("Y");
            }
            if (monthsLeft != 0) {
                buffer.append(monthsLeft).append("M");
            }
        }
        if (this.days != 0L || this.months == 0L && this.millis == 0L) {
            buffer.append(this.days);
        }
        if (this.millis != 0L) {
            int seconds;
            long millisLeft = this.millis;
            int hours = (int)(millisLeft / 3600000L);
            int minutes = (int)((millisLeft -= 3600000L * (long)hours) / 60000L);
            millisLeft -= 60000L * (long)minutes;
            if ((millisLeft -= 1000L * (long)(seconds = (int)(millisLeft / 1000L))) != 0L) {
                buffer.append(String.format("T%02d:%02d:%02d.%03d", hours, minutes, seconds, millisLeft));
            } else if (seconds != 0) {
                buffer.append(String.format("T%02d:%02d:%02d", hours, minutes, seconds));
            } else if (minutes != 0) {
                buffer.append(String.format("T%02d:%02d", hours, minutes));
            } else {
                buffer.append(String.format("T%02d", hours));
            }
        }
        return buffer.toString();
    }
}

