/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.properties;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlFeatures;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.ObjectContext;
import org.apache.commons.jexl3.introspection.JexlPermissions;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.properties.PropertyException;
import org.apache.hadoop.hive.metastore.properties.PropertyMap;
import org.apache.hadoop.hive.metastore.properties.PropertySchema;
import org.apache.hadoop.hive.metastore.properties.PropertyStore;
import org.apache.hadoop.hive.metastore.properties.PropertyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PropertyManager {
    public static final Logger LOGGER = LoggerFactory.getLogger(PropertyManager.class);
    protected final Map<String, PropertyMap> dirtyMaps = new HashMap<String, PropertyMap>();
    protected final String namespace;
    protected final PropertyStore store;
    static final JexlEngine JEXL;
    private static final Map<String, Constructor<? extends PropertyManager>> NSMANAGERS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean declare(String ns, Class<? extends PropertyManager> pmClazz) {
        try {
            Map<String, Constructor<? extends PropertyManager>> map = NSMANAGERS;
            synchronized (map) {
                Constructor<? extends PropertyManager> ctor = NSMANAGERS.get(ns);
                if (ctor == null) {
                    ctor = pmClazz.getConstructor(String.class, PropertyStore.class);
                    NSMANAGERS.put(ns, ctor);
                    return true;
                }
                if (!Objects.equals(ctor.getDeclaringClass(), pmClazz)) {
                    LOGGER.error("namespace {} is already declared for {}", (Object)ns, (Object)pmClazz.getCanonicalName());
                }
            }
        }
        catch (NoSuchMethodException xnom) {
            LOGGER.error("namespace declaration failed: " + ns + ", " + pmClazz.getCanonicalName(), (Throwable)xnom);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PropertyManager create(String namespace, PropertyStore store) throws MetaException, NoSuchObjectException {
        Constructor<? extends PropertyManager> ctor;
        Map<String, Constructor<? extends PropertyManager>> map = NSMANAGERS;
        synchronized (map) {
            ctor = NSMANAGERS.get(namespace);
        }
        if (ctor == null) {
            throw new NoSuchObjectException("no PropertyManager namespace is declared, namespace " + namespace);
        }
        if (store == null) {
            throw new NoSuchObjectException("no PropertyStore exists " + namespace);
        }
        try {
            return ctor.newInstance(namespace, store);
        }
        catch (Exception xany) {
            LOGGER.error("PropertyManager creation failed " + namespace, (Throwable)xany);
            throw new MetaException("PropertyManager creation failed, namespace " + namespace);
        }
    }

    protected PropertyManager(String ns, PropertyStore store) {
        this.namespace = ns;
        this.store = store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        Map<String, PropertyMap> dirtyMaps;
        Map<String, PropertyMap> map = dirtyMaps = this.dirtyMaps;
        synchronized (map) {
            if (!dirtyMaps.isEmpty()) {
                this.store.saveProperties(dirtyMaps.entrySet().iterator());
                dirtyMaps.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        Map<String, PropertyMap> dirtyMaps;
        Map<String, PropertyMap> map = dirtyMaps = this.dirtyMaps;
        synchronized (map) {
            dirtyMaps.clear();
        }
    }

    public void importDefaultValues(Properties importsp) {
        importsp.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String schemaName;
            PropertySchema schema;
            String importName = k.toString();
            int dotPosition = importName.indexOf(".");
            if (dotPosition > 0 && (schema = this.getSchema(schemaName = importName.substring(0, dotPosition))) != null) {
                String propertyName = importName.substring(dotPosition + 1);
                schema.setDefaultValue(propertyName, v);
            }
        }));
    }

    public void setProperties(Properties map) {
        map.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.setProperty(k.toString(), v)));
    }

    public void setProperties(Map<String, ?> map) {
        map.forEach(this::setProperty);
    }

    public void setProperty(String key, Object value) {
        this.setProperty(this.splitKey(key), value);
    }

    public Object runScript(String src) throws PropertyException {
        try {
            JexlScript script = JEXL.createScript(src);
            ObjectContext context = new ObjectContext(JEXL, (Object)this);
            return script.execute((JexlContext)context);
        }
        catch (JexlException je) {
            throw new PropertyException("script failed", je);
        }
    }

    public Object getProperty(String key) {
        return this.getProperty(this.splitKey(key));
    }

    public String exportPropertyValue(String key) {
        return Objects.toString(this.fetchPropertyValue(this.splitKey(key), true));
    }

    public Object getPropertyValue(String key) {
        return this.getPropertyValue(this.splitKey(key));
    }

    protected String[] splitKey(String key) {
        String[] splits = key.split("(?<!\\\\)\\.");
        if (splits.length < 1) {
            splits = new String[]{key};
        }
        return splits;
    }

    public PropertySchema getSchema(String name) {
        return null;
    }

    protected PropertySchema schemaOf(String[] keys) {
        return PropertySchema.NONE;
    }

    protected int getMapNameLength(String[] keys) {
        return keys.length - 1;
    }

    protected String mapKey(String name) {
        StringBuilder strb = new StringBuilder(this.namespace);
        if (name != null && !name.isEmpty()) {
            strb.append('.');
            strb.append(name);
        }
        return strb.toString();
    }

    protected String mapName(String key) {
        int dot = key.indexOf(46);
        return dot > 0 ? key.substring(dot + 1) : key;
    }

    protected String mapKey(String[] keys) {
        return this.mapKey(keys, this.getMapNameLength(keys));
    }

    protected String mapKey(String[] keys, int maxkl) {
        if (keys.length < 1) {
            throw new IllegalArgumentException("at least 1 key fragments expected");
        }
        StringBuilder strb = new StringBuilder(this.namespace);
        for (int k = 0; k < Math.min(maxkl, keys.length - 1); ++k) {
            strb.append('.');
            strb.append(keys[k]);
        }
        return strb.toString();
    }

    protected String propertyName(String[] keys) {
        return this.propertyName(keys, this.getMapNameLength(keys));
    }

    protected String propertyName(String[] keys, int maxkl) {
        if (keys.length < 1) {
            throw new IllegalArgumentException("at least 1 key fragments expected");
        }
        if (keys.length <= maxkl) {
            return keys[keys.length - 1];
        }
        StringBuilder strb = new StringBuilder(keys[maxkl]);
        for (int k = maxkl + 1; k < keys.length; ++k) {
            strb.append('.');
            strb.append(keys[k]);
        }
        return strb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String[] keys) {
        PropertyMap map;
        Map<String, PropertyMap> dirtyMaps;
        String mapKey = this.mapKey(keys);
        Map<String, PropertyMap> map2 = dirtyMaps = this.dirtyMaps;
        synchronized (map2) {
            map = dirtyMaps.get(mapKey);
        }
        if (map == null) {
            map = this.store.fetchProperties(mapKey, null);
        }
        if (map != null) {
            return map.getProperty(this.propertyName(keys));
        }
        return null;
    }

    public Object getPropertyValue(String[] keys) {
        return this.fetchPropertyValue(keys, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object fetchPropertyValue(String[] keys, boolean format) {
        PropertyType<?> type;
        PropertyMap map;
        Map<String, PropertyMap> dirtyMaps;
        String mapKey = this.mapKey(keys);
        Map<String, PropertyMap> map2 = dirtyMaps = this.dirtyMaps;
        synchronized (map2) {
            map = dirtyMaps.get(mapKey);
        }
        PropertySchema schema = this.schemaOf(keys);
        if (map == null) {
            map = this.store.fetchProperties(mapKey, s -> schema);
        }
        String propertyName = this.propertyName(keys);
        Object value = null;
        if (map != null) {
            value = map.getPropertyValue(propertyName);
        } else if (schema != null) {
            value = schema.getDefaultValue(propertyName);
        }
        if (format && value != null && schema != null && (type = schema.getPropertyType(propertyName)) != null) {
            return type.format(value);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dropProperties(String mapName) {
        PropertyMap map;
        PropertyMap dirtyMap;
        Map<String, PropertyMap> dirtyMaps;
        String mapKey = this.mapKey(mapName);
        Map<String, PropertyMap> map2 = dirtyMaps = this.dirtyMaps;
        synchronized (map2) {
            dirtyMap = dirtyMaps.get(mapKey);
        }
        if (dirtyMap != null && Objects.equals(PropertyMap.DROPPED, dirtyMap.getDigest())) {
            map = dirtyMap;
        } else {
            UUID digest = this.store.fetchDigest(mapKey);
            if (digest == null) {
                return false;
            }
            map = new PropertyMap(this.schemaOf(this.splitKey(mapName + ".*")), PropertyMap.DROPPED);
            Map<String, PropertyMap> map3 = dirtyMaps;
            synchronized (map3) {
                dirtyMaps.put(mapName, map);
            }
        }
        if (map != dirtyMap) {
            dirtyMaps.put(mapName, map);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setProperty(String[] keys, Object value) {
        PropertyMap map;
        PropertyMap dirtyMap;
        Map<String, PropertyMap> dirtyMaps;
        PropertySchema schema = this.schemaOf(keys);
        String mapKey = this.mapKey(keys);
        Map<String, PropertyMap> map2 = dirtyMaps = this.dirtyMaps;
        synchronized (map2) {
            dirtyMap = dirtyMaps.get(mapKey);
        }
        if (dirtyMap != null) {
            map = dirtyMap;
        } else {
            map = this.store.fetchProperties(mapKey, s -> schema);
            if (map == null) {
                if (value == null) {
                    return;
                }
                map = new PropertyMap(schema);
            }
        }
        String propertyName = this.propertyName(keys);
        if (value != null) {
            map.putProperty(propertyName, value);
        } else {
            map.removeProperty(propertyName);
        }
        if (map != dirtyMap) {
            dirtyMaps.put(mapKey, map);
        }
    }

    public Map<String, PropertyMap> selectProperties(String namePrefix, String predicateStr, String ... projectStr) {
        return this.selectProperties(namePrefix, predicateStr, projectStr == null ? Collections.emptyList() : Arrays.asList(projectStr));
    }

    public Map<String, PropertyMap> selectProperties(String namePrefix, Function<PropertyMap, PropertyMap> selector) {
        String mapKey = this.mapKey(namePrefix);
        Map<String, PropertyMap> selected = this.store.selectProperties(mapKey, null, (String k) -> this.schemaOf(this.splitKey((String)k)));
        TreeMap<String, PropertyMap> maps = new TreeMap<String, PropertyMap>();
        Function<Object, Object> transform = selector == null ? Function.identity() : selector;
        selected.forEach((k, p) -> {
            PropertyMap dirtyMap = this.dirtyMaps.get(k);
            PropertyMap map = (PropertyMap)transform.apply(dirtyMap == null ? p.copy() : dirtyMap.copy());
            if (map != null && !map.isEmpty()) {
                maps.put(this.mapName((String)k), map);
            }
        });
        this.dirtyMaps.forEach((k, p) -> {
            PropertyMap map;
            if (k.startsWith(mapKey) && !selected.containsKey(k) && (map = (PropertyMap)transform.apply(p.copy())) != null && !map.isEmpty()) {
                maps.put(this.mapName((String)k), map);
            }
        });
        return maps;
    }

    public Map<String, PropertyMap> selectProperties(String namePrefix, String predicateStr, List<String> projectStr) {
        JexlExpression predicate;
        try {
            predicate = JEXL.createExpression(predicateStr);
        }
        catch (JexlException.Parsing xparse) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(predicateStr, (Throwable)xparse);
            }
            throw new PropertyException(xparse);
        }
        return this.selectProperties(namePrefix, predicate, projectStr);
    }

    public Map<String, PropertyMap> selectProperties(String namePrefix, JexlExpression predicate, String ... projectStr) {
        return this.selectProperties(namePrefix, predicate, projectStr == null ? Collections.emptyList() : Arrays.asList(projectStr));
    }

    public Map<String, PropertyMap> selectProperties(String namePrefix, JexlExpression predicate, List<String> projectStr) {
        Function<PropertyMap, PropertyMap> transform = map -> {
            Object result;
            MapWrapper wrapped = new MapWrapper((PropertyMap)map);
            try {
                result = predicate.evaluate((JexlContext)wrapped);
            }
            catch (JexlException xany) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(predicate.getSourceText(), (Throwable)xany);
                }
                throw new PropertyException(xany);
            }
            if (Boolean.TRUE.equals(result)) {
                if (projectStr == null || projectStr.isEmpty()) {
                    return map;
                }
                TreeMap<String, Object> projected = new TreeMap<String, Object>();
                for (String projectName : projectStr) {
                    if (map.getTypeOf(projectName) != null) {
                        Object value = map.getPropertyValue(projectName);
                        if (value == null) continue;
                        projected.put(projectName, value);
                        continue;
                    }
                    try {
                        JexlExpression projector = JEXL.createExpression(projectName);
                        Object evaluated = projector.evaluate((JexlContext)wrapped);
                        if (!(evaluated instanceof Map)) continue;
                        Map cast = (Map)evaluated;
                        projected.putAll(cast);
                    }
                    catch (JexlException xany) {
                        LOGGER.warn(projectName, (Throwable)xany);
                    }
                }
                return new PropertyMap((PropertyMap)map, (Map<String, Object>)projected);
            }
            return null;
        };
        return this.selectProperties(namePrefix, transform);
    }

    static {
        JexlFeatures features = new JexlFeatures().sideEffect(false).sideEffectGlobal(false);
        JexlPermissions p = JexlPermissions.RESTRICTED.compose(new String[]{"org.apache.hadoop.hive.metastore.properties.*"});
        JEXL = new JexlBuilder().features(features).permissions(p).create();
        NSMANAGERS = new HashMap<String, Constructor<? extends PropertyManager>>();
    }

    public static class MapWrapper
    implements JexlContext {
        PropertyMap map;

        MapWrapper(PropertyMap map) {
            this.map = map;
        }

        public Object get(String p) {
            return this.map.getPropertyValue(p);
        }

        public void set(String name, Object value) {
            this.map.putProperty(name, value);
        }

        public boolean has(String name) {
            return this.map.getTypeOf(name) != null;
        }
    }
}

