-- Upgrade MetaStore schema from 4.0.0-alpha-2 to 4.0.0-beta-1

-- HIVE-26221
ALTER TABLE "APP"."TAB_COL_STATS" ADD HISTOGRAM BLOB;
ALTER TABLE "APP"."PART_COL_STATS" ADD HISTOGRAM BLOB;

-- HIVE-26719
ALTER TABLE COMPACTION_QUEUE ADD CQ_NUMBER_OF_BUCKETS INTEGER;
ALTER TABLE COMPLETED_COMPACTIONS ADD CC_NUMBER_OF_BUCKETS INTEGER;

-- HIVE-26735
ALTER TABLE COMPACTION_QUEUE ADD CQ_ORDER_BY VARCHAR(4000);
ALTER TABLE COMPLETED_COMPACTIONS ADD CC_ORDER_BY VARCHAR(4000);

-- HIVE-26704
CREATE TABLE MIN_HISTORY_WRITE_ID (
  MH_TXNID bigint NOT NULL REFERENCES TXNS (TXN_ID),
  MH_DATABASE varchar(128) NOT NULL,
  MH_TABLE varchar(256) NOT NULL,
  MH_WRITEID bigint NOT NULL
);

-- HIVE-27165
DROP INDEX "APP"."TAB_COL_STATS_IDX";
CREATE INDEX "APP"."TAB_COL_STATS_IDX" ON "APP"."TAB_COL_STATS" ("DB_NAME", "TABLE_NAME", "COLUMN_NAME", "CAT_NAME");
DROP INDEX "APP"."PCS_STATS_IDX";
CREATE INDEX "APP"."PCS_STATS_IDX" ON "APP"."PART_COL_STATS" ("DB_NAME","TABLE_NAME","COLUMN_NAME","PARTITION_NAME","CAT_NAME");

-- HIVE-27186
ALTER TABLE "APP"."METASTORE_DB_PROPERTIES" ADD PROPERTYCONTENT BLOB;

-- HIVE-27457
UPDATE "SDS"
    SET "INPUT_FORMAT" = 'org.apache.hadoop.hive.kudu.KuduInputFormat', "OUTPUT_FORMAT" = 'org.apache.hadoop.hive.kudu.KuduOutputFormat'
    WHERE "SD_ID" IN (
        SELECT "TBLS"."SD_ID"
            FROM "TBLS"
            INNER JOIN "TABLE_PARAMS" ON "TBLS"."TBL_ID" = "TABLE_PARAMS"."TBL_ID"
            WHERE "TABLE_PARAMS"."PARAM_VALUE" LIKE '%KuduStorageHandler%'
    );

UPDATE "SERDES"
    SET "SERDES"."SLIB" = 'org.apache.hadoop.hive.kudu.KuduSerDe'
    WHERE "SERDE_ID" IN (
        SELECT "SDS"."SERDE_ID"
            FROM "TBLS"
            INNER JOIN "SDS" ON "TBLS"."SD_ID" = "SDS"."SD_ID"
            INNER JOIN "TABLE_PARAMS" ON "TBLS"."TBL_ID" = "TABLE_PARAMS"."TBL_ID"
            WHERE "TABLE_PARAMS"."PARAM_VALUE" LIKE '%KuduStorageHandler%'
    );

-- This needs to be the last thing done.  Insert any changes above this line.
UPDATE "APP".VERSION SET SCHEMA_VERSION='4.0.0-beta-1', VERSION_COMMENT='Hive release version 4.0.0-beta-1' where VER_ID=1;
