--! qt:dataset:src
DROP TABLE IF EXISTS t1_n72;
DROP TABLE IF EXISTS t2_n44;
DROP TABLE IF EXISTS t3_n15;
DROP TABLE IF EXISTS t4_n7;

CREATE TABLE t1_n72 (a int) PARTITIONED BY (d1 int);
CREATE TABLE t2_n44 (a int) PARTITIONED BY (d1 int);
CREATE TABLE t3_n15 (a int) PARTITIONED BY (d1 int, d2 int);
CREATE TABLE t4_n7 (a int) PARTITIONED BY (d1 int, d2 int);
CREATE TABLE t5_n3 (a int) PARTITIONED BY (d1 int, d2 int, d3 int);
CREATE TABLE t6_n2 (a int) PARTITIONED BY (d1 int, d2 int, d3 int);
set hive.mapred.mode=nonstrict;
INSERT OVERWRITE TABLE t1_n72 PARTITION (d1 = 1) SELECT key FROM src where key = 100 limit 1;
INSERT OVERWRITE TABLE t3_n15 PARTITION (d1 = 1, d2 = 1) SELECT key FROM src where key = 100 limit 1;
INSERT OVERWRITE TABLE t5_n3 PARTITION (d1 = 1, d2 = 1, d3=1) SELECT key FROM src where key = 100 limit 1;

SELECT * FROM t1_n72;

SELECT * FROM t3_n15;

ALTER TABLE t2_n44 EXCHANGE PARTITION (d1 = 1) WITH TABLE t1_n72;
SELECT * FROM t1_n72;
SELECT * FROM t2_n44;

ALTER TABLE t4_n7 EXCHANGE PARTITION (d1 = 1, d2 = 1) WITH TABLE t3_n15;
SELECT * FROM t3_n15;
SELECT * FROM t4_n7;

EXPLAIN ALTER TABLE t6_n2 EXCHANGE PARTITION (d1 = 1, d2 = 1, d3 = 1) WITH TABLE t5_n3;
ALTER TABLE t6_n2 EXCHANGE PARTITION (d1 = 1, d2 = 1, d3 = 1) WITH TABLE t5_n3;
SELECT * FROM t5_n3;
SELECT * FROM t6_n2;

